/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.NodeUtils;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.mapred.OutputCollector;

public class OperatorUtils {
    private static final Log LOG = LogFactory.getLog(OperatorUtils.class);

    public static <T> Set<T> findOperators(Operator<?> start, Class<T> clazz) {
        return OperatorUtils.findOperators(start, clazz, new HashSet());
    }

    public static <T> T findSingleOperator(Operator<?> start, Class<T> clazz) {
        Set<T> found = OperatorUtils.findOperators(start, clazz, new HashSet());
        return found.size() == 1 ? (T)found.iterator().next() : null;
    }

    public static <T> Set<T> findOperators(Collection<Operator<?>> starts, Class<T> clazz) {
        HashSet found = new HashSet();
        for (Operator<?> start : starts) {
            if (start == null) continue;
            OperatorUtils.findOperators(start, clazz, found);
        }
        return found;
    }

    private static <T> Set<T> findOperators(Operator<?> start, Class<T> clazz, Set<T> found) {
        if (clazz.isInstance(start)) {
            found.add(start);
        }
        if (start.getChildOperators() != null) {
            for (Operator<OperatorDesc> child : start.getChildOperators()) {
                OperatorUtils.findOperators(child, clazz, found);
            }
        }
        return found;
    }

    public static <T> Set<T> findOperatorsUpstream(Operator<?> start, Class<T> clazz) {
        return OperatorUtils.findOperatorsUpstream(start, clazz, new HashSet());
    }

    public static <T> T findSingleOperatorUpstream(Operator<?> start, Class<T> clazz) {
        Set<T> found = OperatorUtils.findOperatorsUpstream(start, clazz, new HashSet());
        return found.size() == 1 ? (T)found.iterator().next() : null;
    }

    public static <T> Set<T> findOperatorsUpstream(Collection<Operator<?>> starts, Class<T> clazz) {
        HashSet found = new HashSet();
        for (Operator<?> start : starts) {
            OperatorUtils.findOperatorsUpstream(start, clazz, found);
        }
        return found;
    }

    private static <T> Set<T> findOperatorsUpstream(Operator<?> start, Class<T> clazz, Set<T> found) {
        if (clazz.isInstance(start)) {
            found.add(start);
        }
        if (start.getParentOperators() != null) {
            for (Operator<OperatorDesc> parent : start.getParentOperators()) {
                OperatorUtils.findOperatorsUpstream(parent, clazz, found);
            }
        }
        return found;
    }

    public static void setChildrenCollector(List<Operator<? extends OperatorDesc>> childOperators, OutputCollector out) {
        if (childOperators == null) {
            return;
        }
        for (Operator<? extends OperatorDesc> op : childOperators) {
            if (op.getName().equals(ReduceSinkOperator.getOperatorName())) {
                op.setOutputCollector(out);
                continue;
            }
            OperatorUtils.setChildrenCollector(op.getChildOperators(), out);
        }
    }

    public static void setChildrenCollector(List<Operator<? extends OperatorDesc>> childOperators, Map<String, OutputCollector> outMap) {
        if (childOperators == null) {
            return;
        }
        for (Operator<? extends OperatorDesc> op : childOperators) {
            if (op.getName().equals(ReduceSinkOperator.getOperatorName())) {
                ReduceSinkOperator rs = (ReduceSinkOperator)op;
                if (!outMap.containsKey(((ReduceSinkDesc)rs.getConf()).getOutputName())) continue;
                LOG.info((Object)("Setting output collector: " + rs + " --> " + ((ReduceSinkDesc)rs.getConf()).getOutputName()));
                rs.setOutputCollector(outMap.get(((ReduceSinkDesc)rs.getConf()).getOutputName()));
                continue;
            }
            OperatorUtils.setChildrenCollector(op.getChildOperators(), outMap);
        }
    }

    public static void iterateParents(Operator<?> operator, NodeUtils.Function<Operator<?>> function) {
        OperatorUtils.iterateParents(operator, function, new HashSet());
    }

    private static void iterateParents(Operator<?> operator, NodeUtils.Function<Operator<?>> function, Set<Operator<?>> visited) {
        if (!visited.add(operator)) {
            return;
        }
        function.apply(operator);
        if (operator.getNumParent() > 0) {
            for (Operator<OperatorDesc> parent : operator.getParentOperators()) {
                OperatorUtils.iterateParents(parent, function, visited);
            }
        }
    }

    public static boolean sameRowSchema(Operator<?> operator1, Operator<?> operator2) {
        return operator1.getSchema().equals(operator2.getSchema());
    }
}

