/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.debug.Utils;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.WriteBuffers;

public final class BytesBytesMultiHashMap {
    public static final Log LOG = LogFactory.getLog(BytesBytesMultiHashMap.class);
    private WriteBuffers writeBuffers;
    private final float loadFactor;
    private int resizeThreshold;
    private int keysAssigned;
    private int largestNumberOfSteps = 0;
    private long[] refs;
    private int startingHashBitCount;
    private int hashBitCount;
    private int metricPutConflict = 0;
    private int metricExpands = 0;
    private int metricExpandsUs = 0;
    static final long MAX_WB_SIZE = 0x4000000000L;
    private static final int DEFAULT_MAX_CAPACITY = 0x40000000;
    private static final byte[] FOUR_ZEROES = new byte[]{0, 0, 0, 0};
    private static final byte[] FIVE_ZEROES = new byte[]{0, 0, 0, 0, 0};

    public BytesBytesMultiHashMap(int initialCapacity, float loadFactor, int wbSize, long memUsage, int defaultCapacity) {
        int maxCapacity;
        if (loadFactor < 0.0f || loadFactor > 1.0f) {
            throw new AssertionError((Object)"Load factor must be between (0, 1].");
        }
        assert (initialCapacity > 0);
        initialCapacity = Long.bitCount(initialCapacity) == 1 ? initialCapacity : BytesBytesMultiHashMap.nextHighestPowerOfTwo(initialCapacity);
        int n = maxCapacity = memUsage <= 0L ? 0x40000000 : (int)Math.min(0x40000000L, memUsage / 8L);
        if (maxCapacity < initialCapacity || initialCapacity <= 0) {
            initialCapacity = Long.bitCount(maxCapacity) == 1 ? maxCapacity : BytesBytesMultiHashMap.nextLowestPowerOfTwo(maxCapacity);
        }
        BytesBytesMultiHashMap.validateCapacity(initialCapacity);
        this.startingHashBitCount = 63 - Long.numberOfLeadingZeros(initialCapacity);
        this.loadFactor = loadFactor;
        this.refs = new long[initialCapacity];
        this.writeBuffers = new WriteBuffers(wbSize, 0x4000000000L);
        this.resizeThreshold = (int)((float)initialCapacity * this.loadFactor);
    }

    @VisibleForTesting
    BytesBytesMultiHashMap(int initialCapacity, float loadFactor, int wbSize) {
        this(initialCapacity, loadFactor, wbSize, -1L, 100000);
    }

    public void put(KvSource kv) throws SerDeException {
        if (this.resizeThreshold <= this.keysAssigned) {
            this.expandAndRehash();
        }
        this.writeBuffers.write(FOUR_ZEROES);
        long keyOffset = this.writeBuffers.getWritePoint();
        kv.writeKey(this.writeBuffers);
        int keyLength = (int)(this.writeBuffers.getWritePoint() - keyOffset);
        int hashCode = this.writeBuffers.hashCode(keyOffset, keyLength);
        int slot = this.findKeySlotToWrite(keyOffset, keyLength, hashCode);
        long ref = this.refs[slot];
        if (ref == 0L) {
            long tailOffset = this.writeFirstValueRecord(kv, keyOffset, keyLength, hashCode);
            byte stateByte = kv.updateStateByte(null);
            this.refs[slot] = Ref.makeFirstRef(tailOffset, stateByte, hashCode, this.startingHashBitCount);
            ++this.keysAssigned;
        } else {
            this.writeBuffers.setWritePoint(keyOffset - 4L);
            long lrPtrOffset = this.createOrGetListRecord(ref);
            long tailOffset = this.writeValueAndLength(kv);
            this.addRecordToList(lrPtrOffset, tailOffset);
            byte oldStateByte = Ref.getStateByte(ref);
            byte stateByte = kv.updateStateByte(oldStateByte);
            if (oldStateByte != stateByte) {
                ref = Ref.setStateByte(ref, stateByte);
            }
            this.refs[slot] = Ref.setListFlag(ref);
        }
    }

    public byte getValueRefs(byte[] key, int length, List<WriteBuffers.ByteSegmentRef> result) {
        result.clear();
        long ref = this.findKeyRefToRead(key, length);
        if (ref == 0L) {
            return 0;
        }
        boolean hasList = Ref.hasList(ref);
        long lrPtrOffset = hasList ? this.writeBuffers.getReadPoint() : 0L;
        this.writeBuffers.setReadPoint(this.getFirstRecordLengthsOffset(ref));
        int valueLength = (int)this.writeBuffers.readVLong();
        result.add(new WriteBuffers.ByteSegmentRef(Ref.getOffset(ref) - (long)valueLength, valueLength));
        byte stateByte = Ref.getStateByte(ref);
        if (!hasList) {
            return stateByte;
        }
        long nextTailOffset = this.writeBuffers.readFiveByteULong(lrPtrOffset);
        while (nextTailOffset > 0L) {
            this.writeBuffers.setReadPoint(nextTailOffset);
            valueLength = (int)this.writeBuffers.readVLong();
            result.add(new WriteBuffers.ByteSegmentRef(nextTailOffset - (long)valueLength, valueLength));
            long delta = this.writeBuffers.readVLong();
            nextTailOffset = delta == 0L ? 0L : nextTailOffset - delta;
        }
        return stateByte;
    }

    public void populateValue(WriteBuffers.ByteSegmentRef valueRef) {
        this.writeBuffers.populateValue(valueRef);
    }

    public int size() {
        return this.keysAssigned;
    }

    public void seal() {
        this.writeBuffers.seal();
    }

    public void clear() {
        this.writeBuffers.clear();
        this.refs = new long[1];
        this.keysAssigned = 0;
    }

    private static void validateCapacity(long capacity) {
        if (Long.bitCount(capacity) != 1) {
            throw new AssertionError((Object)"Capacity must be a power of two");
        }
        if (capacity <= 0L) {
            throw new AssertionError((Object)("Invalid capacity " + capacity));
        }
    }

    private int findKeySlotToWrite(long keyOffset, int keyLength, int hashCode) {
        long ref;
        int bucketMask = this.refs.length - 1;
        int slot = hashCode & bucketMask;
        long probeSlot = slot;
        int i = 0;
        while ((ref = this.refs[slot]) != 0L && !this.isSameKey(keyOffset, keyLength, ref, hashCode)) {
            ++this.metricPutConflict;
            slot = (int)((probeSlot += (long)(++i)) & (long)bucketMask);
        }
        if (this.largestNumberOfSteps < i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Probed " + i + " slots (the longest so far) to find space"));
            }
            this.largestNumberOfSteps = i;
        }
        return slot;
    }

    private long findKeyRefToRead(byte[] key, int length) {
        int bucketMask = this.refs.length - 1;
        int hashCode = this.writeBuffers.hashCode(key, 0, length);
        int slot = hashCode & bucketMask;
        long probeSlot = slot;
        int i = 0;
        long ref;
        while ((ref = this.refs[slot]) != 0L) {
            if (this.isSameKey(key, length, ref, hashCode)) {
                return ref;
            }
            probeSlot += (long)(++i);
            if (i > this.largestNumberOfSteps) {
                return 0L;
            }
            slot = (int)(probeSlot & (long)bucketMask);
        }
        return 0L;
    }

    private int relocateKeyRef(long[] newRefs, long newRef, int hashCode) {
        int bucketMask = newRefs.length - 1;
        int newSlot = hashCode & bucketMask;
        long probeSlot = newSlot;
        int i = 0;
        while (true) {
            long current;
            if ((current = newRefs[newSlot]) == 0L) break;
            newSlot = (int)((probeSlot += (long)(++i)) & (long)bucketMask);
        }
        newRefs[newSlot] = newRef;
        return i;
    }

    private boolean isSameKey(long cmpOffset, int cmpLength, long ref, int hashCode) {
        if (!this.compareHashBits(ref, hashCode)) {
            return false;
        }
        this.writeBuffers.setReadPoint(this.getFirstRecordLengthsOffset(ref));
        int valueLength = (int)this.writeBuffers.readVLong();
        int keyLength = (int)this.writeBuffers.readVLong();
        if (keyLength != cmpLength) {
            return false;
        }
        long keyOffset = Ref.getOffset(ref) - (long)(valueLength + keyLength);
        return this.writeBuffers.isEqual(cmpOffset, cmpLength, keyOffset, keyLength);
    }

    private boolean isSameKey(byte[] key, int length, long ref, int hashCode) {
        if (!this.compareHashBits(ref, hashCode)) {
            return false;
        }
        this.writeBuffers.setReadPoint(this.getFirstRecordLengthsOffset(ref));
        int valueLength = (int)this.writeBuffers.readVLong();
        int keyLength = (int)this.writeBuffers.readVLong();
        long keyOffset = Ref.getOffset(ref) - (long)(valueLength + keyLength);
        return this.writeBuffers.isEqual(key, length, keyOffset, keyLength);
    }

    private boolean compareHashBits(long ref, int hashCode) {
        long fakeRef = Ref.makeFirstRef(0L, (byte)0, hashCode, this.startingHashBitCount);
        return Ref.getHashBits(fakeRef) == Ref.getHashBits(ref);
    }

    private long getFirstRecordLengthsOffset(long ref) {
        long tailOffset = Ref.getOffset(ref);
        if (Ref.hasList(ref)) {
            long relativeOffset = this.writeBuffers.readFiveByteULong(tailOffset);
            tailOffset += relativeOffset;
        }
        return tailOffset;
    }

    private void expandAndRehash() {
        long expandTime = System.nanoTime();
        long[] oldRefs = this.refs;
        long capacity = this.refs.length << 1;
        BytesBytesMultiHashMap.validateCapacity(capacity);
        long[] newRefs = new long[(int)capacity];
        int newHashBitCount = this.hashBitCount + 1;
        int maxSteps = 0;
        for (int oldSlot = 0; oldSlot < oldRefs.length; ++oldSlot) {
            long oldRef = oldRefs[oldSlot];
            if (oldRef == 0L) continue;
            this.writeBuffers.setReadPoint(this.getFirstRecordLengthsOffset(oldRef));
            int hashCode = this.writeBuffers.readInt(Ref.getOffset(oldRef) - this.writeBuffers.readVLong() - this.writeBuffers.readVLong() - 4L);
            int probeSteps = this.relocateKeyRef(newRefs, oldRef, hashCode);
            maxSteps = Math.max(probeSteps, maxSteps);
        }
        this.refs = newRefs;
        this.largestNumberOfSteps = maxSteps;
        this.hashBitCount = newHashBitCount;
        this.resizeThreshold = (int)((float)capacity * this.loadFactor);
        this.metricExpandsUs = (int)((long)this.metricExpandsUs + (System.nanoTime() - expandTime));
        ++this.metricExpands;
    }

    private long createOrGetListRecord(long ref) {
        if (Ref.hasList(ref)) {
            return this.writeBuffers.getReadPoint();
        }
        long firstTailOffset = Ref.getOffset(ref);
        this.writeBuffers.setReadPoint(firstTailOffset);
        this.writeBuffers.skipVLong();
        this.writeBuffers.skipVLong();
        int lengthsLength = (int)(this.writeBuffers.getReadPoint() - firstTailOffset);
        this.writeBuffers.writeBytes(firstTailOffset, lengthsLength);
        long lrPtrOffset = this.writeBuffers.getWritePoint();
        this.writeBuffers.write(FIVE_ZEROES);
        this.writeBuffers.writeFiveByteULong(firstTailOffset, lrPtrOffset - (long)lengthsLength - firstTailOffset);
        return lrPtrOffset;
    }

    private void addRecordToList(long lrPtrOffset, long tailOffset) {
        long prevHeadOffset = this.writeBuffers.readFiveByteULong(lrPtrOffset);
        assert (prevHeadOffset < tailOffset);
        this.writeBuffers.writeFiveByteULong(lrPtrOffset, tailOffset);
        this.writeBuffers.writeVLong(prevHeadOffset == 0L ? 0L : tailOffset - prevHeadOffset);
    }

    private long writeFirstValueRecord(KvSource kv, long keyOffset, int keyLength, int hashCode) throws SerDeException {
        long valueOffset = this.writeBuffers.getWritePoint();
        kv.writeValue(this.writeBuffers);
        long tailOffset = this.writeBuffers.getWritePoint();
        int valueLength = (int)(tailOffset - valueOffset);
        if (tailOffset == 0L) {
            this.writeBuffers.reserve(1);
            ++tailOffset;
        }
        this.writeBuffers.writeVLong(valueLength);
        this.writeBuffers.writeVLong(keyLength);
        long lengthsLength = this.writeBuffers.getWritePoint() - tailOffset;
        if (lengthsLength < 5L) {
            this.writeBuffers.reserve(5 - (int)lengthsLength);
        }
        this.writeBuffers.writeInt(keyOffset - 4L, hashCode);
        return tailOffset;
    }

    private long writeValueAndLength(KvSource kv) throws SerDeException {
        long valueOffset = this.writeBuffers.getWritePoint();
        kv.writeValue(this.writeBuffers);
        long tailOffset = this.writeBuffers.getWritePoint();
        this.writeBuffers.writeVLong(tailOffset - valueOffset);
        return tailOffset;
    }

    public void debugDumpTable() {
        StringBuilder dump = new StringBuilder(this.keysAssigned + " keys\n");
        TreeMap<Long, Integer> byteIntervals = new TreeMap<Long, Integer>();
        ArrayList<WriteBuffers.ByteSegmentRef> results = new ArrayList<WriteBuffers.ByteSegmentRef>();
        int examined = 0;
        for (int slot = 0; slot < this.refs.length; ++slot) {
            long ref = this.refs[slot];
            if (ref == 0L) continue;
            ++examined;
            long recOffset = this.getFirstRecordLengthsOffset(ref);
            long tailOffset = Ref.getOffset(ref);
            this.writeBuffers.setReadPoint(recOffset);
            int valueLength = (int)this.writeBuffers.readVLong();
            int keyLength = (int)this.writeBuffers.readVLong();
            long ptrOffset = this.writeBuffers.getReadPoint();
            if (Ref.hasList(ref)) {
                byteIntervals.put(recOffset, (int)(ptrOffset + 5L - recOffset));
            }
            long keyOffset = tailOffset - (long)valueLength - (long)keyLength;
            byte[] key = new byte[keyLength];
            WriteBuffers.ByteSegmentRef fakeRef = new WriteBuffers.ByteSegmentRef(keyOffset, keyLength);
            byteIntervals.put(keyOffset - 4L, keyLength + 4);
            this.writeBuffers.populateValue(fakeRef);
            System.arraycopy(fakeRef.getBytes(), (int)fakeRef.getOffset(), key, 0, keyLength);
            this.getValueRefs(key, key.length, results);
            dump.append(Utils.toStringBinary(key, 0, key.length)).append(" ref [").append(BytesBytesMultiHashMap.dumpRef(ref)).append("]: ").append(results.size()).append(" rows\n");
            for (int i = 0; i < results.size(); ++i) {
                WriteBuffers.ByteSegmentRef segment = (WriteBuffers.ByteSegmentRef)results.get(i);
                byteIntervals.put(segment.getOffset(), segment.getLength() + (i == 0 ? 1 : 0));
            }
        }
        if (examined != this.keysAssigned) {
            dump.append("Found " + examined + " keys!\n");
        }
        long currentOffset = 0L;
        for (Map.Entry e : byteIntervals.entrySet()) {
            long start = (Long)e.getKey();
            long len = ((Integer)e.getValue()).intValue();
            if (start - currentOffset > 4L) {
                dump.append("Gap! [" + currentOffset + ", " + start + ")\n");
            }
            currentOffset = start + len;
        }
        LOG.info((Object)("Hashtable dump:\n " + dump.toString()));
    }

    private static int nextHighestPowerOfTwo(int v) {
        return Integer.highestOneBit(v) << 1;
    }

    private static int nextLowestPowerOfTwo(int v) {
        return Integer.highestOneBit(v);
    }

    @VisibleForTesting
    int getCapacity() {
        return this.refs.length;
    }

    private static String dumpRef(long ref) {
        return StringUtils.leftPad(Long.toBinaryString(ref), 64, "0") + " o=" + Ref.getOffset(ref) + " s=" + Ref.getStateByte(ref) + " l=" + Ref.hasList(ref) + " h=" + Long.toBinaryString(Ref.getHashBits(ref));
    }

    public void debugDumpMetrics() {
        LOG.info((Object)("Map metrics: keys allocated " + this.refs.length + ", keys assigned " + this.keysAssigned + ", write conflict " + this.metricPutConflict + ", write max dist " + this.largestNumberOfSteps + ", expanded " + this.metricExpands + " times in " + this.metricExpandsUs + "us"));
    }

    private void debugDumpKeyProbe(long keyOffset, int keyLength, int hashCode, int finalSlot) {
        int bucketMask = this.refs.length - 1;
        WriteBuffers.ByteSegmentRef fakeRef = new WriteBuffers.ByteSegmentRef(keyOffset, keyLength);
        this.writeBuffers.populateValue(fakeRef);
        int slot = hashCode & bucketMask;
        long probeSlot = slot;
        StringBuilder sb = new StringBuilder("Probe path debug for [");
        sb.append(Utils.toStringBinary(fakeRef.getBytes(), (int)fakeRef.getOffset(), fakeRef.getLength()));
        sb.append("] hashCode ").append(Integer.toBinaryString(hashCode)).append(" is: ");
        int i = 0;
        while (slot != finalSlot) {
            slot = (int)((probeSlot += (long)(++i)) & (long)bucketMask);
            sb.append(slot).append(" - ").append(probeSlot).append(" - ").append(Long.toBinaryString(this.refs[slot])).append("\n");
        }
        LOG.info((Object)sb.toString());
    }

    private static final class Ref {
        private static final int OFFSET_SHIFT = 24;
        private static final int STATE_BYTE_SHIFT = 16;
        private static final long STATE_BYTE_MASK = 255L;
        public static final long HASH_BITS_COUNT = 15L;
        private static final long HAS_LIST_MASK = 32768L;
        private static final long HASH_BITS_MASK = 32767L;
        private static final long REMOVE_STATE_BYTE = -16711681L;

        private Ref() {
        }

        public static long getOffset(long ref) {
            return ref >>> 24;
        }

        public static byte getStateByte(long ref) {
            return (byte)(ref >>> 16 & 0xFFL);
        }

        public static boolean hasList(long ref) {
            return (ref & 0x8000L) == 32768L;
        }

        public static long getHashBits(long ref) {
            return ref & 0x7FFFL;
        }

        public static long makeFirstRef(long offset, byte stateByte, int hashCode, int skipHashBits) {
            long hashPart = (long)(hashCode >>> skipHashBits) & 0x7FFFL;
            return offset << 24 | hashPart | ((long)stateByte & 0xFFL) << 16;
        }

        public static int getNthHashBit(long ref, int skippedBits, int position) {
            long hashPart = Ref.getHashBits(ref) << skippedBits;
            return (int)(hashPart & (long)(1 << position - 1));
        }

        public static long setStateByte(long ref, byte stateByte) {
            return ref & 0xFFFFFFFFFF00FFFFL | ((long)stateByte & 0xFFL) << 16;
        }

        public static long setListFlag(long ref) {
            return ref | 0x8000L;
        }
    }

    public static interface KvSource {
        public void writeKey(ByteStream.RandomAccessOutput var1) throws SerDeException;

        public void writeValue(ByteStream.RandomAccessOutput var1) throws SerDeException;

        public byte updateStateByte(Byte var1);
    }
}

