/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.DummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.MapOperator;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.exec.ObjectCacheFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.tez.MapRecordSource;
import org.apache.hadoop.hive.ql.exec.tez.RecordProcessor;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.exec.tez.TezProcessor;
import org.apache.hadoop.hive.ql.exec.tez.tools.KeyValueInputMerger;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapOperator;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.tez.mapreduce.input.MRInputLegacy;
import org.apache.tez.mapreduce.input.MultiMRInput;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class MapRecordProcessor
extends RecordProcessor {
    private MapOperator mapOp;
    private final List<MapOperator> mergeMapOpList = new ArrayList<MapOperator>();
    public static final Log l4j = LogFactory.getLog(MapRecordProcessor.class);
    private MapRecordSource[] sources;
    private final Map<String, MultiMRInput> multiMRInputMap = new HashMap<String, MultiMRInput>();
    private int position = 0;
    private boolean foundCachedMergeWork = false;
    MRInputLegacy legacyMRInput = null;
    MultiMRInput mainWorkMultiMRInput = null;
    private ExecMapperContext execContext = null;
    private boolean abort = false;
    protected static final String MAP_PLAN_KEY = "__MAP_PLAN__";
    private MapWork mapWork;
    List<MapWork> mergeWorkList = null;
    private static Map<Integer, DummyStoreOperator> connectOps = new TreeMap<Integer, DummyStoreOperator>();

    public MapRecordProcessor(JobConf jconf) throws Exception {
        ObjectCache cache = ObjectCacheFactory.getCache((Configuration)jconf);
        this.execContext = new ExecMapperContext(jconf);
        this.execContext.setJc(jconf);
        this.mapWork = (MapWork)cache.retrieve(MAP_PLAN_KEY);
        if (this.mapWork == null) {
            this.mapWork = Utilities.getMapWork((Configuration)jconf);
            cache.cache(MAP_PLAN_KEY, this.mapWork);
            l4j.debug((Object)("Plan: " + this.mapWork));
            for (String s : this.mapWork.getAliases()) {
                l4j.debug((Object)("Alias: " + s));
            }
        } else {
            Utilities.setMapWork((Configuration)jconf, this.mapWork);
        }
        String prefixes = jconf.get("hive.tez.merge.file.prefixes");
        if (prefixes != null) {
            this.mergeWorkList = new ArrayList<MapWork>();
            for (String prefix : prefixes.split(",")) {
                MapWork mergeMapWork = (MapWork)cache.retrieve(prefix);
                if (mergeMapWork != null) {
                    l4j.info((Object)"Found merge work in cache");
                    this.foundCachedMergeWork = true;
                    this.mergeWorkList.add(mergeMapWork);
                    continue;
                }
                if (this.foundCachedMergeWork) {
                    throw new Exception("Should find all work in cache else operator pipeline will be in non-deterministic state");
                }
                if (prefix == null || prefix.isEmpty()) continue;
                mergeMapWork = (MapWork)Utilities.getMergeWork(jconf, prefix);
                this.mergeWorkList.add(mergeMapWork);
                cache.cache(prefix, mergeMapWork);
            }
        }
    }

    @Override
    void init(JobConf jconf, ProcessorContext processorContext, MRTaskReporter mrReporter, Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        Configuration updatedConf;
        this.perfLogger.PerfLogBegin(this.CLASS_NAME, "TezInitializeOperators");
        super.init(jconf, processorContext, mrReporter, inputs, outputs);
        this.legacyMRInput = this.getMRInput(inputs);
        if (this.legacyMRInput != null && (updatedConf = this.legacyMRInput.getConfigUpdates()) != null) {
            for (Map.Entry entry : updatedConf) {
                jconf.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.createOutputMap();
        for (Map.Entry<String, LogicalOutput> outputEntry : outputs.entrySet()) {
            l4j.debug((Object)("Starting Output: " + outputEntry.getKey()));
            outputEntry.getValue().start();
            ((TezProcessor.TezKVOutputCollector)this.outMap.get(outputEntry.getKey())).initialize();
        }
        try {
            this.mapOp = this.mapWork.getVectorMode() ? new VectorMapOperator() : new MapOperator();
            connectOps.clear();
            if (this.mergeWorkList != null) {
                MapOperator mergeMapOp = null;
                for (MapWork mapWork : this.mergeWorkList) {
                    mergeMapOp = mapWork.getVectorMode() ? new VectorMapOperator() : new MapOperator();
                    this.mergeMapOpList.add(mergeMapOp);
                    if (mergeMapOp == null) continue;
                    mergeMapOp.setConf(mapWork);
                    l4j.info((Object)("Input name is " + mapWork.getName()));
                    jconf.set("iocontext.input.name", mapWork.getName());
                    mergeMapOp.setChildren((Configuration)jconf);
                    if (!this.foundCachedMergeWork) {
                        DummyStoreOperator dummyOp = this.getJoinParentOp(mergeMapOp);
                        connectOps.put(mapWork.getTag(), dummyOp);
                    }
                    mergeMapOp.setExecContext(new ExecMapperContext(jconf));
                    mergeMapOp.initializeLocalWork((Configuration)jconf);
                }
            }
            this.mapOp.setConf(this.mapWork);
            l4j.info((Object)("Main input name is " + this.mapWork.getName()));
            jconf.set("iocontext.input.name", this.mapWork.getName());
            this.mapOp.setChildren((Configuration)jconf);
            l4j.info((Object)this.mapOp.dump(0));
            MapredContext.init(true, new JobConf((Configuration)jconf));
            ((TezContext)MapredContext.get()).setInputs(inputs);
            ((TezContext)MapredContext.get()).setTezProcessorContext(processorContext);
            this.mapOp.setExecContext(this.execContext);
            this.mapOp.initializeLocalWork((Configuration)jconf);
            this.initializeMapRecordSources();
            this.mapOp.initialize((Configuration)jconf, null);
            if (this.mergeMapOpList != null && !this.mergeMapOpList.isEmpty()) {
                for (MapOperator mergeMapOp : this.mergeMapOpList) {
                    jconf.set("iocontext.input.name", ((MapWork)mergeMapOp.getConf()).getName());
                    mergeMapOp.initialize((Configuration)jconf, null);
                }
            }
            List<HashTableDummyOperator> dummyOps = this.mapWork.getDummyOps();
            jconf.set("iocontext.input.name", this.mapWork.getName());
            if (dummyOps != null) {
                for (Operator operator : dummyOps) {
                    operator.setExecContext(this.execContext);
                    operator.initialize((Configuration)jconf, null);
                }
            }
            OperatorUtils.setChildrenCollector(this.mapOp.getChildOperators(), this.outMap);
            this.mapOp.setReporter((Reporter)this.reporter);
            MapredContext.get().setReporter((Reporter)this.reporter);
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            throw new RuntimeException("Map operator initialization failed", e);
        }
        this.perfLogger.PerfLogEnd(this.CLASS_NAME, "TezInitializeOperators");
    }

    private void initializeMapRecordSources() throws Exception {
        int size = this.mergeMapOpList.size() + 1;
        this.sources = new MapRecordSource[size];
        this.position = ((MapWork)this.mapOp.getConf()).getTag();
        this.sources[this.position] = new MapRecordSource();
        KeyValueReader reader = null;
        reader = this.mainWorkMultiMRInput != null ? this.getKeyValueReader(this.mainWorkMultiMRInput.getKeyValueReaders(), this.mapOp) : this.legacyMRInput.getReader();
        this.sources[this.position].init(this.jconf, this.mapOp, reader);
        for (MapOperator mapOp : this.mergeMapOpList) {
            int tag = ((MapWork)mapOp.getConf()).getTag();
            this.sources[tag] = new MapRecordSource();
            String inputName = ((MapWork)mapOp.getConf()).getName();
            MultiMRInput multiMRInput = this.multiMRInputMap.get(inputName);
            Collection kvReaders = multiMRInput.getKeyValueReaders();
            l4j.debug((Object)("There are " + kvReaders.size() + " key-value readers for input " + inputName));
            reader = this.getKeyValueReader(kvReaders, mapOp);
            this.sources[tag].init(this.jconf, mapOp, reader);
        }
        ((TezContext)MapredContext.get()).setRecordSources(this.sources);
    }

    private KeyValueReader getKeyValueReader(Collection<KeyValueReader> keyValueReaders, MapOperator mapOp) throws Exception {
        ArrayList<KeyValueReader> kvReaderList = new ArrayList<KeyValueReader>(keyValueReaders);
        mapOp.initializeContexts();
        Deserializer deserializer = mapOp.getCurrentDeserializer();
        KeyValueInputMerger reader = new KeyValueInputMerger(kvReaderList, deserializer, new ObjectInspector[]{deserializer.getObjectInspector()}, ((MapWork)mapOp.getConf()).getSortCols());
        return reader;
    }

    private DummyStoreOperator getJoinParentOp(Operator<? extends OperatorDesc> mergeMapOp) {
        Iterator<Operator<OperatorDesc>> i$ = mergeMapOp.getChildOperators().iterator();
        if (i$.hasNext()) {
            Operator<OperatorDesc> childOp = i$.next();
            if (childOp.getChildOperators() == null || childOp.getChildOperators().isEmpty()) {
                return (DummyStoreOperator)childOp;
            }
            return this.getJoinParentOp(childOp);
        }
        return null;
    }

    @Override
    void run() throws Exception {
        while (this.sources[this.position].pushRecord()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() {
        if (!this.abort) {
            this.abort = this.execContext.getIoCxt().getIOExceptions();
        }
        try {
            List<HashTableDummyOperator> dummyOps;
            if (this.mapOp == null || this.mapWork == null) {
                return;
            }
            this.mapOp.close(this.abort);
            if (!this.mergeMapOpList.isEmpty()) {
                for (MapOperator mergeMapOp : this.mergeMapOpList) {
                    mergeMapOp.close(this.abort);
                }
            }
            if ((dummyOps = this.mapWork.getDummyOps()) != null) {
                for (Operator operator : dummyOps) {
                    operator.close(this.abort);
                }
            }
            ExecMapper.ReportStats rps = new ExecMapper.ReportStats((Reporter)this.reporter, (Configuration)this.jconf);
            this.mapOp.preorderMap(rps);
            return;
        }
        catch (Exception e) {
            if (!this.abort) {
                l4j.error((Object)"Hit error while closing operators - failing tree");
                throw new RuntimeException("Hive Runtime Error while closing operators", e);
            }
        }
        finally {
            Utilities.clearWorkMap();
            MapredContext.close();
        }
    }

    public static Map<Integer, DummyStoreOperator> getConnectOps() {
        return connectOps;
    }

    private MRInputLegacy getMRInput(Map<String, LogicalInput> inputs) throws Exception {
        MRInputLegacy theMRInput = null;
        l4j.info((Object)("The input names are: " + Arrays.toString(inputs.keySet().toArray())));
        for (Map.Entry<String, LogicalInput> inp : inputs.entrySet()) {
            if (inp.getValue() instanceof MRInputLegacy) {
                if (theMRInput != null) {
                    throw new IllegalArgumentException("Only one MRInput is expected");
                }
                theMRInput = (MRInputLegacy)inp.getValue();
                continue;
            }
            if (!(inp.getValue() instanceof MultiMRInput)) continue;
            this.multiMRInputMap.put(inp.getKey(), (MultiMRInput)inp.getValue());
        }
        if (theMRInput != null) {
            theMRInput.init();
        } else {
            String alias = this.mapWork.getAliasToWork().keySet().iterator().next();
            if (inputs.get(alias) instanceof MultiMRInput) {
                this.mainWorkMultiMRInput = (MultiMRInput)inputs.get(alias);
            } else {
                throw new IOException("Unexpected input type found: " + inputs.get(alias).getClass().getCanonicalName());
            }
        }
        return theMRInput;
    }
}

