/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.lineage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.lineage.ExprProcCtx;
import org.apache.hadoop.hive.ql.optimizer.lineage.LineageCtx;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeNullDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class ExprProcFactory {
    public static NodeProcessor getDefaultExprProcessor() {
        return new DefaultExprProcessor();
    }

    public static NodeProcessor getGenericFuncProcessor() {
        return new GenericExprProcessor();
    }

    public static NodeProcessor getFieldProcessor() {
        return new GenericExprProcessor();
    }

    public static NodeProcessor getColumnProcessor() {
        return new ColumnExprProcessor();
    }

    public static LineageInfo.Dependency getExprDependency(LineageCtx lctx, Operator<? extends OperatorDesc> inpOp, ExprNodeDesc expr) throws SemanticException {
        ExprProcCtx exprCtx = new ExprProcCtx(lctx, inpOp);
        LinkedHashMap<Rule, NodeProcessor> exprRules = new LinkedHashMap<Rule, NodeProcessor>();
        exprRules.put(new RuleRegExp("R1", ExprNodeColumnDesc.class.getName() + "%"), ExprProcFactory.getColumnProcessor());
        exprRules.put(new RuleRegExp("R2", ExprNodeFieldDesc.class.getName() + "%"), ExprProcFactory.getFieldProcessor());
        exprRules.put(new RuleRegExp("R3", ExprNodeGenericFuncDesc.class.getName() + "%"), ExprProcFactory.getGenericFuncProcessor());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(ExprProcFactory.getDefaultExprProcessor(), exprRules, exprCtx);
        DefaultGraphWalker egw = new DefaultGraphWalker(disp);
        ArrayList<Node> startNodes = new ArrayList<Node>();
        startNodes.add(expr);
        HashMap<Node, Object> outputMap = new HashMap<Node, Object>();
        egw.startWalking(startNodes, outputMap);
        return (LineageInfo.Dependency)outputMap.get(expr);
    }

    public static class DefaultExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (nd instanceof ExprNodeConstantDesc || nd instanceof ExprNodeNullDesc);
            LineageInfo.Dependency dep = new LineageInfo.Dependency();
            dep.setType(LineageInfo.DependencyType.SIMPLE);
            dep.setBaseCols(new ArrayList<LineageInfo.BaseColumnInfo>());
            return dep;
        }
    }

    public static class GenericExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (nd instanceof ExprNodeGenericFuncDesc || nd instanceof ExprNodeFieldDesc);
            LineageInfo.Dependency dep = new LineageInfo.Dependency();
            LinkedHashSet<LineageInfo.BaseColumnInfo> bci_set = new LinkedHashSet<LineageInfo.BaseColumnInfo>();
            LineageInfo.DependencyType new_type = LineageInfo.DependencyType.EXPRESSION;
            for (Object child : nodeOutputs) {
                if (child == null) continue;
                LineageInfo.Dependency child_dep = (LineageInfo.Dependency)child;
                new_type = LineageCtx.getNewDependencyType(child_dep.getType(), new_type);
                bci_set.addAll(child_dep.getBaseCols());
            }
            dep.setBaseCols(new ArrayList<LineageInfo.BaseColumnInfo>(bci_set));
            dep.setType(new_type);
            return dep;
        }
    }

    public static class ColumnExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprNodeColumnDesc cd = (ExprNodeColumnDesc)nd;
            ExprProcCtx epc = (ExprProcCtx)procCtx;
            Operator<? extends OperatorDesc> operator = epc.getInputOperator();
            assert (operator != null);
            RowResolver resolver = epc.getResolver();
            String[] nm = resolver.reverseLookup(cd.getColumn());
            if (nm == null && operator instanceof ReduceSinkOperator) {
                nm = resolver.reverseLookup(Utilities.removeValueTag(cd.getColumn()));
            }
            ColumnInfo ci = nm != null ? resolver.get(nm[0], nm[1]) : null;
            LineageCtx lc = epc.getLineageCtx();
            LineageInfo.Dependency dep = lc.getIndex().getDependency(operator, ci);
            return dep;
        }
    }
}

