/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.List;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

@Explain(displayName="Filter Operator")
public class FilterDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private ExprNodeDesc predicate;
    private boolean isSamplingPred;
    private transient sampleDesc sampleDescr;
    private boolean isSortedFilter;

    public FilterDesc() {
    }

    public FilterDesc(ExprNodeDesc predicate, boolean isSamplingPred) {
        this.predicate = predicate;
        this.isSamplingPred = isSamplingPred;
        this.sampleDescr = null;
    }

    public FilterDesc(ExprNodeDesc predicate, boolean isSamplingPred, sampleDesc sampleDescr) {
        this.predicate = predicate;
        this.isSamplingPred = isSamplingPred;
        this.sampleDescr = sampleDescr;
    }

    @Explain(displayName="predicate")
    public String getPredicateString() {
        StringBuffer sb = new StringBuffer();
        PlanUtils.addExprToStringBuffer(this.predicate, sb);
        return sb.toString();
    }

    public ExprNodeDesc getPredicate() {
        return this.predicate;
    }

    public void setPredicate(ExprNodeDesc predicate) {
        this.predicate = predicate;
    }

    @Explain(displayName="isSamplingPred", normalExplain=false)
    public boolean getIsSamplingPred() {
        return this.isSamplingPred;
    }

    public void setIsSamplingPred(boolean isSamplingPred) {
        this.isSamplingPred = isSamplingPred;
    }

    @Explain(displayName="sampleDesc", normalExplain=false)
    public sampleDesc getSampleDescr() {
        return this.sampleDescr;
    }

    public void setSampleDescr(sampleDesc sampleDescr) {
        this.sampleDescr = sampleDescr;
    }

    public boolean isSortedFilter() {
        return this.isSortedFilter;
    }

    public void setSortedFilter(boolean isSortedFilter) {
        this.isSortedFilter = isSortedFilter;
    }

    @Override
    public Object clone() {
        FilterDesc filterDesc = new FilterDesc(this.getPredicate().clone(), this.getIsSamplingPred());
        if (this.getIsSamplingPred()) {
            filterDesc.setSampleDescr(this.getSampleDescr());
        }
        filterDesc.setSortedFilter(this.isSortedFilter());
        return filterDesc;
    }

    public static class sampleDesc
    implements Cloneable {
        private int numerator;
        private int denominator;
        private boolean inputPruning;

        public sampleDesc() {
        }

        public sampleDesc(int numerator, int denominator, List<String> tabBucketCols, boolean inputPruning) {
            this.numerator = numerator;
            this.denominator = denominator;
            this.inputPruning = inputPruning;
        }

        public int getNumerator() {
            return this.numerator;
        }

        public int getDenominator() {
            return this.denominator;
        }

        public boolean getInputPruning() {
            return this.inputPruning;
        }

        public Object clone() {
            sampleDesc desc = new sampleDesc(this.numerator, this.denominator, null, this.inputPruning);
            return desc;
        }
    }
}

