/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalColSubtractDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalColSubtractDecimalScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalScalarSubtractDecimalColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColSubtractDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColSubtractDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColSubtractLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColSubtractLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleScalarSubtractDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleScalarSubtractLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColSubtractDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColSubtractDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColSubtractLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColSubtractLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongScalarSubtractDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongScalarSubtractLongColumn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseNumeric;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="-", value="a _FUNC_ b - Returns the difference a-b")
@VectorizedExpressions(value={LongColSubtractLongColumn.class, LongColSubtractDoubleColumn.class, DoubleColSubtractLongColumn.class, DoubleColSubtractDoubleColumn.class, LongColSubtractLongScalar.class, LongColSubtractDoubleScalar.class, DoubleColSubtractLongScalar.class, DoubleColSubtractDoubleScalar.class, LongScalarSubtractLongColumn.class, LongScalarSubtractDoubleColumn.class, DoubleScalarSubtractLongColumn.class, DoubleScalarSubtractDoubleColumn.class, DecimalColSubtractDecimalColumn.class, DecimalColSubtractDecimalScalar.class, DecimalScalarSubtractDecimalColumn.class})
public class GenericUDFOPMinus
extends GenericUDFBaseNumeric {
    public GenericUDFOPMinus() {
        this.opDisplayName = "-";
    }

    @Override
    protected ByteWritable evaluate(ByteWritable left, ByteWritable right) {
        this.byteWritable.set((byte)(left.get() - right.get()));
        return this.byteWritable;
    }

    @Override
    protected ShortWritable evaluate(ShortWritable left, ShortWritable right) {
        this.shortWritable.set((short)(left.get() - right.get()));
        return this.shortWritable;
    }

    @Override
    protected IntWritable evaluate(IntWritable left, IntWritable right) {
        this.intWritable.set(left.get() - right.get());
        return this.intWritable;
    }

    @Override
    protected LongWritable evaluate(LongWritable left, LongWritable right) {
        this.longWritable.set(left.get() - right.get());
        return this.longWritable;
    }

    @Override
    protected FloatWritable evaluate(FloatWritable left, FloatWritable right) {
        this.floatWritable.set(left.get() - right.get());
        return this.floatWritable;
    }

    @Override
    protected DoubleWritable evaluate(DoubleWritable left, DoubleWritable right) {
        this.doubleWritable.set(left.get() - right.get());
        return this.doubleWritable;
    }

    @Override
    protected HiveDecimalWritable evaluate(HiveDecimal left, HiveDecimal right) {
        HiveDecimal dec = left.subtract(right);
        if (dec == null) {
            return null;
        }
        this.decimalWritable.set(dec);
        return this.decimalWritable;
    }

    @Override
    protected DecimalTypeInfo deriveResultDecimalTypeInfo(int prec1, int scale1, int prec2, int scale2) {
        int intPart = Math.max(prec1 - scale1, prec2 - scale2);
        int scale = Math.max(scale1, scale2);
        int prec = Math.min(intPart + scale + 1, 38);
        return TypeInfoFactory.getDecimalTypeInfo(prec, scale);
    }
}

