/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.Random;
import javolution.util.FastBitSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.io.Text;

public class NumDistinctValueEstimator {
    static final Log LOG = LogFactory.getLog((String)NumDistinctValueEstimator.class.getName());
    private static final int bitVectorSize = 31;
    private int numBitVectors;
    private final double phi = 0.77351;
    private int[] a;
    private int[] b;
    private FastBitSet[] bitVector = new FastBitSet[this.numBitVectors];
    private Random aValue;
    private Random bValue;

    public NumDistinctValueEstimator(int numBitVectors) {
        int i;
        this.numBitVectors = numBitVectors;
        this.bitVector = new FastBitSet[numBitVectors];
        for (i = 0; i < numBitVectors; ++i) {
            this.bitVector[i] = new FastBitSet(31);
        }
        this.a = new int[numBitVectors];
        this.b = new int[numBitVectors];
        this.aValue = new Random(99397L);
        this.bValue = new Random(9876413L);
        for (i = 0; i < numBitVectors; ++i) {
            int randVal;
            while ((randVal = this.aValue.nextInt()) % 2 == 0) {
            }
            this.a[i] = randVal;
            while ((randVal = this.bValue.nextInt()) % 2 == 0) {
            }
            this.b[i] = randVal;
            if (this.a[i] < 0) {
                this.a[i] = this.a[i] + 0x40000000;
            }
            if (this.b[i] >= 0) continue;
            this.b[i] = this.b[i] + 0x40000000;
        }
    }

    public NumDistinctValueEstimator(String s, int numBitVectors) {
        FastBitSet[] b = this.deserialize(s, numBitVectors);
        this.bitVector = new FastBitSet[numBitVectors];
        for (int i = 0; i < numBitVectors; ++i) {
            this.bitVector[i] = new FastBitSet(31);
            this.bitVector[i].clear();
            this.bitVector[i].or(b[i]);
        }
    }

    public void reset() {
        for (int i = 0; i < this.numBitVectors; ++i) {
            this.bitVector[i].clear();
        }
    }

    public FastBitSet getBitVector(int index) {
        return this.bitVector[index];
    }

    public int getnumBitVectors() {
        return this.numBitVectors;
    }

    public int getBitVectorSize() {
        return 31;
    }

    public void printNumDistinctValueEstimator() {
        String t = new String();
        LOG.debug((Object)"NumDistinctValueEstimator");
        LOG.debug((Object)"Number of Vectors:");
        LOG.debug((Object)this.numBitVectors);
        LOG.debug((Object)"Vector Size: ");
        LOG.debug((Object)31);
        for (int i = 0; i < this.numBitVectors; ++i) {
            t = t + this.bitVector[i].toString();
        }
        LOG.debug((Object)"Serialized Vectors: ");
        LOG.debug((Object)t);
    }

    public Text serialize() {
        String s = new String();
        for (int i = 0; i < this.numBitVectors; ++i) {
            s = s + this.bitVector[i].toString();
        }
        return new Text(s);
    }

    private FastBitSet[] deserialize(String s, int numBitVectors) {
        FastBitSet[] b = new FastBitSet[numBitVectors];
        for (int j = 0; j < numBitVectors; ++j) {
            b[j] = new FastBitSet(31);
            b[j].clear();
        }
        int vectorIndex = 0;
        int i = 1;
        while (i < s.length() - 1) {
            char c = s.charAt(i);
            ++i;
            if (c == '}') {
                ++vectorIndex;
            }
            if (c < '0' || c > '9') continue;
            String t = new String();
            t = t + c;
            c = s.charAt(i);
            ++i;
            while (c != ',' && c != '}') {
                t = t + c;
                c = s.charAt(i);
                ++i;
            }
            int bitIndex = Integer.parseInt(t);
            assert (bitIndex >= 0);
            assert (vectorIndex < numBitVectors);
            b[vectorIndex].set(bitIndex);
            if (c != '}') continue;
            ++vectorIndex;
        }
        return b;
    }

    private int generateHash(long v, int hashNum) {
        int mod = Integer.MAX_VALUE;
        long tempHash = (long)this.a[hashNum] * v + (long)this.b[hashNum];
        int hash = (int)(tempHash %= (long)mod);
        if (hash < 0) {
            hash += mod;
        }
        return hash;
    }

    private int generateHashForPCSA(long v) {
        int mod = 0x20000000;
        long tempHash = (long)this.a[0] * v + (long)this.b[0];
        int hash = (int)(tempHash %= (long)mod);
        if (hash < 0) {
            hash = hash + mod + 1;
        }
        return hash;
    }

    public void addToEstimator(long v) {
        for (int i = 0; i < this.numBitVectors; ++i) {
            int index;
            int hash = this.generateHash(v, i);
            for (index = 0; index < 31 && hash % 2 != 1; ++index) {
                hash >>= 1;
            }
            this.bitVector[i].set(index);
        }
    }

    public void addToEstimatorPCSA(long v) {
        int index;
        int hash = this.generateHashForPCSA(v);
        int rho = hash / this.numBitVectors;
        for (index = 0; index < 31 && rho % 2 != 1; ++index) {
            rho >>= 1;
        }
        this.bitVector[hash % this.numBitVectors].set(index);
    }

    public void addToEstimator(double d) {
        int v = new Double(d).hashCode();
        this.addToEstimator(v);
    }

    public void addToEstimatorPCSA(double d) {
        int v = new Double(d).hashCode();
        this.addToEstimatorPCSA(v);
    }

    public void addToEstimator(HiveDecimal decimal) {
        int v = decimal.hashCode();
        this.addToEstimator(v);
    }

    public void addToEstimatorPCSA(HiveDecimal decimal) {
        int v = decimal.hashCode();
        this.addToEstimatorPCSA(v);
    }

    public void mergeEstimators(NumDistinctValueEstimator o) {
        for (int i = 0; i < this.numBitVectors; ++i) {
            this.bitVector[i].or(o.getBitVector(i));
        }
    }

    public long estimateNumDistinctValuesPCSA() {
        double numDistinctValues = 0.0;
        long S = 0L;
        for (int i = 0; i < this.numBitVectors; ++i) {
            int index;
            for (index = 0; this.bitVector[i].get(index) && index < 31; ++index) {
            }
            S += (long)index;
        }
        numDistinctValues = (double)this.numBitVectors / 0.77351 * Math.pow(2.0, S / (long)this.numBitVectors);
        return (long)numDistinctValues;
    }

    public long estimateNumDistinctValues() {
        int sumLeastSigZero = 0;
        for (int i = 0; i < this.numBitVectors; ++i) {
            int leastSigZero = this.bitVector[i].nextClearBit(0);
            sumLeastSigZero += leastSigZero;
        }
        double avgLeastSigZero = (double)sumLeastSigZero / ((double)this.numBitVectors * 1.0) - Math.log(0.77351) / Math.log(2.0);
        double numDistinctValues = Math.pow(2.0, avgLeastSigZero);
        return (long)numDistinctValues;
    }
}

