/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parquet.Log;
import parquet.bytes.BytesInput;
import parquet.bytes.CapacityByteArrayOutputStream;
import parquet.column.ColumnDescriptor;
import parquet.column.Encoding;
import parquet.column.page.DictionaryPage;
import parquet.column.page.PageWriteStore;
import parquet.column.page.PageWriter;
import parquet.column.statistics.BooleanStatistics;
import parquet.column.statistics.Statistics;
import parquet.format.converter.ParquetMetadataConverter;
import parquet.hadoop.CodecFactory;
import parquet.hadoop.ParquetFileWriter;
import parquet.io.ParquetEncodingException;
import parquet.schema.MessageType;

class ColumnChunkPageWriteStore
implements PageWriteStore {
    private static final Log LOG = Log.getLog(ColumnChunkPageWriteStore.class);
    private static ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
    private final Map<ColumnDescriptor, ColumnChunkPageWriter> writers = new HashMap<ColumnDescriptor, ColumnChunkPageWriter>();
    private final MessageType schema;
    private final CodecFactory.BytesCompressor compressor;
    private final int initialSize;

    public ColumnChunkPageWriteStore(CodecFactory.BytesCompressor compressor, MessageType schema, int initialSize) {
        this.compressor = compressor;
        this.schema = schema;
        this.initialSize = initialSize;
    }

    @Override
    public PageWriter getPageWriter(ColumnDescriptor path) {
        if (!this.writers.containsKey(path)) {
            this.writers.put(path, new ColumnChunkPageWriter(path, this.compressor, this.initialSize));
        }
        return this.writers.get(path);
    }

    public void flushToFileWriter(ParquetFileWriter writer) throws IOException {
        List<ColumnDescriptor> columns = this.schema.getColumns();
        for (ColumnDescriptor columnDescriptor : columns) {
            ColumnChunkPageWriter pageWriter = this.writers.get(columnDescriptor);
            pageWriter.writeToFileWriter(writer);
        }
    }

    private static final class ColumnChunkPageWriter
    implements PageWriter {
        private final ColumnDescriptor path;
        private final CodecFactory.BytesCompressor compressor;
        private final CapacityByteArrayOutputStream buf;
        private DictionaryPage dictionaryPage;
        private long uncompressedLength;
        private long compressedLength;
        private long totalValueCount;
        private int pageCount;
        private Set<Encoding> encodings = new HashSet<Encoding>();
        private Statistics totalStatistics;

        private ColumnChunkPageWriter(ColumnDescriptor path, CodecFactory.BytesCompressor compressor, int initialSize) {
            this.path = path;
            this.compressor = compressor;
            this.buf = new CapacityByteArrayOutputStream(initialSize);
            this.totalStatistics = Statistics.getStatsBasedOnType(this.path.getType());
        }

        @Override
        @Deprecated
        public void writePage(BytesInput bytes, int valueCount, Encoding rlEncoding, Encoding dlEncoding, Encoding valuesEncoding) throws IOException {
            long uncompressedSize = bytes.size();
            if (uncompressedSize > Integer.MAX_VALUE) {
                throw new ParquetEncodingException("Cannot write page larger than Integer.MAX_VALUE bytes: " + uncompressedSize);
            }
            BytesInput compressedBytes = this.compressor.compress(bytes);
            long compressedSize = compressedBytes.size();
            if (compressedSize > Integer.MAX_VALUE) {
                throw new ParquetEncodingException("Cannot write compressed page larger than Integer.MAX_VALUE bytes: " + compressedSize);
            }
            BooleanStatistics statistics = new BooleanStatistics();
            parquetMetadataConverter.writeDataPageHeader((int)uncompressedSize, (int)compressedSize, valueCount, statistics, rlEncoding, dlEncoding, valuesEncoding, this.buf);
            this.uncompressedLength += uncompressedSize;
            this.compressedLength += compressedSize;
            this.totalValueCount += (long)valueCount;
            ++this.pageCount;
            compressedBytes.writeAllTo(this.buf);
            this.encodings.add(rlEncoding);
            this.encodings.add(dlEncoding);
            this.encodings.add(valuesEncoding);
        }

        @Override
        public void writePage(BytesInput bytes, int valueCount, Statistics statistics, Encoding rlEncoding, Encoding dlEncoding, Encoding valuesEncoding) throws IOException {
            long uncompressedSize = bytes.size();
            if (uncompressedSize > Integer.MAX_VALUE) {
                throw new ParquetEncodingException("Cannot write page larger than Integer.MAX_VALUE bytes: " + uncompressedSize);
            }
            BytesInput compressedBytes = this.compressor.compress(bytes);
            long compressedSize = compressedBytes.size();
            if (compressedSize > Integer.MAX_VALUE) {
                throw new ParquetEncodingException("Cannot write compressed page larger than Integer.MAX_VALUE bytes: " + compressedSize);
            }
            parquetMetadataConverter.writeDataPageHeader((int)uncompressedSize, (int)compressedSize, valueCount, statistics, rlEncoding, dlEncoding, valuesEncoding, this.buf);
            this.uncompressedLength += uncompressedSize;
            this.compressedLength += compressedSize;
            this.totalValueCount += (long)valueCount;
            ++this.pageCount;
            this.totalStatistics.mergeStatistics(statistics);
            compressedBytes.writeAllTo(this.buf);
            this.encodings.add(rlEncoding);
            this.encodings.add(dlEncoding);
            this.encodings.add(valuesEncoding);
        }

        @Override
        public long getMemSize() {
            return this.buf.size();
        }

        public void writeToFileWriter(ParquetFileWriter writer) throws IOException {
            writer.startColumn(this.path, this.totalValueCount, this.compressor.getCodecName());
            if (this.dictionaryPage != null) {
                writer.writeDictionaryPage(this.dictionaryPage);
                this.encodings.add(this.dictionaryPage.getEncoding());
            }
            writer.writeDataPages(BytesInput.from(this.buf), this.uncompressedLength, this.compressedLength, this.totalStatistics, new ArrayList<Encoding>(this.encodings));
            writer.endColumn();
            if (Log.INFO) {
                LOG.info(String.format("written %,dB for %s: %,d values, %,dB raw, %,dB comp, %d pages, encodings: %s", this.buf.size(), this.path, this.totalValueCount, this.uncompressedLength, this.compressedLength, this.pageCount, this.encodings) + (this.dictionaryPage != null ? String.format(", dic { %,d entries, %,dB raw, %,dB comp}", this.dictionaryPage.getDictionarySize(), this.dictionaryPage.getUncompressedSize(), this.dictionaryPage.getDictionarySize()) : ""));
            }
            this.encodings.clear();
            this.pageCount = 0;
        }

        @Override
        public long allocatedSize() {
            return this.buf.getCapacity();
        }

        @Override
        public void writeDictionaryPage(DictionaryPage dictionaryPage) throws IOException {
            if (this.dictionaryPage != null) {
                throw new ParquetEncodingException("Only one dictionary page is allowed");
            }
            BytesInput dictionaryBytes = dictionaryPage.getBytes();
            int uncompressedSize = (int)dictionaryBytes.size();
            BytesInput compressedBytes = this.compressor.compress(dictionaryBytes);
            this.dictionaryPage = new DictionaryPage(BytesInput.copy(compressedBytes), uncompressedSize, dictionaryPage.getDictionarySize(), dictionaryPage.getEncoding());
        }

        @Override
        public String memUsageString(String prefix) {
            return this.buf.memUsageString(prefix + " ColumnChunkPageWriter");
        }
    }
}

