/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;

public class VectorizedRCFileRecordReader
implements RecordReader<NullWritable, VectorizedRowBatch> {
    private final RCFile.Reader in;
    private final long start;
    private final long end;
    private boolean more = true;
    protected Configuration conf;
    private final FileSplit split;
    private final boolean useCache;
    private VectorizedRowBatchCtx rbCtx;
    private final LongWritable keyCache = new LongWritable();
    private final BytesRefArrayWritable colsCache = new BytesRefArrayWritable();
    private boolean addPartitionCols = true;
    private final DataOutputBuffer buffer = new DataOutputBuffer();
    private static RCFileSyncCache syncCache = new RCFileSyncCache();

    public VectorizedRCFileRecordReader(Configuration conf, FileSplit split) throws IOException {
        Path path = split.getPath();
        FileSystem fs = path.getFileSystem(conf);
        this.in = new RCFile.Reader(fs, path, conf);
        this.end = split.getStart() + split.getLength();
        this.conf = conf;
        this.split = split;
        this.useCache = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVEUSERCFILESYNCCACHE);
        if (split.getStart() > this.in.getPosition()) {
            long oldSync;
            long l = oldSync = this.useCache ? syncCache.get(split) : -1L;
            if (oldSync == -1L) {
                this.in.sync(split.getStart());
            } else {
                this.in.seek(oldSync);
            }
        }
        this.start = this.in.getPosition();
        this.more = this.start < this.end;
        try {
            this.rbCtx = new VectorizedRowBatchCtx();
            this.rbCtx.init(conf, split);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getKeyClass() {
        return LongWritable.class;
    }

    public Class<?> getValueClass() {
        return BytesRefArrayWritable.class;
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public VectorizedRowBatch createValue() {
        VectorizedRowBatch result;
        try {
            result = this.rbCtx.createVectorizedRowBatch();
        }
        catch (HiveException e) {
            throw new RuntimeException("Error creating a batch", e);
        }
        return result;
    }

    public boolean nextBlock() throws IOException {
        return this.in.nextBlock();
    }

    public boolean next(NullWritable key, VectorizedRowBatch value) throws IOException {
        int i;
        VectorizedBatchUtil.setNoNullFields(value);
        this.buffer.reset();
        value.selectedInUse = false;
        for (i = 0; i < value.numCols; ++i) {
            value.cols[i].isRepeating = false;
        }
        try {
            for (i = 0; i < 1024; ++i) {
                this.more = this.next(this.keyCache);
                if (this.more) {
                    if (this.addPartitionCols) {
                        this.rbCtx.addPartitionColsToBatch(value);
                        this.addPartitionCols = false;
                    }
                    this.in.getCurrentRow(this.colsCache);
                    this.rbCtx.addRowToBatch(i, this.colsCache, value, this.buffer);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting next row", e);
        }
        value.size = i;
        return this.more;
    }

    protected boolean next(LongWritable key) throws IOException {
        if (!this.more) {
            return false;
        }
        this.more = this.in.next(key);
        long lastSeenSyncPos = this.in.lastSeenSyncPos();
        if (lastSeenSyncPos >= this.end) {
            if (this.useCache) {
                syncCache.put(this.split, lastSeenSyncPos);
            }
            this.more = false;
            return this.more;
        }
        return this.more;
    }

    public float getProgress() throws IOException {
        if (this.end == this.start) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.in.getPosition() - this.start) / (float)(this.end - this.start));
    }

    public long getPos() throws IOException {
        return this.in.getPosition();
    }

    public RCFile.KeyBuffer getKeyBuffer() {
        return this.in.getCurrentKeyBufferObj();
    }

    protected void seek(long pos) throws IOException {
        this.in.seek(pos);
    }

    public void sync(long pos) throws IOException {
        this.in.sync(pos);
    }

    public void resetBuffer() {
        this.in.resetBuffer();
    }

    public long getStart() {
        return this.start;
    }

    public void close() throws IOException {
        this.in.close();
    }

    private static final class RCFileSyncCache {
        private final Map<String, RCFileSyncEntry> cache = Collections.synchronizedMap(new WeakHashMap());

        public void put(FileSplit split, long endSync) {
            Path path = split.getPath();
            long end = split.getStart() + split.getLength();
            String key = path.toString() + "+" + String.format("%d", end);
            RCFileSyncEntry entry = new RCFileSyncEntry();
            entry.end = end;
            entry.endSync = endSync;
            if (entry.endSync >= entry.end) {
                this.cache.put(key, entry);
            }
        }

        public long get(FileSplit split) {
            Path path = split.getPath();
            long start = split.getStart();
            String key = path.toString() + "+" + String.format("%d", start);
            RCFileSyncEntry entry = this.cache.get(key);
            if (entry != null) {
                return entry.endSync;
            }
            return -1L;
        }
    }

    private static final class RCFileSyncEntry {
        long end;
        long endSync;

        private RCFileSyncEntry() {
        }
    }
}

