/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnStatsTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.StatsTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.GlobalLimitCtx;
import org.apache.hadoop.hive.ql.parse.IndexUpdater;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ColumnStatsDesc;
import org.apache.hadoop.hive.ql.plan.ColumnStatsWork;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;

public abstract class TaskCompiler {
    protected final Log LOG = LogFactory.getLog(TaskCompiler.class);
    protected Hive db;
    protected SessionState.LogHelper console;
    protected HiveConf conf;

    public void init(HiveConf conf, SessionState.LogHelper console, Hive db) {
        this.conf = conf;
        this.db = db;
        this.console = console;
    }

    public void compile(ParseContext pCtx, List<Task<? extends Serializable>> rootTasks, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        Context ctx = pCtx.getContext();
        GlobalLimitCtx globalLimitCtx = pCtx.getGlobalLimitCtx();
        ArrayList<Task<MoveWork>> mvTask = new ArrayList<Task<MoveWork>>();
        List<LoadTableDesc> loadTableWork = pCtx.getLoadTableWork();
        List<LoadFileDesc> loadFileWork = pCtx.getLoadFileWork();
        boolean isCStats = pCtx.getQueryProperties().isAnalyzeRewrite();
        int outerQueryLimit = pCtx.getQueryProperties().getOuterQueryLimit();
        if (pCtx.getFetchTask() != null) {
            return;
        }
        this.optimizeOperatorPlan(pCtx, inputs, outputs);
        if (pCtx.getQueryProperties().isQuery() && !isCStats) {
            if (!loadTableWork.isEmpty() || loadFileWork.size() != 1) {
                throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
            }
            LoadFileDesc loadFileDesc = loadFileWork.get(0);
            String string = loadFileDesc.getColumns();
            String string2 = loadFileDesc.getColumnTypes();
            TableDesc resultTab = pCtx.getFetchTableDesc();
            if (resultTab == null) {
                String resFileFormat = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEQUERYRESULTFILEFORMAT);
                resultTab = PlanUtils.getDefaultQueryOutputTableDesc(string, string2, resFileFormat);
            }
            FetchWork fetch = new FetchWork(loadFileDesc.getSourcePath(), resultTab, outerQueryLimit);
            fetch.setSource(pCtx.getFetchSource());
            fetch.setSink(pCtx.getFetchSink());
            pCtx.setFetchTask((FetchTask)TaskFactory.get(fetch, this.conf, new Task[0]));
            int n = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.HIVELIMITOPTMAXFETCH);
            if (globalLimitCtx.isEnable() && globalLimitCtx.getGlobalLimit() > n) {
                this.LOG.info((Object)("For FetchTask, LIMIT " + globalLimitCtx.getGlobalLimit() + " > " + n + ". Doesn't qualify limit optimiztion."));
                globalLimitCtx.disableOpt();
            }
            if (outerQueryLimit == 0) {
                this.LOG.info((Object)"Limit 0. No query execution needed.");
                return;
            }
        } else if (!isCStats) {
            for (LoadTableDesc loadTableDesc : loadTableWork) {
                Task<MoveWork> task = TaskFactory.get(new MoveWork(null, null, loadTableDesc, null, false), this.conf, new Task[0]);
                mvTask.add(task);
                if (!HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVEINDEXAUTOUPDATE)) continue;
                IndexUpdater indexUpdater = new IndexUpdater(loadTableWork, inputs, (Configuration)this.conf);
                try {
                    List<Task<? extends Serializable>> indexUpdateTasks = indexUpdater.generateUpdateTasks();
                    for (Task<? extends Serializable> updateTask : indexUpdateTasks) {
                        task.addDependentTask(updateTask);
                    }
                }
                catch (HiveException e) {
                    this.console.printInfo("WARNING: could not auto-update stale indexes, which are not in sync");
                }
            }
            boolean oneLoadFile = true;
            for (LoadFileDesc loadFileDesc : loadFileWork) {
                if (pCtx.getQueryProperties().isCTAS()) {
                    Path location;
                    assert (oneLoadFile);
                    String loc = pCtx.getCreateTable().getLocation();
                    if (loc == null) {
                        Path path;
                        try {
                            String[] names = Utilities.getDbTableName(pCtx.getCreateTable().getTableName());
                            if (!this.db.databaseExists(names[0])) {
                                throw new SemanticException("ERROR: The database " + names[0] + " does not exist.");
                            }
                            Warehouse wh = new Warehouse((Configuration)this.conf);
                            path = wh.getTablePath(this.db.getDatabase(names[0]), names[1]);
                        }
                        catch (HiveException e) {
                            throw new SemanticException(e);
                        }
                        catch (MetaException e) {
                            throw new SemanticException(e);
                        }
                        location = path;
                    } else {
                        location = new Path(loc);
                    }
                    loadFileDesc.setTargetDir(location);
                    oneLoadFile = false;
                }
                mvTask.add(TaskFactory.get(new MoveWork(null, null, null, loadFileDesc, false), this.conf, new Task[0]));
            }
        }
        this.generateTaskTree(rootTasks, pCtx, mvTask, inputs, outputs);
        if (isCStats) {
            this.genColumnStatsTask(pCtx.getAnalyzeRewrite(), loadTableWork, loadFileWork, rootTasks, outerQueryLimit);
        }
        for (Task<? extends Serializable> task : rootTasks) {
            GenMapRedUtils.setKeyAndValueDescForTaskTree(task);
        }
        for (Task<? extends Serializable> task : rootTasks) {
            this.setInputFormat(task);
        }
        this.optimizeTaskPlan(rootTasks, pCtx, ctx);
        this.decideExecMode(rootTasks, ctx, globalLimitCtx);
        if (pCtx.getQueryProperties().isCTAS()) {
            CreateTableDesc crtTblDesc = pCtx.getCreateTable();
            crtTblDesc.validate(this.conf);
            Iterator<WriteEntity> iterator = outputs.iterator();
            block13: while (iterator.hasNext()) {
                switch (iterator.next().getType()) {
                    case DFS_DIR: 
                    case LOCAL_DIR: {
                        iterator.remove();
                        continue block13;
                    }
                }
            }
            Task<DDLWork> task = TaskFactory.get(new DDLWork(inputs, outputs, crtTblDesc), this.conf, new Task[0]);
            LinkedHashSet<Task<? extends Serializable>> leaves = new LinkedHashSet<Task<? extends Serializable>>();
            this.getLeafTasks(rootTasks, leaves);
            assert (leaves.size() > 0);
            for (Task task2 : leaves) {
                if (task2 instanceof StatsTask) {
                    for (Task<Serializable> parentOfStatsTask : task2.getParentTasks()) {
                        parentOfStatsTask.addDependentTask(task);
                    }
                    for (Task<Serializable> parentOfCrtTblTask : task.getParentTasks()) {
                        parentOfCrtTblTask.removeDependentTask(task2);
                    }
                    task.addDependentTask(task2);
                    continue;
                }
                task2.addDependentTask(task);
            }
        }
        if (globalLimitCtx.isEnable() && pCtx.getFetchTask() != null) {
            this.LOG.info((Object)("set least row check for FetchTask: " + globalLimitCtx.getGlobalLimit()));
            ((FetchWork)pCtx.getFetchTask().getWork()).setLeastNumRows(globalLimitCtx.getGlobalLimit());
        }
        if (globalLimitCtx.isEnable() && globalLimitCtx.getLastReduceLimitDesc() != null) {
            this.LOG.info((Object)("set least row check for LimitDesc: " + globalLimitCtx.getGlobalLimit()));
            globalLimitCtx.getLastReduceLimitDesc().setLeastRows(globalLimitCtx.getGlobalLimit());
            List<ExecDriver> mrTasks = Utilities.getMRTasks(rootTasks);
            for (ExecDriver execDriver : mrTasks) {
                execDriver.setRetryCmdWhenFail(true);
            }
            List<SparkTask> list = Utilities.getSparkTasks(rootTasks);
            for (SparkTask sparkTask : list) {
                sparkTask.setRetryCmdWhenFail(true);
            }
        }
        Interner interner = Interners.newStrongInterner();
        for (Task<? extends Serializable> task : rootTasks) {
            GenMapRedUtils.internTableDesc(task, (Interner<TableDesc>)interner);
        }
    }

    protected void genColumnStatsTask(BaseSemanticAnalyzer.AnalyzeRewriteContext analyzeRewrite, List<LoadTableDesc> loadTableWork, List<LoadFileDesc> loadFileWork, List<Task<? extends Serializable>> rootTasks, int outerQueryLimit) {
        ColumnStatsTask cStatsTask = null;
        ColumnStatsWork cStatsWork = null;
        FetchWork fetch = null;
        String tableName = analyzeRewrite.getTableName();
        List<String> colName = analyzeRewrite.getColName();
        List<String> colType = analyzeRewrite.getColType();
        boolean isTblLevel = analyzeRewrite.isTblLvl();
        String cols = loadFileWork.get(0).getColumns();
        String colTypes = loadFileWork.get(0).getColumnTypes();
        String resFileFormat = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEQUERYRESULTFILEFORMAT);
        TableDesc resultTab = PlanUtils.getDefaultQueryOutputTableDesc(cols, colTypes, resFileFormat);
        fetch = new FetchWork(loadFileWork.get(0).getSourcePath(), resultTab, outerQueryLimit);
        ColumnStatsDesc cStatsDesc = new ColumnStatsDesc(tableName, colName, colType, isTblLevel);
        cStatsWork = new ColumnStatsWork(fetch, cStatsDesc);
        cStatsTask = (ColumnStatsTask)TaskFactory.get(cStatsWork, this.conf, new Task[0]);
        rootTasks.get(0).addDependentTask(cStatsTask);
    }

    protected void getLeafTasks(List<Task<? extends Serializable>> rootTasks, HashSet<Task<? extends Serializable>> leaves) {
        for (Task<? extends Serializable> root : rootTasks) {
            this.getLeafTasks(root, leaves);
        }
    }

    private void getLeafTasks(Task<? extends Serializable> task, HashSet<Task<? extends Serializable>> leaves) {
        if (task.getDependentTasks() == null) {
            if (!leaves.contains(task)) {
                leaves.add(task);
            }
        } else {
            this.getLeafTasks(task.getDependentTasks(), leaves);
        }
    }

    protected abstract void decideExecMode(List<Task<? extends Serializable>> var1, Context var2, GlobalLimitCtx var3) throws SemanticException;

    protected void optimizeOperatorPlan(ParseContext pCtxSet, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
    }

    protected abstract void optimizeTaskPlan(List<Task<? extends Serializable>> var1, ParseContext var2, Context var3) throws SemanticException;

    protected abstract void setInputFormat(Task<? extends Serializable> var1);

    protected abstract void generateTaskTree(List<Task<? extends Serializable>> var1, ParseContext var2, List<Task<MoveWork>> var3, Set<ReadEntity> var4, Set<WriteEntity> var5) throws SemanticException;

    public ParseContext getParseContext(ParseContext pCtx, List<Task<? extends Serializable>> rootTasks) {
        ParseContext clone = new ParseContext(this.conf, pCtx.getOpToPartPruner(), pCtx.getOpToPartList(), pCtx.getTopOps(), pCtx.getJoinOps(), pCtx.getSmbMapJoinOps(), pCtx.getLoadTableWork(), pCtx.getLoadFileWork(), pCtx.getContext(), pCtx.getIdToTableNameMap(), pCtx.getDestTableId(), pCtx.getUCtx(), pCtx.getListMapJoinOpsNoReducer(), pCtx.getPrunedPartitions(), pCtx.getOpToSamplePruner(), pCtx.getGlobalLimitCtx(), pCtx.getNameToSplitSample(), pCtx.getSemanticInputs(), rootTasks, pCtx.getOpToPartToSkewedPruner(), pCtx.getViewAliasToInput(), pCtx.getReduceSinkOperatorsAddedByEnforceBucketingSorting(), pCtx.getAnalyzeRewrite(), pCtx.getCreateTable(), pCtx.getQueryProperties());
        clone.setFetchTask(pCtx.getFetchTask());
        clone.setLineageInfo(pCtx.getLineageInfo());
        clone.setMapJoinOps(pCtx.getMapJoinOps());
        return clone;
    }
}

