/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.SettableUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.NullWritable;

public class TypeCheckProcFactory {
    protected static final Log LOG = LogFactory.getLog((String)TypeCheckProcFactory.class.getName());

    protected TypeCheckProcFactory() {
    }

    public static ExprNodeDesc processGByExpr(Node nd, Object procCtx) throws SemanticException {
        ASTNode expr = (ASTNode)nd;
        TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
        RowResolver input = ctx.getInputRR();
        ExprNodeColumnDesc desc = null;
        if (ctx == null || input == null || !ctx.getAllowGBExprElimination()) {
            return null;
        }
        ColumnInfo colInfo = input.getExpression(expr);
        if (colInfo != null) {
            desc = new ExprNodeColumnDesc(colInfo);
            ASTNode source = input.getExpressionSource(expr);
            if (source != null) {
                ctx.getUnparseTranslator().addCopyTranslation(expr, source);
            }
            return desc;
        }
        return desc;
    }

    public static Map<ASTNode, ExprNodeDesc> genExprNode(ASTNode expr, TypeCheckCtx tcCtx) throws SemanticException {
        return TypeCheckProcFactory.genExprNode(expr, tcCtx, new TypeCheckProcFactory());
    }

    protected static Map<ASTNode, ExprNodeDesc> genExprNode(ASTNode expr, TypeCheckCtx tcCtx, TypeCheckProcFactory tf) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", "764%"), tf.getNullExprProcessor());
        opRules.put(new RuleRegExp("R2", "302%|315%|312%|7%|18%"), tf.getNumExprProcessor());
        opRules.put(new RuleRegExp("R3", "26%|313%|653%|861%|%|129%|49%|287%|132%|35%|164%|250%|102%|867%"), tf.getStrExprProcessor());
        opRules.put(new RuleRegExp("R4", "265%|107%"), tf.getBoolExprProcessor());
        opRules.put(new RuleRegExp("R5", "672%|905%"), tf.getDateTimeExprProcessor());
        opRules.put(new RuleRegExp("R6", "741%|734%|739%|737%|732%|735%|736%|738%"), tf.getIntervalExprProcessor());
        opRules.put(new RuleRegExp("R7", "894%"), tf.getColumnExprProcessor());
        opRules.put(new RuleRegExp("R8", "865%"), tf.getSubQueryExprProcessor());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(tf.getDefaultExprProcessor(), opRules, tcCtx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList topNodes = Lists.newArrayList((Object[])new Node[]{expr});
        LinkedHashMap<Node, Object> nodeOutputs = new LinkedHashMap<Node, Object>();
        ogw.startWalking(topNodes, nodeOutputs);
        return TypeCheckProcFactory.convert(nodeOutputs);
    }

    private static Map<ASTNode, ExprNodeDesc> convert(Map<Node, Object> outputs) {
        LinkedHashMap<ASTNode, ExprNodeDesc> converted = new LinkedHashMap<ASTNode, ExprNodeDesc>();
        for (Map.Entry<Node, Object> entry : outputs.entrySet()) {
            if (entry.getKey() instanceof ASTNode && (entry.getValue() == null || entry.getValue() instanceof ExprNodeDesc)) {
                converted.put((ASTNode)entry.getKey(), (ExprNodeDesc)entry.getValue());
                continue;
            }
            LOG.warn((Object)("Invalid type entry " + entry));
        }
        return converted;
    }

    public NullExprProcessor getNullExprProcessor() {
        return new NullExprProcessor();
    }

    public NumExprProcessor getNumExprProcessor() {
        return new NumExprProcessor();
    }

    public StrExprProcessor getStrExprProcessor() {
        return new StrExprProcessor();
    }

    public BoolExprProcessor getBoolExprProcessor() {
        return new BoolExprProcessor();
    }

    public DateTimeExprProcessor getDateTimeExprProcessor() {
        return new DateTimeExprProcessor();
    }

    public IntervalExprProcessor getIntervalExprProcessor() {
        return new IntervalExprProcessor();
    }

    private static ExprNodeDesc toExprNodeDesc(ColumnInfo colInfo) {
        ObjectInspector inspector = colInfo.getObjectInspector();
        if (inspector instanceof ConstantObjectInspector && inspector instanceof PrimitiveObjectInspector) {
            PrimitiveObjectInspector poi = (PrimitiveObjectInspector)inspector;
            Object constant = ((ConstantObjectInspector)inspector).getWritableConstantValue();
            return new ExprNodeConstantDesc(colInfo.getType(), poi.getPrimitiveJavaObject(constant));
        }
        ExprNodeColumnDesc column = new ExprNodeColumnDesc(colInfo);
        column.setSkewedCol(colInfo.isSkewedCol());
        return column;
    }

    public ColumnExprProcessor getColumnExprProcessor() {
        return new ColumnExprProcessor();
    }

    public DefaultExprProcessor getDefaultExprProcessor() {
        return new DefaultExprProcessor();
    }

    public SubQueryExprProcessor getSubQueryExprProcessor() {
        return new SubQueryExprProcessor();
    }

    public static class SubQueryExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ASTNode expr = (ASTNode)nd;
            ASTNode sqNode = (ASTNode)expr.getParent().getChild(1);
            if (!ctx.getallowSubQueryExpr()) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(sqNode, ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg()));
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ctx.setError(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(sqNode, "Currently SubQuery expressions are only allowed as Where Clause predicates"), sqNode);
            return null;
        }
    }

    public static class DefaultExprProcessor
    implements NodeProcessor {
        static HashMap<Integer, String> specialUnaryOperatorTextHashMap = new HashMap();
        static HashMap<Integer, String> specialFunctionTextHashMap;
        static HashMap<Integer, String> conversionFunctionTextHashMap;
        static HashSet<Integer> windowingTokens;

        protected static boolean isRedundantConversionFunction(ASTNode expr, boolean isFunction, ArrayList<ExprNodeDesc> children) {
            if (!isFunction) {
                return false;
            }
            if (children.size() != 1) {
                return false;
            }
            String funcText = conversionFunctionTextHashMap.get(((ASTNode)expr.getChild(0)).getType());
            if (funcText == null) {
                return false;
            }
            return ((PrimitiveTypeInfo)children.get(0).getTypeInfo()).getTypeName().equalsIgnoreCase(funcText);
        }

        public static String getFunctionText(ASTNode expr, boolean isFunction) {
            String funcText = null;
            if (!isFunction) {
                if (expr.getChildCount() == 1) {
                    funcText = specialUnaryOperatorTextHashMap.get(expr.getType());
                }
                if (funcText == null) {
                    funcText = expr.getText();
                }
            } else {
                assert (expr.getChildCount() >= 1);
                int funcType = ((ASTNode)expr.getChild(0)).getType();
                funcText = specialFunctionTextHashMap.get(funcType);
                if (funcText == null) {
                    funcText = conversionFunctionTextHashMap.get(funcType);
                }
                if (funcText == null) {
                    funcText = ((ASTNode)expr.getChild(0)).getText();
                }
            }
            return BaseSemanticAnalyzer.unescapeIdentifier(funcText);
        }

        static ExprNodeDesc getFuncExprNodeDescWithUdfData(String udfName, TypeInfo typeInfo, ExprNodeDesc ... children) throws UDFArgumentException {
            FunctionInfo fi;
            try {
                fi = FunctionRegistry.getFunctionInfo(udfName);
            }
            catch (SemanticException e) {
                throw new UDFArgumentException(e);
            }
            if (fi == null) {
                throw new UDFArgumentException(udfName + " not found.");
            }
            GenericUDF genericUDF = fi.getGenericUDF();
            if (genericUDF == null) {
                throw new UDFArgumentException(udfName + " is an aggregation function or a table function.");
            }
            if (typeInfo != null && genericUDF instanceof SettableUDF) {
                ((SettableUDF)((Object)genericUDF)).setTypeInfo(typeInfo);
            }
            ArrayList<ExprNodeDesc> childrenList = new ArrayList<ExprNodeDesc>(children.length);
            childrenList.addAll(Arrays.asList(children));
            return ExprNodeGenericFuncDesc.newInstance(genericUDF, childrenList);
        }

        public static ExprNodeDesc getFuncExprNodeDesc(String udfName, ExprNodeDesc ... children) throws UDFArgumentException {
            return DefaultExprProcessor.getFuncExprNodeDescWithUdfData(udfName, null, children);
        }

        protected void validateUDF(ASTNode expr, boolean isFunction, TypeCheckCtx ctx, FunctionInfo fi, List<ExprNodeDesc> children, GenericUDF genericUDF) throws SemanticException {
            if (fi.getGenericUDTF() != null) {
                throw new SemanticException(ErrorMsg.UDTF_INVALID_LOCATION.getMsg());
            }
            if (fi.getGenericUDAFResolver() != null) {
                if (isFunction) {
                    throw new SemanticException(ErrorMsg.UDAF_INVALID_LOCATION.getMsg((ASTNode)expr.getChild(0)));
                }
                throw new SemanticException(ErrorMsg.UDAF_INVALID_LOCATION.getMsg(expr));
            }
            if (!ctx.getAllowStatefulFunctions() && genericUDF != null && FunctionRegistry.isStateful(genericUDF)) {
                throw new SemanticException(ErrorMsg.UDF_STATEFUL_INVALID_LOCATION.getMsg());
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected ExprNodeDesc getXpathOrFuncExprNodeDesc(ASTNode expr, boolean isFunction, ArrayList<ExprNodeDesc> children, TypeCheckCtx ctx) throws SemanticException, UDFArgumentException {
            void var12_29;
            void var12_27;
            if (DefaultExprProcessor.isRedundantConversionFunction(expr, isFunction, children)) {
                assert (children.size() == 1);
                assert (children.get(0) != null);
                return children.get(0);
            }
            String funcText = DefaultExprProcessor.getFunctionText(expr, isFunction);
            if (funcText.equals(".")) {
                boolean isList;
                assert (children.size() == 2);
                assert (children.get(1) instanceof ExprNodeConstantDesc);
                ExprNodeDesc object = children.get(0);
                ExprNodeConstantDesc fieldName = (ExprNodeConstantDesc)children.get(1);
                assert (fieldName.getValue() instanceof String);
                String fieldNameString = (String)fieldName.getValue();
                TypeInfo objectTypeInfo = object.getTypeInfo();
                boolean bl = isList = object.getTypeInfo().getCategory() == ObjectInspector.Category.LIST;
                if (isList) {
                    objectTypeInfo = ((ListTypeInfo)objectTypeInfo).getListElementTypeInfo();
                }
                if (objectTypeInfo.getCategory() != ObjectInspector.Category.STRUCT) {
                    throw new SemanticException(ErrorMsg.INVALID_DOT.getMsg(expr));
                }
                TypeInfo t = ((StructTypeInfo)objectTypeInfo).getStructFieldTypeInfo(fieldNameString);
                if (isList) {
                    t = TypeInfoFactory.getListTypeInfo(t);
                }
                ExprNodeFieldDesc exprNodeFieldDesc = new ExprNodeFieldDesc(t, children.get(0), fieldNameString, isList);
            } else if (funcText.equals("[")) {
                if (!ctx.getallowIndexExpr()) {
                    throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(expr));
                }
                assert (children.size() == 2);
                TypeInfo myt = children.get(0).getTypeInfo();
                if (myt.getCategory() == ObjectInspector.Category.LIST) {
                    if (!FunctionRegistry.implicitConvertible(children.get(1).getTypeInfo(), TypeInfoFactory.intTypeInfo)) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.INVALID_ARRAYINDEX_TYPE.getMsg()));
                    }
                    TypeInfo t = ((ListTypeInfo)myt).getListElementTypeInfo();
                    ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = new ExprNodeGenericFuncDesc(t, FunctionRegistry.getGenericUDFForIndex(), children);
                } else {
                    if (myt.getCategory() != ObjectInspector.Category.MAP) throw new SemanticException(ErrorMsg.NON_COLLECTION_TYPE.getMsg(expr, myt.getTypeName()));
                    if (!FunctionRegistry.implicitConvertible(children.get(1).getTypeInfo(), ((MapTypeInfo)myt).getMapKeyTypeInfo())) {
                        throw new SemanticException(ErrorMsg.INVALID_MAPINDEX_TYPE.getMsg(expr));
                    }
                    TypeInfo t = ((MapTypeInfo)myt).getMapValueTypeInfo();
                    ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = new ExprNodeGenericFuncDesc(t, FunctionRegistry.getGenericUDFForIndex(), children);
                }
            } else {
                FunctionInfo fi = FunctionRegistry.getFunctionInfo(funcText);
                if (fi == null) {
                    if (!isFunction) throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(expr));
                    throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg((ASTNode)expr.getChild(0)));
                }
                GenericUDF genericUDF = fi.getGenericUDF();
                if (!fi.isNative()) {
                    ctx.getUnparseTranslator().addIdentifierTranslation((ASTNode)expr.getChild(0));
                }
                if (isFunction) {
                    ASTNode funcNameNode = (ASTNode)expr.getChild(0);
                    switch (funcNameNode.getType()) {
                        case 652: {
                            CharTypeInfo charTypeInfo = ParseUtils.getCharTypeInfo(funcNameNode);
                            if (genericUDF == null) break;
                            ((SettableUDF)((Object)genericUDF)).setTypeInfo(charTypeInfo);
                            break;
                        }
                        case 924: {
                            VarcharTypeInfo varcharTypeInfo = ParseUtils.getVarcharTypeInfo(funcNameNode);
                            if (genericUDF == null) break;
                            ((SettableUDF)((Object)genericUDF)).setTypeInfo(varcharTypeInfo);
                            break;
                        }
                        case 676: {
                            DecimalTypeInfo decTypeInfo = ParseUtils.getDecimalTypeTypeInfo(funcNameNode);
                            if (genericUDF == null) break;
                            ((SettableUDF)((Object)genericUDF)).setTypeInfo(decTypeInfo);
                            break;
                        }
                    }
                }
                this.validateUDF(expr, isFunction, ctx, fi, children, genericUDF);
                if (genericUDF instanceof GenericUDFBaseCompare && children.size() == 2 && (children.get(0) instanceof ExprNodeConstantDesc && children.get(1) instanceof ExprNodeColumnDesc || children.get(0) instanceof ExprNodeColumnDesc && children.get(1) instanceof ExprNodeConstantDesc)) {
                    int constIdx = children.get(0) instanceof ExprNodeConstantDesc ? 0 : 1;
                    HashSet<String> inferTypes = new HashSet<String>(Arrays.asList("tinyint".toLowerCase(), "smallint".toLowerCase(), "int".toLowerCase(), "bigint".toLowerCase(), "float".toLowerCase(), "double".toLowerCase(), "string".toLowerCase()));
                    String constType = children.get(constIdx).getTypeString().toLowerCase();
                    String columnType = children.get(1 - constIdx).getTypeString().toLowerCase();
                    if (inferTypes.contains(constType) && inferTypes.contains(columnType) && !columnType.equalsIgnoreCase(constType)) {
                        void var16_43;
                        Object originalValue = ((ExprNodeConstantDesc)children.get(constIdx)).getValue();
                        String constValue = originalValue.toString();
                        boolean triedDouble = false;
                        Object var16_33 = null;
                        try {
                            if (columnType.equalsIgnoreCase("tinyint")) {
                                Byte by = new Byte(constValue);
                            } else if (columnType.equalsIgnoreCase("smallint")) {
                                Short s = new Short(constValue);
                            } else if (columnType.equalsIgnoreCase("int")) {
                                Integer n = new Integer(constValue);
                            } else if (columnType.equalsIgnoreCase("bigint")) {
                                Long l = new Long(constValue);
                            } else if (columnType.equalsIgnoreCase("float")) {
                                Float f = new Float(constValue);
                            } else if (columnType.equalsIgnoreCase("double")) {
                                triedDouble = true;
                                Double d = new Double(constValue);
                            } else if (columnType.equalsIgnoreCase("string")) {
                                boolean isNumber = originalValue instanceof Number;
                                triedDouble = !isNumber;
                                Number number = isNumber ? (Number)((Number)originalValue) : (Number)new Double(constValue);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            if (triedDouble || genericUDF instanceof GenericUDFOPEqual && !columnType.equals("string")) {
                                return new ExprNodeConstantDesc(false);
                            }
                            try {
                                Double d = new Double(constValue);
                            }
                            catch (NumberFormatException ex) {
                                return new ExprNodeConstantDesc(false);
                            }
                        }
                        if (var16_43 != null) {
                            children.set(constIdx, new ExprNodeConstantDesc(var16_43));
                        }
                    }
                }
                ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = ExprNodeGenericFuncDesc.newInstance(genericUDF, funcText, children);
            }
            if (FunctionRegistry.isOpPositive((ExprNodeDesc)var12_27)) {
                assert (var12_27.getChildren().size() == 1);
                ExprNodeDesc exprNodeDesc = var12_27.getChildren().get(0);
            }
            assert (var12_29 != null);
            return var12_29;
        }

        private boolean isDescendant(Node ans, Node des) {
            if (ans.getChildren() == null) {
                return false;
            }
            for (Node node : ans.getChildren()) {
                if (node == des) {
                    return true;
                }
                if (!this.isDescendant(node, des)) continue;
                return true;
            }
            return false;
        }

        protected ExprNodeDesc processQualifiedColRef(TypeCheckCtx ctx, ASTNode expr, Object ... nodeOutputs) throws SemanticException {
            String colName;
            RowResolver input = ctx.getInputRR();
            String tableAlias = BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText());
            if (nodeOutputs[1] instanceof ExprNodeConstantDesc) {
                colName = ((ExprNodeConstantDesc)nodeOutputs[1]).getValue().toString();
            } else if (nodeOutputs[1] instanceof ExprNodeColumnDesc) {
                colName = ((ExprNodeColumnDesc)nodeOutputs[1]).getColumn();
            } else {
                throw new SemanticException("Unexpected ExprNode : " + nodeOutputs[1]);
            }
            ColumnInfo colInfo = input.get(tableAlias, colName);
            if (colInfo == null) {
                ctx.setError(ErrorMsg.INVALID_COLUMN.getMsg(expr.getChild(1)), expr);
                return null;
            }
            return TypeCheckProcFactory.toExprNodeDesc(colInfo);
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            boolean isFunction;
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                if (this.isDescendant(nd, ctx.getErrorSrcNode())) {
                    ctx.setError(null, null);
                }
                return desc;
            }
            if (ctx.getError() != null) {
                return null;
            }
            ASTNode expr = (ASTNode)nd;
            if (windowingTokens.contains(expr.getType())) {
                if (!ctx.getallowWindowing()) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.INVALID_FUNCTION.getMsg("Windowing is not supported in the context")));
                }
                return null;
            }
            if (expr.getType() == 897) {
                return null;
            }
            if (expr.getType() == 606) {
                if (!ctx.getallowAllColRef()) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.INVALID_COLUMN.getMsg("All column reference is not supported in the context")));
                }
                RowResolver input = ctx.getInputRR();
                ExprNodeColumnListDesc columnList = new ExprNodeColumnListDesc();
                assert (expr.getChildCount() <= 1);
                if (expr.getChildCount() == 1) {
                    ASTNode child = (ASTNode)expr.getChild(0);
                    assert (child.getType() == 897);
                    assert (child.getChildCount() == 1);
                    String tableAlias = BaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
                    HashMap<String, ColumnInfo> columns = input.getFieldMap(tableAlias);
                    if (columns == null) {
                        throw new SemanticException(ErrorMsg.INVALID_TABLE_ALIAS.getMsg(child));
                    }
                    for (Map.Entry<String, ColumnInfo> colMap : columns.entrySet()) {
                        ColumnInfo colInfo = colMap.getValue();
                        if (colInfo.getIsVirtualCol()) continue;
                        columnList.addColumn(TypeCheckProcFactory.toExprNodeDesc(colInfo));
                    }
                } else {
                    for (ColumnInfo colInfo : input.getColumnInfos()) {
                        if (colInfo.getIsVirtualCol()) continue;
                        columnList.addColumn(TypeCheckProcFactory.toExprNodeDesc(colInfo));
                    }
                }
                return columnList;
            }
            if (expr.getType() == 17 && expr.getChild(0).getType() == 894 && nodeOutputs[0] == null) {
                return this.processQualifiedColRef(ctx, expr, nodeOutputs);
            }
            if (conversionFunctionTextHashMap.keySet().contains(expr.getType()) || specialFunctionTextHashMap.keySet().contains(expr.getType()) || expr.getToken().getType() == 13 || expr.getToken().getType() == 12) {
                return null;
            }
            boolean bl = isFunction = expr.getType() == 705 || expr.getType() == 707 || expr.getType() == 706;
            if (!ctx.getAllowDistinctFunctions() && expr.getType() == 706) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.DISTINCT_NOT_SUPPORTED.getMsg()));
            }
            int childrenBegin = isFunction ? 1 : 0;
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>(expr.getChildCount() - childrenBegin);
            for (int ci = childrenBegin; ci < expr.getChildCount(); ++ci) {
                if (nodeOutputs[ci] instanceof ExprNodeColumnListDesc) {
                    children.addAll(((ExprNodeColumnListDesc)nodeOutputs[ci]).getChildren());
                    continue;
                }
                children.add((ExprNodeDesc)nodeOutputs[ci]);
            }
            if (expr.getType() == 707) {
                if (!ctx.getallowFunctionStar()) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(expr, ErrorMsg.INVALID_COLUMN.getMsg(".* reference is not supported in the context")));
                }
                RowResolver input = ctx.getInputRR();
                for (ColumnInfo colInfo : input.getColumnInfos()) {
                    if (colInfo.getIsVirtualCol()) continue;
                    children.add(TypeCheckProcFactory.toExprNodeDesc(colInfo));
                }
            }
            if (children.contains(null)) {
                List<String> possibleColumnNames = this.getReferenceableColumnAliases(ctx);
                String reason = String.format("(possible column names are: %s)", StringUtils.join(possibleColumnNames, (String)", "));
                ctx.setError(ErrorMsg.INVALID_COLUMN.getMsg(expr.getChild(0), reason), expr);
                return null;
            }
            try {
                return this.getXpathOrFuncExprNodeDesc(expr, isFunction, children, ctx);
            }
            catch (UDFArgumentTypeException e) {
                throw new SemanticException(ErrorMsg.INVALID_ARGUMENT_TYPE.getMsg(expr.getChild(childrenBegin + e.getArgumentId()), e.getMessage()));
            }
            catch (UDFArgumentLengthException e) {
                throw new SemanticException(ErrorMsg.INVALID_ARGUMENT_LENGTH.getMsg(expr, e.getMessage()));
            }
            catch (UDFArgumentException e) {
                throw new SemanticException(ErrorMsg.INVALID_ARGUMENT.getMsg(expr, e.getMessage()));
            }
        }

        protected List<String> getReferenceableColumnAliases(TypeCheckCtx ctx) {
            return ctx.getInputRR().getReferenceableColumnAliases(null, -1);
        }

        static {
            specialUnaryOperatorTextHashMap.put(303, "positive");
            specialUnaryOperatorTextHashMap.put(299, "negative");
            specialFunctionTextHashMap = new HashMap();
            specialFunctionTextHashMap.put(743, "isnull");
            specialFunctionTextHashMap.put(742, "isnotnull");
            conversionFunctionTextHashMap = new HashMap();
            conversionFunctionTextHashMap.put(650, "boolean");
            conversionFunctionTextHashMap.put(906, "tinyint");
            conversionFunctionTextHashMap.put(855, "smallint");
            conversionFunctionTextHashMap.put(731, "int");
            conversionFunctionTextHashMap.put(648, "bigint");
            conversionFunctionTextHashMap.put(702, "float");
            conversionFunctionTextHashMap.put(686, "double");
            conversionFunctionTextHashMap.put(860, "string");
            conversionFunctionTextHashMap.put(652, "char");
            conversionFunctionTextHashMap.put(924, "varchar");
            conversionFunctionTextHashMap.put(649, "binary");
            conversionFunctionTextHashMap.put(671, "date");
            conversionFunctionTextHashMap.put(904, "timestamp");
            conversionFunctionTextHashMap.put(740, "interval_year_month");
            conversionFunctionTextHashMap.put(733, "interval_day_time");
            conversionFunctionTextHashMap.put(676, "decimal");
            windowingTokens = new HashSet();
            windowingTokens.add(188);
            windowingTokens.add(787);
            windowingTokens.add(685);
            windowingTokens.add(856);
            windowingTokens.add(654);
            windowingTokens.add(931);
            windowingTokens.add(930);
            windowingTokens.add(932);
            windowingTokens.add(268);
            windowingTokens.add(197);
            windowingTokens.add(114);
            windowingTokens.add(69);
            windowingTokens.add(899);
            windowingTokens.add(900);
        }
    }

    public static class ColumnExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            ASTNode parent = stack.size() > 1 ? (ASTNode)stack.get(stack.size() - 2) : null;
            RowResolver input = ctx.getInputRR();
            if (expr.getType() != 894) {
                ctx.setError(ErrorMsg.INVALID_COLUMN.getMsg(expr), expr);
                return null;
            }
            assert (expr.getChildCount() == 1);
            String tableOrCol = BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText());
            boolean isTableAlias = input.hasTableAlias(tableOrCol);
            ColumnInfo colInfo = input.get(null, tableOrCol);
            if (isTableAlias) {
                if (colInfo != null) {
                    if (parent != null && parent.getType() == 17) {
                        return null;
                    }
                    return TypeCheckProcFactory.toExprNodeDesc(colInfo);
                }
                return null;
            }
            if (colInfo == null) {
                if (input.getIsExprResolver()) {
                    ASTNode exprNode = expr;
                    if (!stack.empty()) {
                        ASTNode tmp = (ASTNode)stack.pop();
                        if (!stack.empty()) {
                            exprNode = (ASTNode)stack.peek();
                        }
                        stack.push(tmp);
                    }
                    ctx.setError(ErrorMsg.NON_KEY_EXPR_IN_GROUPBY.getMsg(exprNode), expr);
                    return null;
                }
                List<String> possibleColumnNames = input.getReferenceableColumnAliases(tableOrCol, -1);
                String reason = String.format("(possible column names are: %s)", StringUtils.join(possibleColumnNames, (String)", "));
                ctx.setError(ErrorMsg.INVALID_TABLE_OR_COLUMN.getMsg(expr.getChild(0), reason), expr);
                LOG.debug((Object)(ErrorMsg.INVALID_TABLE_OR_COLUMN.toString() + ":" + input.toString()));
                return null;
            }
            return TypeCheckProcFactory.toExprNodeDesc(colInfo);
        }
    }

    public static class IntervalExprProcessor
    implements NodeProcessor {
        private static final BigDecimal NANOS_PER_SEC_BD = new BigDecimal(1000000000);

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            String intervalString = BaseSemanticAnalyzer.stripQuotes(expr.getText());
            try {
                switch (expr.getType()) {
                    case 741: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalYearMonthTypeInfo, HiveIntervalYearMonth.valueOf(intervalString));
                    }
                    case 734: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, HiveIntervalDayTime.valueOf(intervalString));
                    }
                    case 739: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalYearMonthTypeInfo, new HiveIntervalYearMonth(Integer.parseInt(intervalString), 0));
                    }
                    case 737: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalYearMonthTypeInfo, new HiveIntervalYearMonth(0, Integer.parseInt(intervalString)));
                    }
                    case 732: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, new HiveIntervalDayTime(Integer.parseInt(intervalString), 0, 0, 0, 0));
                    }
                    case 735: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, new HiveIntervalDayTime(0, Integer.parseInt(intervalString), 0, 0, 0));
                    }
                    case 736: {
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, new HiveIntervalDayTime(0, 0, Integer.parseInt(intervalString), 0, 0));
                    }
                    case 738: {
                        BigDecimal bd = new BigDecimal(intervalString);
                        BigDecimal bdSeconds = new BigDecimal(bd.toBigInteger());
                        BigDecimal bdNanos = bd.subtract(bdSeconds);
                        return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, new HiveIntervalDayTime(0, 0, 0, bdSeconds.intValueExact(), bdNanos.multiply(NANOS_PER_SEC_BD).intValue()));
                    }
                }
                throw new IllegalArgumentException("Invalid time literal type " + expr.getType());
            }
            catch (Exception err) {
                throw new SemanticException("Unable to convert interval literal '" + intervalString + "' to interval value.", err);
            }
        }
    }

    public static class DateTimeExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            String timeString = BaseSemanticAnalyzer.stripQuotes(expr.getText());
            try {
                if (expr.getType() == 672) {
                    PrimitiveTypeInfo typeInfo = TypeInfoFactory.dateTypeInfo;
                    return new ExprNodeConstantDesc(typeInfo, Date.valueOf(timeString));
                }
                if (expr.getType() == 905) {
                    return new ExprNodeConstantDesc(TypeInfoFactory.timestampTypeInfo, Timestamp.valueOf(timeString));
                }
                throw new IllegalArgumentException("Invalid time literal type " + expr.getType());
            }
            catch (Exception err) {
                throw new SemanticException("Unable to convert time literal '" + timeString + "' to time value.", err);
            }
        }
    }

    public static class BoolExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            Boolean bool = null;
            switch (expr.getToken().getType()) {
                case 265: {
                    bool = Boolean.TRUE;
                    break;
                }
                case 107: {
                    bool = Boolean.FALSE;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return new ExprNodeConstantDesc(TypeInfoFactory.booleanTypeInfo, bool);
        }
    }

    public static class StrExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            ASTNode expr = (ASTNode)nd;
            String str = null;
            switch (expr.getToken().getType()) {
                case 313: {
                    str = BaseSemanticAnalyzer.unescapeSQLString(expr.getText());
                    break;
                }
                case 861: {
                    StringBuilder sb = new StringBuilder();
                    for (Node n : expr.getChildren()) {
                        sb.append(BaseSemanticAnalyzer.unescapeSQLString(((ASTNode)n).getText()));
                    }
                    str = sb.toString();
                    break;
                }
                case 653: {
                    str = BaseSemanticAnalyzer.charSetString(expr.getChild(0).getText(), expr.getChild(1).getText());
                    break;
                }
                default: {
                    str = BaseSemanticAnalyzer.unescapeIdentifier(expr.getText());
                }
            }
            return new ExprNodeConstantDesc(TypeInfoFactory.stringTypeInfo, str);
        }
    }

    public static class NumExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            Number v = null;
            ASTNode expr = (ASTNode)nd;
            try {
                if (expr.getText().endsWith("L")) {
                    v = Long.valueOf(expr.getText().substring(0, expr.getText().length() - 1));
                } else if (expr.getText().endsWith("S")) {
                    v = Short.valueOf(expr.getText().substring(0, expr.getText().length() - 1));
                } else if (expr.getText().endsWith("Y")) {
                    v = Byte.valueOf(expr.getText().substring(0, expr.getText().length() - 1));
                } else {
                    if (expr.getText().endsWith("BD")) {
                        String strVal = expr.getText().substring(0, expr.getText().length() - 2);
                        HiveDecimal hd = HiveDecimal.create(strVal);
                        int prec = 1;
                        int scale = 0;
                        if (hd != null) {
                            prec = hd.precision();
                            scale = hd.scale();
                        }
                        DecimalTypeInfo typeInfo = TypeInfoFactory.getDecimalTypeInfo(prec, scale);
                        return new ExprNodeConstantDesc(typeInfo, hd);
                    }
                    v = Double.valueOf(expr.getText());
                    v = Long.valueOf(expr.getText());
                    v = Integer.valueOf(expr.getText());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (v == null) {
                throw new SemanticException(ErrorMsg.INVALID_NUMERICAL_CONSTANT.getMsg(expr));
            }
            return new ExprNodeConstantDesc(v);
        }
    }

    public static class NullExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TypeCheckCtx ctx = (TypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = TypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            return new ExprNodeConstantDesc(TypeInfoFactory.getPrimitiveTypeInfoFromPrimitiveWritable(NullWritable.class), null);
        }
    }
}

