/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;

public class TezSessionPoolManager {
    private static final Log LOG = LogFactory.getLog(TezSessionPoolManager.class);
    private BlockingQueue<TezSessionState> defaultQueuePool;
    private int blockingQueueLength = -1;
    private HiveConf initConf = null;
    private boolean inited = false;
    private static TezSessionPoolManager sessionPool = null;
    private static List<TezSessionState> openSessions = Collections.synchronizedList(new LinkedList());

    public static TezSessionPoolManager getInstance() throws Exception {
        if (sessionPool == null) {
            sessionPool = new TezSessionPoolManager();
        }
        return sessionPool;
    }

    protected TezSessionPoolManager() {
    }

    public void startPool() throws Exception {
        this.inited = true;
        for (int i = 0; i < this.blockingQueueLength; ++i) {
            HiveConf newConf = new HiveConf(this.initConf);
            TezSessionState sessionState = this.defaultQueuePool.take();
            newConf.set("tez.queue.name", sessionState.getQueueName());
            sessionState.open(newConf);
            openSessions.add(sessionState);
            this.defaultQueuePool.put(sessionState);
        }
    }

    public void setupPool(HiveConf conf) throws InterruptedException {
        String defaultQueues = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_SERVER2_TEZ_DEFAULT_QUEUES);
        int numSessions = conf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSIONS_PER_DEFAULT_QUEUE);
        String[] defaultQueueList = defaultQueues.split(",");
        this.defaultQueuePool = new ArrayBlockingQueue<TezSessionState>(numSessions * defaultQueueList.length);
        this.initConf = conf;
        this.blockingQueueLength = 0;
        for (int i = 0; i < numSessions; ++i) {
            for (String queue : defaultQueueList) {
                if (queue.length() == 0) continue;
                TezSessionState sessionState = this.createSession(TezSessionState.makeSessionId());
                sessionState.setQueueName(queue);
                sessionState.setDefault();
                LOG.info((Object)("Created new tez session for queue: " + queue + " with session id: " + sessionState.getSessionId()));
                this.defaultQueuePool.put(sessionState);
                ++this.blockingQueueLength;
            }
        }
    }

    private TezSessionState getSession(HiveConf conf, boolean doOpen, boolean forceCreate) throws Exception {
        String queueName = conf.get("tez.queue.name");
        boolean nonDefaultUser = conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS);
        if (forceCreate || !this.inited || queueName != null && !queueName.isEmpty() || nonDefaultUser || this.defaultQueuePool == null || this.blockingQueueLength <= 0) {
            LOG.info((Object)("QueueName: " + queueName + " nonDefaultUser: " + nonDefaultUser + " defaultQueuePool: " + this.defaultQueuePool + " blockingQueueLength: " + this.blockingQueueLength));
            return this.getNewSessionState(conf, queueName, doOpen);
        }
        LOG.info((Object)"Choosing a session from the defaultQueuePool");
        return this.defaultQueuePool.take();
    }

    private TezSessionState getNewSessionState(HiveConf conf, String queueName, boolean doOpen) throws Exception {
        TezSessionState retTezSessionState = this.createSession(TezSessionState.makeSessionId());
        if (queueName != null) {
            conf.set("tez.queue.name", queueName);
        }
        String what = "Created";
        if (doOpen) {
            retTezSessionState.open(conf);
            openSessions.add(retTezSessionState);
            what = "Started";
        }
        LOG.info((Object)(what + " a new session for queue: " + queueName + " session id: " + retTezSessionState.getSessionId()));
        return retTezSessionState;
    }

    public void returnSession(TezSessionState tezSessionState) throws Exception {
        if (tezSessionState.isDefault()) {
            LOG.info((Object)("The session " + tezSessionState.getSessionId() + " belongs to the pool. Put it back in"));
            SessionState sessionState = SessionState.get();
            if (sessionState != null) {
                sessionState.setTezSession(null);
            }
            this.defaultQueuePool.put(tezSessionState);
        }
    }

    public void close(TezSessionState tezSessionState, boolean keepTmpDir) throws Exception {
        LOG.info((Object)("Closing tez session default? " + tezSessionState.isDefault()));
        if (!tezSessionState.isDefault()) {
            tezSessionState.close(keepTmpDir);
            openSessions.remove(tezSessionState);
        }
    }

    public void stop() throws Exception {
        if (sessionPool == null || !this.inited) {
            return;
        }
        Iterator<TezSessionState> iter = openSessions.iterator();
        while (iter.hasNext()) {
            TezSessionState sessionState = iter.next();
            if (!sessionState.isDefault()) continue;
            sessionState.close(false);
            iter.remove();
        }
    }

    protected TezSessionState createSession(String sessionId) {
        return new TezSessionState(sessionId);
    }

    public TezSessionState getSession(TezSessionState session, HiveConf conf, boolean doOpen) throws Exception {
        return this.getSession(session, conf, doOpen, false);
    }

    private boolean canWorkWithSameSession(TezSessionState session, HiveConf conf) throws HiveException {
        if (session == null || conf == null) {
            return false;
        }
        try {
            UserGroupInformation ugi = Utils.getUGI();
            String userName = ugi.getShortUserName();
            LOG.info((Object)("The current user: " + userName + ", session user: " + session.getUser()));
            if (!userName.equals(session.getUser())) {
                LOG.info((Object)("Different users incoming: " + userName + " existing: " + session.getUser()));
                return false;
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        boolean doAsEnabled = conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS);
        if (doAsEnabled != conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS)) {
            return false;
        }
        if (!session.isDefault()) {
            String queueName = session.getQueueName();
            LOG.info((Object)("Current queue name is " + queueName + " incoming queue name is " + conf.get("tez.queue.name")));
            if (queueName == null) {
                return conf.get("tez.queue.name") == null;
            }
            return queueName.equals(conf.get("tez.queue.name"));
        }
        throw new HiveException("Default queue should always be returned.Hence we should not be here.");
    }

    public TezSessionState getSession(TezSessionState session, HiveConf conf, boolean doOpen, boolean forceCreate) throws Exception {
        if (this.canWorkWithSameSession(session, conf)) {
            return session;
        }
        if (session != null) {
            this.close(session, false);
        }
        return this.getSession(conf, doOpen, forceCreate);
    }

    public void closeAndOpen(TezSessionState sessionState, HiveConf conf, boolean keepTmpDir) throws Exception {
        this.closeAndOpen(sessionState, conf, null, keepTmpDir);
    }

    public void closeAndOpen(TezSessionState sessionState, HiveConf conf, String[] additionalFiles, boolean keepTmpDir) throws Exception {
        HiveConf sessionConf = sessionState.getConf();
        if (sessionConf != null && sessionConf.get("tez.queue.name") != null) {
            conf.set("tez.queue.name", sessionConf.get("tez.queue.name"));
        }
        this.close(sessionState, keepTmpDir);
        sessionState.open(conf, additionalFiles);
        openSessions.add(sessionState);
    }

    public List<TezSessionState> getOpenSessions() {
        return openSessions;
    }
}

