/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class UDFArgumentException
extends SemanticException {
    private Class<?> funcClass;
    private List<TypeInfo> argTypeInfos;
    private List<Method> methods;

    public UDFArgumentException() {
    }

    public UDFArgumentException(String message) {
        super(message);
    }

    public UDFArgumentException(Throwable cause) {
        super(cause);
    }

    public UDFArgumentException(String message, Class<?> funcClass, List<TypeInfo> argTypeInfos, List<Method> methods) {
        super(UDFArgumentException.getMessage(message, funcClass, argTypeInfos, methods));
        this.funcClass = funcClass;
        this.argTypeInfos = argTypeInfos;
        this.methods = methods;
    }

    private static String getMessage(String message, Class<?> funcClass, List<TypeInfo> argTypeInfos, List<Method> methods) {
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        if (methods != null) {
            UDFArgumentException.sortMethods(methods);
            sb.append(". Possible choices: ");
            for (Method m : methods) {
                Type[] types = m.getGenericParameterTypes();
                sb.append("_FUNC_(");
                ArrayList typeNames = new ArrayList(types.length);
                for (int t = 0; t < types.length; ++t) {
                    if (t > 0) {
                        sb.append(", ");
                    }
                    sb.append(ObjectInspectorUtils.getTypeNameFromJavaClass(types[t]));
                }
                sb.append(")  ");
            }
        }
        return sb.toString();
    }

    private static void sortMethods(List<Method> methods) {
        Collections.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                int result = m1.getName().compareTo(m2.getName());
                if (result != 0) {
                    return result;
                }
                Type[] types1 = m1.getGenericParameterTypes();
                Type[] types2 = m2.getGenericParameterTypes();
                for (int i = 0; i < types1.length && i < types2.length; ++i) {
                    String type2;
                    String type1 = ObjectInspectorUtils.getTypeNameFromJavaClass(types1[i]);
                    result = type1.compareTo(type2 = ObjectInspectorUtils.getTypeNameFromJavaClass(types2[i]));
                    if (result == 0) continue;
                    return result;
                }
                return types1.length - types2.length;
            }
        });
    }

    public Class<?> getFunctionClass() {
        return this.funcClass;
    }

    public List<TypeInfo> getArgTypeList() {
        return this.argTypeInfos;
    }

    public List<Method> getMethods() {
        return this.methods;
    }
}

