/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SparkRecordHandler {
    protected static final String CLASS_NAME = SparkRecordHandler.class.getName();
    protected final PerfLogger perfLogger = SessionState.getPerfLogger();
    private static final Logger LOG = LoggerFactory.getLogger(SparkRecordHandler.class);
    protected final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    protected JobConf jc;
    protected OutputCollector<?, ?> oc;
    protected Reporter rp;
    protected boolean abort = false;
    private long rowNumber = 0L;
    private long nextLogThreshold = 1L;

    public <K, V> void init(JobConf job, OutputCollector<K, V> output, Reporter reporter) throws Exception {
        this.jc = job;
        MapredContext.init(false, new JobConf((Configuration)this.jc));
        MapredContext.get().setReporter(reporter);
        this.oc = output;
        this.rp = reporter;
        LOG.info("maximum memory = " + this.memoryMXBean.getHeapMemoryUsage().getMax());
        try {
            LOG.info("conf classpath = " + Arrays.asList(((URLClassLoader)job.getClassLoader()).getURLs()));
            LOG.info("thread classpath = " + Arrays.asList(((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs()));
        }
        catch (Exception e) {
            LOG.info("cannot get classpath: " + e.getMessage());
        }
    }

    public abstract void processRow(Object var1, Object var2) throws IOException;

    public abstract <E> void processRow(Object var1, Iterator<E> var2) throws IOException;

    protected void logMemoryInfo() {
        ++this.rowNumber;
        if (this.rowNumber == this.nextLogThreshold) {
            long usedMemory = this.memoryMXBean.getHeapMemoryUsage().getUsed();
            LOG.info("processing " + this.rowNumber + " rows: used memory = " + usedMemory);
            this.nextLogThreshold = this.getNextLogThreshold(this.rowNumber);
        }
    }

    public abstract void close();

    public abstract boolean getDone();

    protected void logCloseInfo() {
        long usedMemory = this.memoryMXBean.getHeapMemoryUsage().getUsed();
        LOG.info("processed " + this.rowNumber + " rows: used memory = " + usedMemory);
    }

    private long getNextLogThreshold(long currentThreshold) {
        if (currentThreshold >= 1000000L) {
            return currentThreshold + 1000000L;
        }
        return 10L * currentThreshold;
    }

    public boolean isAbort() {
        return this.abort;
    }

    public void setAbort(boolean abort) {
        this.abort = abort;
    }
}

