/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Date;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.io.Text;
import org.apache.hive.common.util.DateParser;

public class VectorUDFDateAddColScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private int outputColumn;
    private int numDays;
    protected boolean isPositive = true;
    private final transient Text text = new Text();
    private final transient DateParser dateParser = new DateParser();
    private final transient Date date = new Date(0L);

    public VectorUDFDateAddColScalar(int colNum, long numDays, int outputColumn) {
        this.colNum = colNum;
        this.numDays = (int)numDays;
        this.outputColumn = outputColumn;
    }

    public VectorUDFDateAddColScalar() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        boolean selectedInUse;
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumn];
        ColumnVector inputCol = batch.cols[this.colNum];
        int n = inputCol.isRepeating ? 1 : batch.size;
        int[] sel = batch.selected;
        boolean bl = selectedInUse = !inputCol.isRepeating && batch.selectedInUse;
        if (batch.size == 0) {
            return;
        }
        outV.isRepeating = inputCol.isRepeating;
        switch (this.inputTypes[0]) {
            case DATE: {
                if (inputCol.noNulls) {
                    outV.noNulls = true;
                    if (selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.vector[i] = this.evaluateDate(inputCol, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.vector[i] = this.evaluateDate(inputCol, i);
                        }
                    }
                } else {
                    outV.noNulls = false;
                    if (selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outV.vector[i] = this.evaluateDate(inputCol, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outV.vector[i] = this.evaluateDate(inputCol, i);
                        }
                    }
                }
                break;
            }
            case TIMESTAMP: {
                if (inputCol.noNulls) {
                    outV.noNulls = true;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.vector[i] = this.evaluateTimestamp(inputCol, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.vector[i] = this.evaluateTimestamp(inputCol, i);
                        }
                    }
                } else {
                    outV.noNulls = false;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outV.vector[i] = this.evaluateTimestamp(inputCol, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outV.vector[i] = this.evaluateTimestamp(inputCol, i);
                        }
                    }
                }
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                if (inputCol.noNulls) {
                    outV.noNulls = true;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            this.evaluateString(inputCol, outV, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            this.evaluateString(inputCol, outV, i);
                        }
                    }
                } else {
                    outV.noNulls = false;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            this.evaluateString(inputCol, outV, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            this.evaluateString(inputCol, outV, i);
                        }
                    }
                }
                break;
            }
            default: {
                throw new Error("Unsupported input type " + this.inputTypes[0].name());
            }
        }
    }

    protected long evaluateTimestamp(ColumnVector columnVector, int index) {
        TimestampColumnVector tcv = (TimestampColumnVector)columnVector;
        long days = DateWritable.millisToDays(tcv.getTime(index));
        days = this.isPositive ? (days += (long)this.numDays) : (days -= (long)this.numDays);
        return days;
    }

    protected long evaluateDate(ColumnVector columnVector, int index) {
        LongColumnVector lcv = (LongColumnVector)columnVector;
        long days = lcv.vector[index];
        days = this.isPositive ? (days += (long)this.numDays) : (days -= (long)this.numDays);
        return days;
    }

    protected void evaluateString(ColumnVector columnVector, LongColumnVector outputVector, int i) {
        BytesColumnVector bcv = (BytesColumnVector)columnVector;
        this.text.set(bcv.vector[i], bcv.start[i], bcv.length[i]);
        boolean parsed = this.dateParser.parseDate(this.text.toString(), this.date);
        if (!parsed) {
            outputVector.noNulls = false;
            outputVector.isNull[i] = true;
            return;
        }
        long days = DateWritable.millisToDays(this.date.getTime());
        days = this.isPositive ? (days += (long)this.numDays) : (days -= (long)this.numDays);
        outputVector.vector[i] = days;
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "date";
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    public int getNumDays() {
        return this.numDays;
    }

    public void setNumDay(int numDays) {
        this.numDays = numDays;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum + ", val " + this.numDays;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_DATETIME_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR);
        return b.build();
    }
}

