/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jdo.JDOEnhancer;
import javax.jdo.JDOException;
import javax.jdo.JDOHelper;
import javax.jdo.spi.I18NHelper;

public class Enhancer {
    private static final I18NHelper msg = I18NHelper.getInstance("javax.jdo.Bundle");
    private char NL = (char)10;
    private String JAR_FILE_SUFFIX = ".jar";
    private String JDO_FILE_SUFFIX = ".jdo";
    private String CLASS_FILE_SUFFIX = ".class";
    private boolean error = false;
    private boolean printAndExit = false;
    private List<String> persistenceUnitNames = new ArrayList<String>();
    private String directoryName = null;
    private ClassLoader loader = null;
    private String classPath = null;
    private boolean checkOnly = false;
    private boolean verbose = false;
    private boolean recurse = false;
    private StringBuilder errorBuffer = new StringBuilder();
    private StringBuilder verboseBuffer = new StringBuilder();
    private List<String> fileNames = new ArrayList<String>();
    private List<String> classFileNames = new ArrayList<String>();
    private List<String> jdoFileNames = new ArrayList<String>();
    private List<String> jarFileNames = new ArrayList<String>();
    private int numberOfValidatedClasses = 0;
    private int numberOfEnhancedClasses = 0;
    private Properties properties;

    public static void main(String[] args) {
        Enhancer enhancerMain = new Enhancer();
        enhancerMain.run(args);
    }

    private void run(String[] args) {
        this.processArgs(args);
        JDOEnhancer enhancer = null;
        try {
            enhancer = JDOHelper.getEnhancer();
        }
        catch (JDOException jdoex) {
            jdoex.printStackTrace();
            this.exit(2);
        }
        try {
            int numberOfFiles;
            int numberOfClasses;
            this.properties = enhancer.getProperties();
            this.addVerboseMessage("MSG_EnhancerClass", enhancer.getClass().getName());
            this.addVerboseMessage("MSG_EnhancerProperty", "VendorName", this.properties.getProperty("VendorName"));
            this.addVerboseMessage("MSG_EnhancerProperty", "VersionNumber", this.properties.getProperty("VersionNumber"));
            Set<Map.Entry<Object, Object>> props = this.properties.entrySet();
            for (Map.Entry<Object, Object> entry : props) {
                if ("VendorName".equals(entry.getKey()) || "VersionNumber".equals(entry.getKey())) continue;
                this.addVerboseMessage("MSG_EnhancerProperty", (String)entry.getKey(), (String)entry.getValue());
            }
            enhancer.setVerbose(this.verbose);
            if (this.loader != null) {
                enhancer.setClassLoader(this.loader);
            }
            if ((numberOfClasses = this.classFileNames.size()) != 0) {
                enhancer.addClasses(this.classFileNames.toArray(new String[numberOfClasses]));
            }
            if ((numberOfFiles = this.jdoFileNames.size()) != 0) {
                enhancer.addFiles(this.jdoFileNames.toArray(new String[numberOfFiles]));
            }
            if (0 < this.jarFileNames.size()) {
                for (String jarFileName : this.jarFileNames) {
                    enhancer.addJar(jarFileName);
                }
            }
            if (this.persistenceUnitNames != null) {
                for (String persistenceUnitName : this.persistenceUnitNames) {
                    enhancer.addPersistenceUnit(persistenceUnitName);
                }
            }
            if (this.directoryName != null) {
                enhancer.setOutputDirectory(this.directoryName);
            }
            if (this.checkOnly) {
                this.numberOfValidatedClasses = enhancer.validate();
                this.addVerboseMessage("MSG_EnhancerValidatedClasses", this.numberOfValidatedClasses);
            } else {
                this.numberOfEnhancedClasses = enhancer.enhance();
                this.addVerboseMessage("MSG_EnhancerEnhancedClasses", this.numberOfEnhancedClasses);
            }
            this.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.exit(1);
        }
    }

    private void processArgs(String[] args) {
        this.parseArgs(args);
        this.parseFiles(this.fileNames.toArray(new String[this.fileNames.size()]), true, this.recurse);
        this.loader = this.prepareClassLoader(this.classPath);
        if (this.error) {
            this.addErrorMessage(msg.msg("MSG_EnhancerUsage"));
            this.exit(3);
        }
        if (this.printAndExit) {
            this.addVerboseMessage("MSG_EnhancerUsage");
            this.exit(0);
        }
    }

    private void parseArgs(String[] args) {
        boolean doneWithOptions = false;
        this.fileNames = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("?".equals(arg)) {
                this.printAndExit = true;
                return;
            }
            if (!doneWithOptions) {
                if (arg.startsWith("-")) {
                    String option = arg.substring(1);
                    if ("help".equals(option)) {
                        this.addVerboseMessage("MSG_EnhancerProcessing", "-help");
                        this.setPrintAndExit();
                        continue;
                    }
                    if ("h".equals(option)) {
                        this.addVerboseMessage("MSG_EnhancerProcessing", "-h");
                        this.setPrintAndExit();
                        continue;
                    }
                    if ("v".equals(option)) {
                        this.addVerboseMessage("MSG_EnhancerProcessing", "-v");
                        this.verbose = true;
                        continue;
                    }
                    if ("verbose".equals(option)) {
                        this.addVerboseMessage("MSG_EnhancerProcessing", "-verbose");
                        this.verbose = true;
                        continue;
                    }
                    if ("pu".equals(option)) {
                        if (this.hasNextArgument("MSG_EnhancerProcessing", "-pu", i, args.length)) {
                            String puName = args[++i];
                            this.addVerboseMessage("MSG_EnhancerPersistenceUnitName", puName);
                            this.persistenceUnitNames.add(puName);
                            continue;
                        }
                        this.setError();
                        continue;
                    }
                    if ("cp".equals(option)) {
                        if (this.hasNextArgument("MSG_EnhancerProcessing", "-cp", i, args.length)) {
                            this.classPath = args[++i];
                            this.addVerboseMessage("MSG_EnhancerClassPath", this.classPath);
                            continue;
                        }
                        this.setError();
                        continue;
                    }
                    if ("d".equals(option)) {
                        if (this.hasNextArgument("MSG_EnhancerProcessing", "-d", i, args.length)) {
                            this.directoryName = args[++i];
                            this.addVerboseMessage("MSG_EnhancerOutputDirectory", this.directoryName);
                            continue;
                        }
                        this.setError();
                        continue;
                    }
                    if ("checkonly".equals(option)) {
                        this.addVerboseMessage("MSG_EnhancerProcessing", "-checkonly");
                        this.checkOnly = true;
                        continue;
                    }
                    if ("r".equals(option)) {
                        this.addVerboseMessage("MSG_EnhancerProcessing", "-r");
                        this.recurse = true;
                        continue;
                    }
                    this.setError();
                    this.addErrorMessage(msg.msg("ERR_EnhancerUnrecognizedOption", option));
                    continue;
                }
                doneWithOptions = true;
                this.fileNames.add(arg);
                continue;
            }
            this.fileNames.add(arg);
        }
    }

    private boolean hasNextArgument(String msgId, String where, int i, int length) {
        if (i + 1 >= length) {
            this.setError();
            this.addErrorMessage(msg.msg(msgId, where));
            this.addErrorMessage(msg.msg("ERR_EnhancerRequiredArgumentMissing"));
            return false;
        }
        return true;
    }

    private void parseFiles(String[] fileNames, boolean search, boolean recurse) {
        for (String fileName : fileNames) {
            if (fileName.endsWith(this.JAR_FILE_SUFFIX)) {
                this.jarFileNames.add(fileName);
                this.addVerboseMessage("MSG_EnhancerJarFileName", fileName);
                continue;
            }
            if (fileName.endsWith(this.JDO_FILE_SUFFIX)) {
                this.jdoFileNames.add(fileName);
                this.addVerboseMessage("MSG_EnhancerJDOFileName", fileName);
                continue;
            }
            if (fileName.endsWith(this.CLASS_FILE_SUFFIX)) {
                this.classFileNames.add(fileName);
                this.addVerboseMessage("MSG_EnhancerClassFileName", fileName);
                continue;
            }
            File directoryFile = new File(fileName);
            if (!directoryFile.isDirectory() || !search) continue;
            String directoryPath = directoryFile.getAbsolutePath();
            String[] files = directoryFile.list();
            String[] pathName = new String[1];
            if (files == null) continue;
            for (String file : files) {
                pathName[0] = directoryPath + '/' + file;
                this.parseFiles(pathName, recurse, recurse);
            }
        }
    }

    private ClassLoader prepareClassLoader(String classPath) {
        if (classPath == null) {
            return null;
        }
        URLClassLoader result = null;
        String separator = System.getProperty("path.separator");
        String[] paths = classPath.split(separator);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : paths) {
            File file = new File(path);
            URI uri = file.toURI();
            try {
                URL url = uri.toURL();
                this.addVerboseMessage("MSG_EnhancerClassPath", url.toString());
                urls.add(url);
            }
            catch (MalformedURLException e) {
                this.setError();
                this.addErrorMessage(msg.msg("ERR_EnhancerBadClassPath", file));
            }
        }
        result = new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
        return result;
    }

    private void addErrorMessage(String message) {
        this.errorBuffer.append(message);
        this.errorBuffer.append(this.NL);
    }

    private void setError() {
        this.error = true;
    }

    private void setPrintAndExit() {
        this.printAndExit = true;
    }

    private void exit(int exitValue) {
        System.out.print(this.verboseBuffer.toString());
        System.err.print(this.errorBuffer.toString());
        System.exit(exitValue);
    }

    private void addVerboseMessage(String msgId, String ... where) {
        this.verboseBuffer.append(msg.msg(msgId, where));
        this.verboseBuffer.append(this.NL);
    }

    private void addVerboseMessage(String msgId, String where) {
        this.verboseBuffer.append(msg.msg(msgId, where));
        this.verboseBuffer.append(this.NL);
    }

    private void addVerboseMessage(String msgId) {
        this.verboseBuffer.append(msg.msg(msgId));
        this.verboseBuffer.append(this.NL);
    }

    private void addVerboseMessage(String msgId, int where) {
        this.addVerboseMessage(msgId, String.valueOf(where));
    }
}

