/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.jsonexplain.tez;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.jsonexplain.tez.Connection;
import org.apache.hadoop.hive.common.jsonexplain.tez.Printer;
import org.apache.hadoop.hive.common.jsonexplain.tez.TezJsonParser;
import org.apache.hadoop.hive.common.jsonexplain.tez.TezJsonParserUtils;
import org.apache.hadoop.hive.common.jsonexplain.tez.Vertex;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Op {
    public final String name;
    public final TezJsonParser parser;
    public final String operatorId;
    public Op parent;
    public final List<Op> children;
    public final Map<String, String> attrs;
    public final JSONObject opObject;
    public final Vertex vertex;
    public final String outputVertexName;
    public final OpType type;

    public Op(String name, String id, String outputVertexName, List<Op> children, Map<String, String> attrs, JSONObject opObject, Vertex vertex, TezJsonParser tezJsonParser) throws JSONException {
        this.name = name;
        this.operatorId = id;
        this.type = this.deriveOpType(this.operatorId);
        this.outputVertexName = outputVertexName;
        this.children = children;
        this.attrs = attrs;
        this.opObject = opObject;
        this.vertex = vertex;
        this.parser = tezJsonParser;
    }

    private OpType deriveOpType(String operatorId) {
        if (operatorId != null) {
            if (operatorId.startsWith(OpType.MAPJOIN.toString())) {
                return OpType.MAPJOIN;
            }
            if (operatorId.startsWith(OpType.MERGEJOIN.toString())) {
                return OpType.MERGEJOIN;
            }
            if (operatorId.startsWith(OpType.RS.toString())) {
                return OpType.RS;
            }
            return OpType.OTHERS;
        }
        return OpType.OTHERS;
    }

    private void inlineJoinOp() throws Exception {
        if (this.type == OpType.MAPJOIN) {
            JSONObject joinObj = this.opObject.getJSONObject(this.name);
            JSONObject verticeObj = joinObj.getJSONObject("input vertices:");
            LinkedHashMap<String, Vertex> linkedHashMap = new LinkedHashMap<String, Vertex>();
            for (String string : JSONObject.getNames(verticeObj)) {
                String vertexName = verticeObj.getString(string);
                Connection c = null;
                for (Connection connection : this.vertex.parentConnections) {
                    if (!connection.from.name.equals(vertexName)) continue;
                    linkedHashMap.put(string, connection.from);
                    c = connection;
                    break;
                }
                if (c == null) continue;
                this.parser.addInline(this, c);
            }
            this.attrs.remove("input vertices:");
            JSONObject keys = joinObj.getJSONObject("keys:");
            HashSet<Vertex> parentVertexes = new HashSet<Vertex>();
            for (Connection connection : this.vertex.parentConnections) {
                parentVertexes.add(connection.from);
            }
            parentVertexes.removeAll(linkedHashMap.values());
            LinkedHashMap<String, String> posToOpId = new LinkedHashMap<String, String>();
            if (keys.length() != 0) {
                for (String key : JSONObject.getNames(keys)) {
                    Op singleRSOp;
                    Vertex vertex;
                    if (linkedHashMap.containsKey(key)) {
                        vertex = (Vertex)linkedHashMap.get(key);
                        if (vertex.rootOps.size() == 1) {
                            posToOpId.put(key, vertex.rootOps.get((int)0).operatorId);
                            continue;
                        }
                        if (vertex.rootOps.size() == 0 && vertex.vertexType == Vertex.VertexType.UNION) {
                            posToOpId.put(key, vertex.name);
                            continue;
                        }
                        singleRSOp = vertex.getSingleRSOp();
                        if (singleRSOp != null) {
                            posToOpId.put(key, singleRSOp.operatorId);
                            continue;
                        }
                        throw new Exception("There are none or more than one root operators in a single vertex " + vertex.name + " when hive explain user is trying to identify the operator id.");
                    }
                    if (this.parent != null) {
                        posToOpId.put(key, this.parent.operatorId);
                        continue;
                    }
                    if (parentVertexes.size() == 1) {
                        vertex = (Vertex)parentVertexes.iterator().next();
                        parentVertexes.clear();
                        if (vertex.rootOps.size() == 1) {
                            posToOpId.put(key, vertex.rootOps.get((int)0).operatorId);
                            continue;
                        }
                        if (vertex.rootOps.size() == 0 && vertex.vertexType == Vertex.VertexType.UNION) {
                            posToOpId.put(key, vertex.name);
                            continue;
                        }
                        singleRSOp = vertex.getSingleRSOp();
                        if (singleRSOp != null) {
                            posToOpId.put(key, singleRSOp.operatorId);
                            continue;
                        }
                        throw new Exception("There are none or more than one root operators in a single vertex " + vertex.name + " when hive explain user is trying to identify the operator id.");
                    }
                    throw new Exception("Can not find the source operator on one of the branches of map join.");
                }
            }
            this.attrs.remove("keys:");
            StringBuffer stringBuffer = new StringBuffer();
            JSONArray conditionMap = joinObj.getJSONArray("condition map:");
            for (int index = 0; index < conditionMap.length(); ++index) {
                JSONObject cond = conditionMap.getJSONObject(index);
                String k = cond.keys().next();
                JSONObject condObject = new JSONObject((String)cond.get(k));
                String type = condObject.getString("type");
                String left = condObject.getString("left");
                String right = condObject.getString("right");
                if (keys.length() != 0) {
                    stringBuffer.append((String)posToOpId.get(left) + "." + keys.get(left) + "=" + (String)posToOpId.get(right) + "." + keys.get(right) + "(" + type + "),");
                    continue;
                }
                stringBuffer.append("(" + type + "),");
            }
            this.attrs.remove("condition map:");
            this.attrs.put("Conds:", stringBuffer.substring(0, stringBuffer.length() - 1));
        } else {
            JSONObject joinObj;
            JSONObject jSONObject;
            LinkedHashMap posToOpId = new LinkedHashMap();
            if (this.vertex.mergeJoinDummyVertexs.size() == 0) {
                if (this.vertex.tagToInput.size() != this.vertex.parentConnections.size()) {
                    throw new Exception("tagToInput size " + this.vertex.tagToInput.size() + " is different from parentConnections size " + this.vertex.parentConnections.size());
                }
                for (Map.Entry entry : this.vertex.tagToInput.entrySet()) {
                    Object c = null;
                    for (Connection connection : this.vertex.parentConnections) {
                        if (!connection.from.name.equals(entry.getValue())) continue;
                        Vertex vertex = connection.from;
                        if (vertex.rootOps.size() == 1) {
                            posToOpId.put(entry.getKey(), vertex.rootOps.get((int)0).operatorId);
                        } else if (vertex.rootOps.size() == 0 && vertex.vertexType == Vertex.VertexType.UNION) {
                            posToOpId.put(entry.getKey(), vertex.name);
                        } else {
                            Op singleRSOp = vertex.getSingleRSOp();
                            if (singleRSOp != null) {
                                posToOpId.put(entry.getKey(), singleRSOp.operatorId);
                            } else {
                                throw new Exception("There are none or more than one root operators in a single vertex " + vertex.name + " when hive explain user is trying to identify the operator id.");
                            }
                        }
                        c = connection;
                        break;
                    }
                    if (c != null) continue;
                    throw new Exception("Can not find " + (String)entry.getValue() + " while parsing keys of merge join operator");
                }
            } else {
                posToOpId.put(this.vertex.tag, this.parent.operatorId);
                for (Vertex vertex : this.vertex.mergeJoinDummyVertexs) {
                    if (vertex.rootOps.size() != 1) {
                        throw new Exception("Can not find a single root operators in a single vertex " + vertex.name + " when hive explain user is trying to identify the operator id.");
                    }
                    posToOpId.put(vertex.tag, vertex.rootOps.get((int)0).operatorId);
                }
            }
            if ((jSONObject = (joinObj = this.opObject.getJSONObject(this.name)).getJSONObject("keys:")).length() != 0) {
                for (String string : JSONObject.getNames(jSONObject)) {
                    if (posToOpId.containsKey(string)) continue;
                    throw new Exception("Can not find the source operator on one of the branches of merge join.");
                }
                if (this.vertex != null) {
                    for (Vertex v : this.vertex.mergeJoinDummyVertexs) {
                        this.parser.addInline(this, new Connection(null, v));
                    }
                }
            }
            this.attrs.remove("keys:");
            StringBuffer sb = new StringBuffer();
            JSONArray conditionMap = joinObj.getJSONArray("condition map:");
            for (int index = 0; index < conditionMap.length(); ++index) {
                JSONObject jSONObject2 = conditionMap.getJSONObject(index);
                String k = jSONObject2.keys().next();
                JSONObject condObject = new JSONObject((String)jSONObject2.get(k));
                String type = condObject.getString("type");
                String left = condObject.getString("left");
                String right = condObject.getString("right");
                if (jSONObject.length() != 0) {
                    sb.append((String)posToOpId.get(left) + "." + jSONObject.get(left) + "=" + (String)posToOpId.get(right) + "." + jSONObject.get(right) + "(" + type + "),");
                    continue;
                }
                sb.append("(" + type + "),");
            }
            this.attrs.remove("condition map:");
            this.attrs.put("Conds:", sb.substring(0, sb.length() - 1));
        }
    }

    private String getNameWithOpIdStats() {
        StringBuffer sb = new StringBuffer();
        sb.append(TezJsonParserUtils.renameReduceOutputOperator(this.name, this.vertex));
        if (this.operatorId != null) {
            sb.append(" [" + this.operatorId + "]");
        }
        if (!TezJsonParserUtils.OperatorNoStats.contains(this.name) && this.attrs.containsKey("Statistics:")) {
            sb.append(" (" + this.attrs.get("Statistics:") + ")");
        }
        this.attrs.remove("Statistics:");
        return sb.toString();
    }

    public void print(Printer printer, int indentFlag, boolean branchOfJoinOp) throws Exception {
        if (this.parser.printSet.contains(this)) {
            printer.println(TezJsonParser.prefixString(indentFlag) + " Please refer to the previous " + this.getNameWithOpIdStats());
            return;
        }
        this.parser.printSet.add(this);
        if (!branchOfJoinOp) {
            printer.println(TezJsonParser.prefixString(indentFlag) + this.getNameWithOpIdStats());
        } else {
            printer.println(TezJsonParser.prefixString(indentFlag, "<-") + this.getNameWithOpIdStats());
        }
        branchOfJoinOp = false;
        if (this.type == OpType.MAPJOIN || this.type == OpType.MERGEJOIN) {
            this.inlineJoinOp();
            branchOfJoinOp = true;
        }
        ArrayList<Connection> noninlined = new ArrayList<Connection>();
        if (this.parent == null && this.vertex != null) {
            for (Connection connection : this.vertex.parentConnections) {
                if (this.parser.isInline(connection.from)) continue;
                noninlined.add(connection);
            }
        }
        ++indentFlag;
        if (!this.attrs.isEmpty()) {
            printer.println(TezJsonParser.prefixString(indentFlag) + TezJsonParserUtils.attrsToString(this.attrs));
        }
        if (this.parser.inlineMap.containsKey(this)) {
            for (int index = 0; index < this.parser.inlineMap.get(this).size(); ++index) {
                Connection connection;
                connection = this.parser.inlineMap.get(this).get(index);
                connection.from.print(printer, indentFlag, connection.type, this.vertex);
            }
        }
        if (this.parent != null) {
            this.parent.print(printer, indentFlag, branchOfJoinOp);
        } else {
            for (int index = 0; index < noninlined.size(); ++index) {
                Vertex v = ((Connection)noninlined.get((int)index)).from;
                v.print(printer, indentFlag, ((Connection)noninlined.get((int)index)).type, this.vertex);
            }
        }
    }

    public static enum OpType {
        MAPJOIN,
        MERGEJOIN,
        RS,
        OTHERS;

    }
}

