/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.jsonexplain.tez;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.jsonexplain.tez.Connection;
import org.apache.hadoop.hive.common.jsonexplain.tez.Op;
import org.apache.hadoop.hive.common.jsonexplain.tez.Printer;
import org.apache.hadoop.hive.common.jsonexplain.tez.TezJsonParser;
import org.apache.hadoop.hive.common.jsonexplain.tez.TezJsonParserUtils;
import org.apache.hadoop.hive.common.jsonexplain.tez.Vertex;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Stage {
    String externalName;
    public final String internalName;
    public final TezJsonParser parser;
    public final List<Stage> parentStages = new ArrayList<Stage>();
    public final List<Stage> childStages = new ArrayList<Stage>();
    public final Map<String, Vertex> vertexs = new LinkedHashMap<String, Vertex>();
    public final Map<String, String> attrs = new TreeMap<String, String>();
    Map<Vertex, List<Connection>> tezStageDependency;
    Op op;

    public Stage(String name, TezJsonParser tezJsonParser) {
        this.internalName = name;
        this.externalName = name;
        this.parser = tezJsonParser;
    }

    public void addDependency(JSONObject object, Map<String, Stage> stages) throws JSONException {
        String names;
        if (object.has("DEPENDENT STAGES")) {
            names = object.getString("DEPENDENT STAGES");
            for (String name : names.split(",")) {
                Stage parent = stages.get(name.trim());
                this.parentStages.add(parent);
                parent.childStages.add(this);
            }
        }
        if (object.has("CONDITIONAL CHILD TASKS")) {
            names = object.getString("CONDITIONAL CHILD TASKS");
            this.externalName = this.internalName + "(CONDITIONAL CHILD TASKS: " + names + ")";
            for (String name : names.split(",")) {
                Stage child = stages.get(name.trim());
                child.externalName = child.internalName + "(CONDITIONAL)";
                child.parentStages.add(this);
                this.childStages.add(child);
            }
        }
    }

    public void extractVertex(JSONObject object) throws Exception {
        block17: {
            block16: {
                if (!object.has("Tez")) break block16;
                this.tezStageDependency = new TreeMap<Vertex, List<Connection>>();
                JSONObject tez = (JSONObject)object.get("Tez");
                JSONObject vertices = tez.getJSONObject("Vertices:");
                if (tez.has("Edges:")) {
                    JSONObject edges = tez.getJSONObject("Edges:");
                    for (String to : JSONObject.getNames(edges)) {
                        this.vertexs.put(to, new Vertex(to, vertices.getJSONObject(to), this.parser));
                    }
                    for (String to : JSONObject.getNames(edges)) {
                        Object o = edges.get(to);
                        Vertex v = this.vertexs.get(to);
                        if (o instanceof JSONObject) {
                            String type;
                            JSONObject obj = (JSONObject)o;
                            String parent = obj.getString("parent");
                            Vertex parentVertex = this.vertexs.get(parent);
                            if (parentVertex == null) {
                                parentVertex = new Vertex(parent, vertices.getJSONObject(parent), this.parser);
                                this.vertexs.put(parent, parentVertex);
                            }
                            if (!"CONTAINS".equals(type = obj.getString("type"))) {
                                v.addDependency(new Connection(type, parentVertex));
                                parentVertex.setType(type);
                                parentVertex.children.add(v);
                            } else {
                                parentVertex.addDependency(new Connection(type, v));
                                v.children.add(parentVertex);
                            }
                            this.tezStageDependency.put(v, Arrays.asList(new Connection(type, parentVertex)));
                            continue;
                        }
                        JSONArray from = (JSONArray)o;
                        ArrayList<Connection> list = new ArrayList<Connection>();
                        for (int index = 0; index < from.length(); ++index) {
                            String type;
                            JSONObject obj = from.getJSONObject(index);
                            String parent = obj.getString("parent");
                            Vertex parentVertex = this.vertexs.get(parent);
                            if (parentVertex == null) {
                                parentVertex = new Vertex(parent, vertices.getJSONObject(parent), this.parser);
                                this.vertexs.put(parent, parentVertex);
                            }
                            if (!"CONTAINS".equals(type = obj.getString("type"))) {
                                v.addDependency(new Connection(type, parentVertex));
                                parentVertex.setType(type);
                                parentVertex.children.add(v);
                            } else {
                                parentVertex.addDependency(new Connection(type, v));
                                v.children.add(parentVertex);
                            }
                            list.add(new Connection(type, parentVertex));
                        }
                        this.tezStageDependency.put(v, list);
                    }
                } else {
                    for (String vertexName : JSONObject.getNames(vertices)) {
                        this.vertexs.put(vertexName, new Vertex(vertexName, vertices.getJSONObject(vertexName), this.parser));
                    }
                }
                for (Vertex v : this.vertexs.values()) {
                    if (v.vertexType != Vertex.VertexType.MAP && v.vertexType != Vertex.VertexType.REDUCE) continue;
                    v.extractOpTree();
                    v.checkMultiReduceOperator();
                }
                break block17;
            }
            String[] names = JSONObject.getNames(object);
            if (names == null) break block17;
            for (String name : names) {
                if (name.contains("Operator")) {
                    this.op = this.extractOp(name, object.getJSONObject(name));
                    continue;
                }
                if (object.get(name).toString().isEmpty()) continue;
                this.attrs.put(name, object.get(name).toString());
            }
        }
    }

    Op extractOp(String opName, JSONObject opObj) throws Exception {
        TreeMap<String, String> attrs = new TreeMap<String, String>();
        Vertex v = null;
        if (opObj.length() > 0) {
            String[] names;
            for (String name : names = JSONObject.getNames(opObj)) {
                Object o = opObj.get(name);
                if (this.isPrintable(o) && !o.toString().isEmpty()) {
                    attrs.put(name, o.toString());
                    continue;
                }
                if (o instanceof JSONObject) {
                    JSONObject attrObj = (JSONObject)o;
                    if (attrObj.length() <= 0) continue;
                    if (name.equals("Processor Tree:")) {
                        JSONObject object = new JSONObject(new LinkedHashMap());
                        object.put(name, attrObj);
                        v = new Vertex(null, object, this.parser);
                        v.extractOpTree();
                        continue;
                    }
                    for (String attrName : JSONObject.getNames(attrObj)) {
                        if (attrObj.get(attrName).toString().isEmpty()) continue;
                        attrs.put(attrName, attrObj.get(attrName).toString());
                    }
                    continue;
                }
                throw new Exception("Unsupported object in " + this.internalName);
            }
        }
        Op op = new Op(opName, null, null, null, attrs, null, v, this.parser);
        if (v != null) {
            this.parser.addInline(op, new Connection(null, v));
        }
        return op;
    }

    private boolean isPrintable(Object val) {
        if (val instanceof Boolean || val instanceof String || val instanceof Integer || val instanceof Long || val instanceof Byte || val instanceof Float || val instanceof Double || val instanceof Path) {
            return true;
        }
        return val != null && val.getClass().isPrimitive();
    }

    public void print(Printer printer, int indentFlag) throws Exception {
        if (this.parser.printSet.contains(this)) {
            printer.println(TezJsonParser.prefixString(indentFlag) + " Please refer to the previous " + this.externalName);
            return;
        }
        this.parser.printSet.add(this);
        printer.println(TezJsonParser.prefixString(indentFlag) + this.externalName);
        ++indentFlag;
        for (Vertex candidate : this.vertexs.values()) {
            if (this.parser.isInline(candidate) || !candidate.children.isEmpty()) continue;
            candidate.print(printer, indentFlag, null, null);
        }
        if (!this.attrs.isEmpty()) {
            printer.println(TezJsonParser.prefixString(indentFlag) + TezJsonParserUtils.attrsToString(this.attrs));
        }
        if (this.op != null) {
            this.op.print(printer, indentFlag, false);
        }
        ++indentFlag;
        for (Stage stage : this.parentStages) {
            stage.print(printer, indentFlag);
        }
    }
}

