/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import com.clearspring.analytics.util.Preconditions;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javolution.testing.AssertionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkDynamicPartitionPruner {
    private static final Logger LOG = LoggerFactory.getLogger(SparkDynamicPartitionPruner.class);
    private final Map<String, List<SourceInfo>> sourceInfoMap = new LinkedHashMap<String, List<SourceInfo>>();
    private final BytesWritable writable = new BytesWritable();

    public void prune(MapWork work, JobConf jobConf) throws HiveException, SerDeException {
        this.sourceInfoMap.clear();
        this.initialize(work, jobConf);
        if (this.sourceInfoMap.size() == 0) {
            return;
        }
        this.processFiles(work, jobConf);
        this.prunePartitions(work);
    }

    public void initialize(MapWork work, JobConf jobConf) throws SerDeException {
        HashMap<String, SourceInfo> columnMap = new HashMap<String, SourceInfo>();
        Set<String> sourceWorkIds = work.getEventSourceTableDescMap().keySet();
        for (String id : sourceWorkIds) {
            List<TableDesc> tables = work.getEventSourceTableDescMap().get(id);
            List<String> columnNames = work.getEventSourceColumnNameMap().get(id);
            List<ExprNodeDesc> partKeyExprs = work.getEventSourcePartKeyExprMap().get(id);
            Iterator<String> cit = columnNames.iterator();
            Iterator<ExprNodeDesc> pit = partKeyExprs.iterator();
            for (TableDesc t : tables) {
                String columnName = cit.next();
                ExprNodeDesc partKeyExpr = pit.next();
                SourceInfo si = new SourceInfo(t, partKeyExpr, columnName, jobConf);
                if (!this.sourceInfoMap.containsKey(id)) {
                    this.sourceInfoMap.put(id, new ArrayList());
                }
                this.sourceInfoMap.get(id).add(si);
                if (columnMap.containsKey(columnName)) {
                    si.values = ((SourceInfo)columnMap.get((Object)columnName)).values;
                }
                columnMap.put(columnName, si);
            }
        }
    }

    private void processFiles(MapWork work, JobConf jobConf) throws HiveException {
        ObjectInputStream in = null;
        try {
            Path baseDir = work.getTmpPathForPartitionPruning();
            FileSystem fs = FileSystem.get((URI)baseDir.toUri(), (Configuration)jobConf);
            for (String name : this.sourceInfoMap.keySet()) {
                Path sourceDir = new Path(baseDir, name);
                for (FileStatus fstatus : fs.listStatus(sourceDir)) {
                    LOG.info("Start processing pruning file: " + fstatus.getPath());
                    in = new ObjectInputStream((InputStream)fs.open(fstatus.getPath()));
                    String columnName = in.readUTF();
                    SourceInfo info = null;
                    for (SourceInfo si : this.sourceInfoMap.get(name)) {
                        if (!columnName.equals(si.columnName)) continue;
                        info = si;
                        break;
                    }
                    Preconditions.checkArgument((info != null ? 1 : 0) != 0, (String)("AssertionError: no source info for the column: " + columnName), (Object[])new Object[0]);
                    while (in.available() > 0) {
                        this.writable.readFields((DataInput)in);
                        Object row = info.deserializer.deserialize((Writable)this.writable);
                        Object value = info.soi.getStructFieldData(row, info.field);
                        value = ObjectInspectorUtils.copyToStandardObject(value, info.fieldInspector);
                        info.values.add(value);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new HiveException("error while trying to close input stream", e);
            }
        }
    }

    private void prunePartitions(MapWork work) throws HiveException {
        for (String source : this.sourceInfoMap.keySet()) {
            for (SourceInfo info : this.sourceInfoMap.get(source)) {
                this.prunePartitionSingleSource(info, work);
            }
        }
    }

    private void prunePartitionSingleSource(SourceInfo info, MapWork work) throws HiveException {
        Set<Object> values = info.values;
        String columnName = info.columnName;
        AbstractPrimitiveWritableObjectInspector oi = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(TypeInfoFactory.getPrimitiveTypeInfo(info.fieldInspector.getTypeName()));
        ObjectInspectorConverters.Converter converter = ObjectInspectorConverters.getConverter((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)oi);
        StandardStructObjectInspector soi = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList(columnName), Collections.singletonList(oi));
        ExprNodeEvaluator eval = ExprNodeEvaluatorFactory.get(info.partKey);
        eval.initialize(soi);
        this.applyFilterToPartitions(work, converter, eval, columnName, values);
    }

    private void applyFilterToPartitions(MapWork work, ObjectInspectorConverters.Converter converter, ExprNodeEvaluator eval, String columnName, Set<Object> values) throws HiveException {
        Object[] row = new Object[1];
        Iterator<Path> it = work.getPathToPartitionInfo().keySet().iterator();
        while (it.hasNext()) {
            Path p = it.next();
            PartitionDesc desc = work.getPathToPartitionInfo().get(p);
            LinkedHashMap<String, String> spec = desc.getPartSpec();
            if (spec == null) {
                throw new AssertionException("No partition spec found in dynamic pruning");
            }
            String partValueString = (String)spec.get(columnName);
            if (partValueString == null) {
                throw new AssertionException("Could not find partition value for column: " + columnName);
            }
            Object partValue = converter.convert(partValueString);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Converted partition value: " + partValue + " original (" + partValueString + ")");
            }
            row[0] = partValue;
            partValue = eval.evaluate(row);
            if (LOG.isDebugEnabled()) {
                LOG.debug("part key expr applied: " + partValue);
            }
            if (values.contains(partValue)) continue;
            LOG.info("Pruning path: " + p);
            it.remove();
            work.removePathToAlias(p);
            work.getPartitionDescs().remove(desc);
        }
    }

    private static class SourceInfo {
        final ExprNodeDesc partKey;
        final Deserializer deserializer;
        final StructObjectInspector soi;
        final StructField field;
        final ObjectInspector fieldInspector;
        Set<Object> values = new HashSet<Object>();
        final String columnName;

        SourceInfo(TableDesc table, ExprNodeDesc partKey, String columnName, JobConf jobConf) throws SerDeException {
            this.partKey = partKey;
            this.columnName = columnName;
            this.deserializer = (Deserializer)ReflectionUtils.newInstance(table.getDeserializerClass(), null);
            this.deserializer.initialize((Configuration)jobConf, table.getProperties());
            ObjectInspector inspector = this.deserializer.getObjectInspector();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Type of obj insp: " + inspector.getTypeName());
            }
            this.soi = (StructObjectInspector)inspector;
            List<? extends StructField> fields = this.soi.getAllStructFieldRefs();
            assert (fields.size() > 1) : "expecting single field in input";
            this.field = fields.get(0);
            this.fieldInspector = ObjectInspectorUtils.getStandardObjectInspector(this.field.getFieldObjectInspector());
        }
    }
}

