/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorColumnOrderedMap {
    protected static final transient Logger LOG = LoggerFactory.getLogger(VectorColumnOrderedMap.class);
    protected String name;
    private TreeMap<Integer, Value> orderedTreeMap;

    public VectorColumnOrderedMap(String name) {
        this.name = name;
        this.orderedTreeMap = new TreeMap();
    }

    public void add(int orderedColumn, int valueColumn, TypeInfo typeInfo) {
        if (this.orderedTreeMap.containsKey(orderedColumn)) {
            throw new RuntimeException(this.name + " duplicate column " + orderedColumn + " in ordered column map " + this.orderedTreeMap.toString() + " when adding value column " + valueColumn + ", type into " + typeInfo.toString());
        }
        this.orderedTreeMap.put(orderedColumn, new Value(valueColumn, typeInfo));
    }

    public boolean orderedColumnsContain(int orderedColumn) {
        return this.orderedTreeMap.containsKey(orderedColumn);
    }

    public Mapping getMapping() {
        ArrayList<Integer> orderedColumns = new ArrayList<Integer>();
        ArrayList<Integer> valueColumns = new ArrayList<Integer>();
        ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>();
        for (Map.Entry<Integer, Value> entry : this.orderedTreeMap.entrySet()) {
            orderedColumns.add(entry.getKey());
            Value value = entry.getValue();
            valueColumns.add(value.valueColumn);
            typeInfos.add(value.typeInfo);
        }
        return new Mapping(ArrayUtils.toPrimitive(orderedColumns.toArray(new Integer[0])), ArrayUtils.toPrimitive(valueColumns.toArray(new Integer[0])), typeInfos.toArray(new TypeInfo[0]));
    }

    public class Mapping {
        private final int[] orderedColumns;
        private final int[] valueColumns;
        private final TypeInfo[] typeInfos;

        Mapping(int[] orderedColumns, int[] valueColumns, TypeInfo[] typeInfos) {
            this.orderedColumns = orderedColumns;
            this.valueColumns = valueColumns;
            this.typeInfos = typeInfos;
        }

        public int getCount() {
            return this.orderedColumns.length;
        }

        public int[] getOrderedColumns() {
            return this.orderedColumns;
        }

        public int[] getValueColumns() {
            return this.valueColumns;
        }

        public TypeInfo[] getTypeInfos() {
            return this.typeInfos;
        }
    }

    private class Value {
        int valueColumn;
        TypeInfo typeInfo;

        Value(int valueColumn, TypeInfo typeInfo) {
            this.valueColumn = valueColumn;
            this.typeInfo = typeInfo;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(value column: " + this.valueColumn);
            sb.append(", type info: " + this.typeInfo.toString() + ")");
            return sb.toString();
        }
    }
}

