/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataOutput;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.spark.SparkPartitionPruningSinkDesc;
import org.apache.hadoop.hive.ql.parse.spark.SparkPartitionPruningSinkOperator;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;

public class VectorSparkPartitionPruningSinkOperator
extends SparkPartitionPruningSinkOperator {
    private static final long serialVersionUID = 1L;
    private VectorizationContext vContext;
    protected transient boolean firstBatch;
    protected transient VectorExtractRow vectorExtractRow;
    protected transient Object[] singleRow;

    public VectorSparkPartitionPruningSinkOperator(CompilationOpContext ctx, VectorizationContext context, OperatorDesc conf) {
        this(ctx);
        this.conf = (SparkPartitionPruningSinkDesc)conf;
        this.vContext = context;
    }

    @VisibleForTesting
    public VectorSparkPartitionPruningSinkOperator() {
    }

    public VectorSparkPartitionPruningSinkOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    public void initializeOp(Configuration hconf) throws HiveException {
        this.inputObjInspectors[0] = VectorizedBatchUtil.convertToStandardStructObjectInspector((StructObjectInspector)this.inputObjInspectors[0]);
        super.initializeOp(hconf);
        this.firstBatch = true;
    }

    @Override
    public void process(Object data, int tag) throws HiveException {
        VectorizedRowBatch batch = (VectorizedRowBatch)data;
        if (this.firstBatch) {
            this.vectorExtractRow = new VectorExtractRow();
            this.vectorExtractRow.init((StructObjectInspector)this.inputObjInspectors[0], this.vContext.getProjectedColumns());
            this.singleRow = new Object[this.vectorExtractRow.getCount()];
            this.firstBatch = false;
        }
        ObjectInspector rowInspector = this.inputObjInspectors[0];
        try {
            for (int logical = 0; logical < batch.size; ++logical) {
                int batchIndex = batch.selectedInUse ? batch.selected[logical] : logical;
                this.vectorExtractRow.extractRow(batch, batchIndex, this.singleRow);
                Writable writableRow = this.serializer.serialize(this.singleRow, rowInspector);
                writableRow.write((DataOutput)this.buffer);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

