/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.LongWritable;

@Description(name="corr", value="_FUNC_(y,x) - Returns the Pearson coefficient of correlation\nbetween a set of number pairs", extended="The function takes as arguments any pair of numeric types and returns a double.\nAny pair with a NULL is ignored.\nIf applied to an empty set: NULL is returned.\nIf N*SUM(x*x) = SUM(x)*SUM(x): NULL is returned.\nIf N*SUM(y*y) = SUM(y)*SUM(y): NULL is returned.\nOtherwise, it computes the following:\n   COVAR_POP(x,y)/(STDDEV_POP(x)*STDDEV_POP(y))\nwhere neither x nor y is null,\nCOVAR_POP is the population covariance,\nand STDDEV_POP is the population standard deviation.")
public class GenericUDAFCorrelation
extends AbstractGenericUDAFResolver {
    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 2) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly two arguments are expected.");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
        }
        if (parameters[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(1, "Only primitive type arguments are accepted but " + parameters[1].getTypeName() + " is passed.");
        }
        switch (((PrimitiveTypeInfo)parameters[0]).getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case TIMESTAMP: 
            case DECIMAL: {
                switch (((PrimitiveTypeInfo)parameters[1]).getPrimitiveCategory()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case TIMESTAMP: 
                    case DECIMAL: {
                        return new GenericUDAFCorrelationEvaluator();
                    }
                }
                throw new UDFArgumentTypeException(1, "Only numeric type arguments are accepted but " + parameters[1].getTypeName() + " is passed.");
            }
        }
        throw new UDFArgumentTypeException(0, "Only numeric type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
    }

    public static class GenericUDAFCorrelationEvaluator
    extends GenericUDAFEvaluator {
        private PrimitiveObjectInspector xInputOI;
        private PrimitiveObjectInspector yInputOI;
        private transient StructObjectInspector soi;
        private transient StructField countField;
        private transient StructField xavgField;
        private transient StructField yavgField;
        private transient StructField xvarField;
        private transient StructField yvarField;
        private transient StructField covarField;
        private LongObjectInspector countFieldOI;
        private DoubleObjectInspector xavgFieldOI;
        private DoubleObjectInspector yavgFieldOI;
        private DoubleObjectInspector xvarFieldOI;
        private DoubleObjectInspector yvarFieldOI;
        private DoubleObjectInspector covarFieldOI;
        private Object[] partialResult;
        private DoubleWritable result;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                assert (parameters.length == 2);
                this.yInputOI = (PrimitiveObjectInspector)parameters[0];
                this.xInputOI = (PrimitiveObjectInspector)parameters[1];
            } else {
                assert (parameters.length == 1);
                this.soi = (StructObjectInspector)parameters[0];
                this.countField = this.soi.getStructFieldRef("count");
                this.xavgField = this.soi.getStructFieldRef("xavg");
                this.yavgField = this.soi.getStructFieldRef("yavg");
                this.xvarField = this.soi.getStructFieldRef("xvar");
                this.yvarField = this.soi.getStructFieldRef("yvar");
                this.covarField = this.soi.getStructFieldRef("covar");
                this.countFieldOI = (LongObjectInspector)this.countField.getFieldObjectInspector();
                this.xavgFieldOI = (DoubleObjectInspector)this.xavgField.getFieldObjectInspector();
                this.yavgFieldOI = (DoubleObjectInspector)this.yavgField.getFieldObjectInspector();
                this.xvarFieldOI = (DoubleObjectInspector)this.xvarField.getFieldObjectInspector();
                this.yvarFieldOI = (DoubleObjectInspector)this.yvarField.getFieldObjectInspector();
                this.covarFieldOI = (DoubleObjectInspector)this.covarField.getFieldObjectInspector();
            }
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
                foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
                ArrayList<String> fname = new ArrayList<String>();
                fname.add("count");
                fname.add("xavg");
                fname.add("yavg");
                fname.add("xvar");
                fname.add("yvar");
                fname.add("covar");
                this.partialResult = new Object[6];
                this.partialResult[0] = new LongWritable(0L);
                this.partialResult[1] = new DoubleWritable(0.0);
                this.partialResult[2] = new DoubleWritable(0.0);
                this.partialResult[3] = new DoubleWritable(0.0);
                this.partialResult[4] = new DoubleWritable(0.0);
                this.partialResult[5] = new DoubleWritable(0.0);
                return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
            }
            this.setResult(new DoubleWritable(0.0));
            return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            StdAgg result = new StdAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StdAgg myagg = (StdAgg)agg;
            myagg.count = 0L;
            myagg.xavg = 0.0;
            myagg.yavg = 0.0;
            myagg.xvar = 0.0;
            myagg.yvar = 0.0;
            myagg.covar = 0.0;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            assert (parameters.length == 2);
            Object py = parameters[0];
            Object px = parameters[1];
            if (px != null && py != null) {
                StdAgg myagg = (StdAgg)agg;
                double vx = PrimitiveObjectInspectorUtils.getDouble(px, this.xInputOI);
                double vy = PrimitiveObjectInspectorUtils.getDouble(py, this.yInputOI);
                double deltaX = vx - myagg.xavg;
                double deltaY = vy - myagg.yavg;
                ++myagg.count;
                myagg.xavg += deltaX / (double)myagg.count;
                myagg.yavg += deltaY / (double)myagg.count;
                if (myagg.count > 1L) {
                    myagg.covar += deltaX * (vy - myagg.yavg);
                    myagg.xvar += deltaX * (vx - myagg.xavg);
                    myagg.yvar += deltaY * (vy - myagg.yavg);
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StdAgg myagg = (StdAgg)agg;
            ((LongWritable)this.partialResult[0]).set(myagg.count);
            ((DoubleWritable)((Object)this.partialResult[1])).set(myagg.xavg);
            ((DoubleWritable)((Object)this.partialResult[2])).set(myagg.yavg);
            ((DoubleWritable)((Object)this.partialResult[3])).set(myagg.xvar);
            ((DoubleWritable)((Object)this.partialResult[4])).set(myagg.yvar);
            ((DoubleWritable)((Object)this.partialResult[5])).set(myagg.covar);
            return this.partialResult;
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                StdAgg myagg = (StdAgg)agg;
                Object partialCount = this.soi.getStructFieldData(partial, this.countField);
                Object partialXAvg = this.soi.getStructFieldData(partial, this.xavgField);
                Object partialYAvg = this.soi.getStructFieldData(partial, this.yavgField);
                Object partialXVar = this.soi.getStructFieldData(partial, this.xvarField);
                Object partialYVar = this.soi.getStructFieldData(partial, this.yvarField);
                Object partialCovar = this.soi.getStructFieldData(partial, this.covarField);
                long nA = myagg.count;
                long nB = this.countFieldOI.get(partialCount);
                if (nA == 0L) {
                    myagg.count = this.countFieldOI.get(partialCount);
                    myagg.xavg = this.xavgFieldOI.get(partialXAvg);
                    myagg.yavg = this.yavgFieldOI.get(partialYAvg);
                    myagg.xvar = this.xvarFieldOI.get(partialXVar);
                    myagg.yvar = this.yvarFieldOI.get(partialYVar);
                    myagg.covar = this.covarFieldOI.get(partialCovar);
                }
                if (nA != 0L && nB != 0L) {
                    double xavgA = myagg.xavg;
                    double yavgA = myagg.yavg;
                    double xavgB = this.xavgFieldOI.get(partialXAvg);
                    double yavgB = this.yavgFieldOI.get(partialYAvg);
                    double xvarB = this.xvarFieldOI.get(partialXVar);
                    double yvarB = this.yvarFieldOI.get(partialYVar);
                    double covarB = this.covarFieldOI.get(partialCovar);
                    myagg.count += nB;
                    myagg.xavg = (xavgA * (double)nA + xavgB * (double)nB) / (double)myagg.count;
                    myagg.yavg = (yavgA * (double)nA + yavgB * (double)nB) / (double)myagg.count;
                    myagg.xvar += xvarB + (xavgA - xavgB) * (xavgA - xavgB) * (double)nA * (double)nB / (double)myagg.count;
                    myagg.yvar += yvarB + (yavgA - yavgB) * (yavgA - yavgB) * (double)nA * (double)nB / (double)myagg.count;
                    myagg.covar += covarB + (xavgA - xavgB) * (yavgA - yavgB) * ((double)(nA * nB) / (double)myagg.count);
                }
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StdAgg myagg = (StdAgg)agg;
            if (myagg.count == 0L || myagg.xvar == 0.0 || myagg.yvar == 0.0) {
                return null;
            }
            DoubleWritable result = this.getResult();
            result.set(myagg.covar / Math.sqrt(myagg.yvar) / Math.sqrt(myagg.xvar));
            return result;
        }

        public void setResult(DoubleWritable result) {
            this.result = result;
        }

        public DoubleWritable getResult() {
            return this.result;
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        static class StdAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            long count;
            double xavg;
            double yavg;
            double xvar;
            double yvar;
            double covar;

            StdAgg() {
            }

            @Override
            public int estimate() {
                return 48;
            }
        }
    }
}

