/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.linq4j.tree.Visitor;

public class NewArrayExpression
extends Expression {
    public final int dimension;
    public final Expression bound;
    public final List<Expression> expressions;
    private int hash;

    public NewArrayExpression(Type type, int dimension, Expression bound, List<Expression> expressions) {
        super(ExpressionType.NewArrayInit, Types.arrayType(type, dimension));
        this.dimension = dimension;
        this.bound = bound;
        this.expressions = expressions;
    }

    @Override
    public Expression accept(Visitor visitor) {
        visitor = visitor.preVisit(this);
        List<Expression> expressions = this.expressions == null ? null : Expressions.acceptExpressions(this.expressions, visitor);
        Expression bound = Expressions.accept(this.bound, visitor);
        return visitor.visit(this, this.dimension, bound, expressions);
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        writer.append("new ").append(Types.getComponentTypeN(this.type));
        for (int i = 0; i < this.dimension; ++i) {
            if (i == 0 && this.bound != null) {
                writer.append('[').append(this.bound).append(']');
                continue;
            }
            writer.append("[]");
        }
        if (this.expressions != null) {
            writer.list(" {\n", ",\n", "}", this.expressions);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NewArrayExpression that = (NewArrayExpression)o;
        if (this.dimension != that.dimension) {
            return false;
        }
        if (this.bound != null ? !this.bound.equals(that.bound) : that.bound != null) {
            return false;
        }
        return !(this.expressions != null ? !this.expressions.equals(that.expressions) : that.expressions != null);
    }

    @Override
    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            result = Objects.hash(new Object[]{this.nodeType, this.type, this.dimension, this.bound, this.expressions});
            if (result == 0) {
                result = 1;
            }
            this.hash = result;
        }
        return result;
    }
}

