/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.hive.com.google.common.collect.ImmutableList;

public class ChainedSqlOperatorTable
implements SqlOperatorTable {
    protected final List<SqlOperatorTable> tableList;

    public ChainedSqlOperatorTable(List<SqlOperatorTable> tableList) {
        this.tableList = ImmutableList.copyOf(tableList);
    }

    public static SqlOperatorTable of(SqlOperatorTable ... tables) {
        return new ChainedSqlOperatorTable(ImmutableList.copyOf(tables));
    }

    public void add(SqlOperatorTable table) {
        if (!this.tableList.contains(table)) {
            this.tableList.add(table);
        }
    }

    @Override
    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList) {
        for (SqlOperatorTable table : this.tableList) {
            table.lookupOperatorOverloads(opName, category, syntax, operatorList);
        }
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        ArrayList<SqlOperator> list = new ArrayList<SqlOperator>();
        for (SqlOperatorTable table : this.tableList) {
            list.addAll(table.getOperatorList());
        }
        return list;
    }
}

