/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashMap;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorMapJoinOuterStringOperator
extends VectorMapJoinOuterGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorMapJoinOuterStringOperator.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(CLASS_NAME);
    private transient VectorMapJoinBytesHashMap hashMap;
    private transient int singleJoinColumn;

    @Override
    protected String getLoggingPrefix() {
        return super.getLoggingPrefix(CLASS_NAME);
    }

    protected VectorMapJoinOuterStringOperator() {
    }

    public VectorMapJoinOuterStringOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorMapJoinOuterStringOperator(CompilationOpContext ctx, VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(ctx, vContext, conf);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            VectorizedRowBatch batch = (VectorizedRowBatch)row;
            this.alias = (byte)tag;
            if (this.needCommonSetup) {
                this.commonSetup(batch);
                this.singleJoinColumn = this.bigTableKeyColumnMap[0];
                this.needCommonSetup = false;
            }
            if (this.needHashTableSetup) {
                this.hashMap = (VectorMapJoinBytesHashMap)this.vectorMapJoinHashTable;
                this.needHashTableSetup = false;
            }
            ++this.batchCounter;
            int inputLogicalSize = batch.size;
            if (inputLogicalSize == 0) {
                if (this.isLogDebugEnabled) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " empty");
                }
                return;
            }
            this.outerPerBatchSetup(batch);
            boolean inputSelectedInUse = batch.selectedInUse;
            if (inputSelectedInUse) {
                System.arraycopy(batch.selected, 0, this.inputSelected, 0, inputLogicalSize);
            }
            boolean someRowsFilteredOut = false;
            if (this.bigTableFilterExpressions.length > 0) {
                for (VectorExpression ve : this.bigTableFilterExpressions) {
                    ve.evaluate(batch);
                }
                boolean bl = someRowsFilteredOut = batch.size != inputLogicalSize;
                if (this.isLogDebugEnabled && batch.selectedInUse) {
                    if (inputSelectedInUse) {
                        LOG.debug(CLASS_NAME + " inputSelected " + VectorMapJoinOuterStringOperator.intArrayToRangesString(this.inputSelected, inputLogicalSize) + " filtered batch.selected " + VectorMapJoinOuterStringOperator.intArrayToRangesString(batch.selected, batch.size));
                    } else {
                        LOG.debug(CLASS_NAME + " inputLogicalSize " + inputLogicalSize + " filtered batch.selected " + VectorMapJoinOuterStringOperator.intArrayToRangesString(batch.selected, batch.size));
                    }
                }
            }
            if (this.bigTableKeyExpressions != null) {
                for (VectorExpression ve : this.bigTableKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            BytesColumnVector joinColVector = (BytesColumnVector)batch.cols[this.singleJoinColumn];
            byte[][] vector = joinColVector.vector;
            int[] start = joinColVector.start;
            int[] length = joinColVector.length;
            boolean allKeyInputColumnsRepeating = joinColVector.isRepeating;
            if (allKeyInputColumnsRepeating) {
                JoinUtil.JoinResult joinResult;
                if (batch.size == 0) {
                    joinResult = JoinUtil.JoinResult.NOMATCH;
                } else if (!joinColVector.noNulls && joinColVector.isNull[0]) {
                    joinResult = JoinUtil.JoinResult.NOMATCH;
                } else {
                    byte[] keyBytes = vector[0];
                    int keyStart = start[0];
                    int keyLength = length[0];
                    joinResult = this.hashMap.lookup(keyBytes, keyStart, keyLength, this.hashMapResults[0]);
                }
                if (this.isLogDebugEnabled) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " repeated joinResult " + joinResult.name());
                }
                this.finishOuterRepeated(batch, joinResult, this.hashMapResults[0], someRowsFilteredOut, inputSelectedInUse, inputLogicalSize);
            } else {
                if (this.isLogDebugEnabled) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " non-repeated");
                }
                int[] selected = batch.selected;
                boolean selectedInUse = batch.selectedInUse;
                int hashMapResultCount = 0;
                int allMatchCount = 0;
                int equalKeySeriesCount = 0;
                int spillCount = 0;
                boolean atLeastOneNonMatch = someRowsFilteredOut;
                int saveKeyBatchIndex = -1;
                boolean haveSaveKey = false;
                JoinUtil.JoinResult saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                block22: for (int logical = 0; logical < batch.size; ++logical) {
                    boolean isNull;
                    int batchIndex = selectedInUse ? selected[logical] : logical;
                    boolean bl = isNull = !joinColVector.noNulls && joinColVector.isNull[batchIndex];
                    if (isNull) {
                        atLeastOneNonMatch = true;
                        continue;
                    }
                    if (!haveSaveKey || !StringExpr.equal(vector[saveKeyBatchIndex], start[saveKeyBatchIndex], length[saveKeyBatchIndex], vector[batchIndex], start[batchIndex], length[batchIndex])) {
                        if (haveSaveKey) {
                            switch (saveJoinResult) {
                                case MATCH: {
                                    ++hashMapResultCount;
                                    ++equalKeySeriesCount;
                                    break;
                                }
                                case SPILL: {
                                    ++hashMapResultCount;
                                    break;
                                }
                            }
                        }
                        haveSaveKey = true;
                        saveKeyBatchIndex = batchIndex;
                        byte[] keyBytes = vector[batchIndex];
                        int keyStart = start[batchIndex];
                        int keyLength = length[batchIndex];
                        saveJoinResult = this.hashMap.lookup(keyBytes, keyStart, keyLength, this.hashMapResults[hashMapResultCount]);
                        switch (saveJoinResult) {
                            case MATCH: {
                                this.equalKeySeriesHashMapResultIndices[equalKeySeriesCount] = hashMapResultCount;
                                this.equalKeySeriesAllMatchIndices[equalKeySeriesCount] = allMatchCount;
                                this.equalKeySeriesIsSingleValue[equalKeySeriesCount] = this.hashMapResults[hashMapResultCount].isSingleRow();
                                this.equalKeySeriesDuplicateCounts[equalKeySeriesCount] = 1;
                                this.allMatchs[allMatchCount++] = batchIndex;
                                break;
                            }
                            case SPILL: {
                                this.spills[spillCount] = batchIndex;
                                this.spillHashMapResultIndices[spillCount] = hashMapResultCount;
                                ++spillCount;
                                break;
                            }
                            case NOMATCH: {
                                atLeastOneNonMatch = true;
                            }
                        }
                        continue;
                    }
                    switch (saveJoinResult) {
                        case MATCH: {
                            int n = equalKeySeriesCount;
                            this.equalKeySeriesDuplicateCounts[n] = this.equalKeySeriesDuplicateCounts[n] + 1;
                            this.allMatchs[allMatchCount++] = batchIndex;
                            continue block22;
                        }
                        case SPILL: {
                            this.spills[spillCount] = batchIndex;
                            this.spillHashMapResultIndices[spillCount] = hashMapResultCount;
                            ++spillCount;
                            continue block22;
                        }
                    }
                }
                if (haveSaveKey) {
                    switch (saveJoinResult) {
                        case MATCH: {
                            ++hashMapResultCount;
                            ++equalKeySeriesCount;
                            break;
                        }
                        case SPILL: {
                            ++hashMapResultCount;
                            break;
                        }
                    }
                }
                if (this.isLogDebugEnabled) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " allMatchs " + VectorMapJoinOuterStringOperator.intArrayToRangesString(this.allMatchs, allMatchCount) + " equalKeySeriesHashMapResultIndices " + VectorMapJoinOuterStringOperator.intArrayToRangesString(this.equalKeySeriesHashMapResultIndices, equalKeySeriesCount) + " equalKeySeriesAllMatchIndices " + VectorMapJoinOuterStringOperator.intArrayToRangesString(this.equalKeySeriesAllMatchIndices, equalKeySeriesCount) + " equalKeySeriesIsSingleValue " + Arrays.toString(Arrays.copyOfRange(this.equalKeySeriesIsSingleValue, 0, equalKeySeriesCount)) + " equalKeySeriesDuplicateCounts " + Arrays.toString(Arrays.copyOfRange(this.equalKeySeriesDuplicateCounts, 0, equalKeySeriesCount)) + " atLeastOneNonMatch " + atLeastOneNonMatch + " inputSelectedInUse " + inputSelectedInUse + " inputLogicalSize " + inputLogicalSize + " spills " + VectorMapJoinOuterStringOperator.intArrayToRangesString(this.spills, spillCount) + " spillHashMapResultIndices " + VectorMapJoinOuterStringOperator.intArrayToRangesString(this.spillHashMapResultIndices, spillCount) + " hashMapResults " + Arrays.toString(Arrays.copyOfRange(this.hashMapResults, 0, hashMapResultCount)));
                }
                this.finishOuter(batch, allMatchCount, equalKeySeriesCount, atLeastOneNonMatch, inputSelectedInUse, inputLogicalSize, spillCount, hashMapResultCount);
            }
            if (batch.size > 0) {
                this.forwardBigTableBatch(batch);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }
}

