/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hive.com.google.common.collect.ImmutableList;

public class HiveProjectSortTransposeRule
extends RelOptRule {
    public static final HiveProjectSortTransposeRule INSTANCE = new HiveProjectSortTransposeRule();

    private HiveProjectSortTransposeRule() {
        super(HiveProjectSortTransposeRule.operand(HiveProject.class, HiveProjectSortTransposeRule.operand(HiveSortLimit.class, HiveProjectSortTransposeRule.any()), new RelOptRuleOperand[0]));
    }

    protected HiveProjectSortTransposeRule(RelOptRuleOperand operand) {
        super(operand);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        HiveProject project = (HiveProject)call.rel(0);
        HiveSortLimit sort = (HiveSortLimit)call.rel(1);
        Mapping map = RelOptUtil.permutation(project.getProjects(), project.getInput().getRowType()).inverse();
        for (RelFieldCollation fc : sort.getCollation().getFieldCollations()) {
            if (map.getTarget(fc.getFieldIndex()) >= 0) continue;
            return;
        }
        RelCollation newCollation = RelCollationTraitDef.INSTANCE.canonize(RexUtil.apply((Mappings.TargetMapping)map, sort.getCollation()));
        RelNode newProject = project.copy(sort.getInput().getTraitSet(), ImmutableList.of(sort.getInput()));
        HiveSortLimit newSort = sort.copy(newProject.getTraitSet(), newProject, newCollation, sort.offset, sort.fetch);
        call.transformTo(newSort);
    }
}

