/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.math.BigDecimal;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;

public class HiveSortMergeRule
extends RelOptRule {
    public static final HiveSortMergeRule INSTANCE = new HiveSortMergeRule();

    private HiveSortMergeRule() {
        super(HiveSortMergeRule.operand(HiveSortLimit.class, HiveSortMergeRule.operand(HiveSortLimit.class, HiveSortMergeRule.any()), new RelOptRuleOperand[0]));
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        HiveSortLimit topSortLimit = (HiveSortLimit)call.rel(0);
        HiveSortLimit bottomSortLimit = (HiveSortLimit)call.rel(1);
        if (!HiveCalciteUtil.pureLimitRelNode(topSortLimit)) {
            return false;
        }
        return !topSortLimit.isRuleCreated() || bottomSortLimit.isRuleCreated() || HiveCalciteUtil.limitRelNode(bottomSortLimit);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RexNode newLimit;
        RexNode newOffset;
        HiveSortLimit topSortLimit = (HiveSortLimit)call.rel(0);
        HiveSortLimit bottomSortLimit = (HiveSortLimit)call.rel(1);
        if (HiveCalciteUtil.limitRelNode(bottomSortLimit)) {
            RexBuilder rexBuilder = topSortLimit.getCluster().getRexBuilder();
            int topOffset = topSortLimit.offset == null ? 0 : RexLiteral.intValue(topSortLimit.offset);
            int topLimit = RexLiteral.intValue(topSortLimit.fetch);
            int bottomOffset = bottomSortLimit.offset == null ? 0 : RexLiteral.intValue(bottomSortLimit.offset);
            int bottomLimit = RexLiteral.intValue(bottomSortLimit.fetch);
            if (topOffset + topLimit <= bottomLimit) {
                newOffset = bottomOffset + topOffset == 0 ? null : rexBuilder.makeExactLiteral(BigDecimal.valueOf(bottomOffset + topOffset));
                newLimit = topSortLimit.fetch;
            } else if (topOffset < bottomLimit) {
                newOffset = bottomOffset + topOffset == 0 ? null : rexBuilder.makeExactLiteral(BigDecimal.valueOf(bottomOffset + topOffset));
                newLimit = rexBuilder.makeExactLiteral(BigDecimal.valueOf(bottomLimit - topOffset));
            } else {
                newOffset = null;
                newLimit = rexBuilder.makeExactLiteral(BigDecimal.valueOf(0L));
            }
        } else {
            newOffset = topSortLimit.offset;
            newLimit = topSortLimit.fetch;
        }
        HiveSortLimit newSort = bottomSortLimit.copy(bottomSortLimit.getTraitSet(), bottomSortLimit.getInput(), bottomSortLimit.collation, newOffset, newLimit);
        call.transformTo(newSort);
    }
}

