/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client;

import java.io.Serializable;
import org.apache.hive.com.google.common.base.Throwables;
import org.apache.hive.spark.client.Job;
import org.apache.hive.spark.client.metrics.Metrics;
import org.apache.hive.spark.client.rpc.RpcDispatcher;
import org.apache.hive.spark.counter.SparkCounters;

abstract class BaseProtocol
extends RpcDispatcher {
    BaseProtocol() {
    }

    protected static class SyncJobRequest<T extends Serializable>
    implements Serializable {
        final Job<T> job;

        SyncJobRequest(Job<T> job) {
            this.job = job;
        }

        SyncJobRequest() {
            this(null);
        }
    }

    protected static class JobSubmitted
    implements Serializable {
        final String clientJobId;
        final int sparkJobId;

        JobSubmitted(String clientJobId, int sparkJobId) {
            this.clientJobId = clientJobId;
            this.sparkJobId = sparkJobId;
        }

        JobSubmitted() {
            this(null, -1);
        }
    }

    protected static class JobStarted
    implements Serializable {
        final String id;

        JobStarted(String id) {
            this.id = id;
        }

        JobStarted() {
            this(null);
        }
    }

    protected static class JobResult<T extends Serializable>
    implements Serializable {
        final String id;
        final T result;
        final String error;
        final SparkCounters sparkCounters;

        JobResult(String id, T result, Throwable error, SparkCounters sparkCounters) {
            this.id = id;
            this.result = result;
            this.error = error != null ? Throwables.getStackTraceAsString(error) : null;
            this.sparkCounters = sparkCounters;
        }

        JobResult() {
            this(null, null, null, null);
        }
    }

    protected static class JobRequest<T extends Serializable>
    implements Serializable {
        final String id;
        final Job<T> job;

        JobRequest(String id, Job<T> job) {
            this.id = id;
            this.job = job;
        }

        JobRequest() {
            this(null, null);
        }
    }

    protected static class JobMetrics
    implements Serializable {
        final String jobId;
        final int sparkJobId;
        final int stageId;
        final long taskId;
        final Metrics metrics;

        JobMetrics(String jobId, int sparkJobId, int stageId, long taskId, Metrics metrics) {
            this.jobId = jobId;
            this.sparkJobId = sparkJobId;
            this.stageId = stageId;
            this.taskId = taskId;
            this.metrics = metrics;
        }

        JobMetrics() {
            this(null, -1, -1, -1L, null);
        }
    }

    protected static class Error
    implements Serializable {
        final String cause;

        Error(Throwable cause) {
            this.cause = cause == null ? "" : Throwables.getStackTraceAsString(cause);
        }

        Error() {
            this(null);
        }
    }

    protected static class EndSession
    implements Serializable {
        protected EndSession() {
        }
    }

    protected static class CancelJob
    implements Serializable {
        final String id;

        CancelJob(String id) {
            this.id = id;
        }

        CancelJob() {
            this(null);
        }
    }
}

