/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperHiveHelper {
    public static final Logger LOG = LoggerFactory.getLogger(ZooKeeperHiveHelper.class.getName());
    public static final String ZOOKEEPER_PATH_SEPARATOR = "/";

    public static String getQuorumServers(HiveConf conf) {
        String[] hosts = conf.getVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_QUORUM).split(",");
        String port = conf.getVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_CLIENT_PORT);
        StringBuilder quorum = new StringBuilder();
        for (int i = 0; i < hosts.length; ++i) {
            quorum.append(hosts[i].trim());
            if (!hosts[i].contains(":")) {
                quorum.append(":");
                quorum.append(port);
            }
            if (i == hosts.length - 1) continue;
            quorum.append(",");
        }
        return quorum.toString();
    }

    public static class DummyWatcher
    implements Watcher {
        public void process(WatchedEvent event) {
        }
    }
}

