/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.impl.InputSpec;
import org.apache.tez.runtime.api.impl.OutputSpec;
import org.apache.tez.runtime.api.impl.TaskSpec;

public class TaskSpecBuilder {
    public TaskSpec constructTaskSpec(DAG dag, String vertexName, int numSplits, ApplicationId appId, int index) {
        Vertex vertex = dag.getVertex(vertexName);
        ProcessorDescriptor processorDescriptor = vertex.getProcessorDescriptor();
        List inputs = vertex.getInputs();
        List outputs = vertex.getOutputs();
        Preconditions.checkState(inputs.size() == 1);
        Preconditions.checkState(outputs.size() == 1);
        ArrayList<InputSpec> inputSpecs = new ArrayList<InputSpec>();
        for (Object input : inputs) {
            InputSpec inputSpec = new InputSpec(input.getName(), (InputDescriptor)input.getIODescriptor(), 1);
            inputSpecs.add(inputSpec);
        }
        ArrayList<OutputSpec> outputSpecs = new ArrayList<OutputSpec>();
        for (RootInputLeafOutput output : outputs) {
            OutputSpec outputSpec = new OutputSpec(output.getName(), (OutputDescriptor)output.getIODescriptor(), 1);
            outputSpecs.add(outputSpec);
        }
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)0);
        TezVertexID vertexId = TezVertexID.getInstance((TezDAGID)dagId, (int)0);
        TezTaskID taskId = TezTaskID.getInstance((TezVertexID)vertexId, (int)index);
        TezTaskAttemptID taskAttemptId = TezTaskAttemptID.getInstance((TezTaskID)taskId, (int)0);
        return new TaskSpec(taskAttemptId, dag.getName(), vertexName, numSplits, processorDescriptor, inputSpecs, outputSpecs, null);
    }

    public static List<RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor>> getVertexInputs(Vertex wx) {
        return wx.getInputs();
    }
}

