/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.io.BytesWritable;

public class HBaseScanRange
implements Serializable {
    private byte[] startRow;
    private byte[] stopRow;
    private List<FilterDesc> filterDescs = new ArrayList<FilterDesc>();

    public byte[] getStartRow() {
        return this.startRow;
    }

    public void setStartRow(byte[] startRow) {
        this.startRow = startRow;
    }

    public byte[] getStopRow() {
        return this.stopRow;
    }

    public void setStopRow(byte[] stopRow) {
        this.stopRow = stopRow;
    }

    public void addFilter(Filter filter) throws Exception {
        Class<?> clazz = filter.getClass();
        clazz.getMethod("parseFrom", byte[].class);
        this.filterDescs.add(new FilterDesc(clazz.getName(), filter.toByteArray()));
    }

    public void setup(Scan scan, Configuration conf) throws Exception {
        if (this.startRow != null) {
            scan.setStartRow(this.startRow);
        }
        if (this.stopRow != null) {
            scan.setStopRow(this.stopRow);
        }
        if (this.filterDescs.isEmpty()) {
            return;
        }
        if (this.filterDescs.size() == 1) {
            scan.setFilter(this.filterDescs.get(0).toFilter(conf));
            return;
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (FilterDesc filter : this.filterDescs) {
            filters.add(filter.toFilter(conf));
        }
        scan.setFilter((Filter)new FilterList(filters));
    }

    public String toString() {
        return (this.startRow == null ? "" : new BytesWritable(this.startRow).toString()) + " ~ " + (this.stopRow == null ? "" : new BytesWritable(this.stopRow).toString());
    }

    private static class FilterDesc
    implements Serializable {
        private String className;
        private byte[] binary;

        public FilterDesc(String className, byte[] binary) {
            this.className = className;
            this.binary = binary;
        }

        public Filter toFilter(Configuration conf) throws Exception {
            return (Filter)this.getFactoryMethod(this.className, conf).invoke(null, new Object[]{this.binary});
        }

        private Method getFactoryMethod(String className, Configuration conf) throws Exception {
            Class clazz = conf.getClassByName(className);
            return clazz.getMethod("parseFrom", byte[].class);
        }
    }
}

