/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.objects;

import java.io.EOFException;
import java.io.IOException;
import org.apache.hive.hplsql.File;
import org.apache.hive.hplsql.objects.HplClass;
import org.apache.hive.hplsql.objects.HplObject;
import org.apache.hive.hplsql.objects.UtlFileClass;

public class UtlFile
implements HplObject {
    private final UtlFileClass hplClass;

    public UtlFile(UtlFileClass hplClass) {
        this.hplClass = hplClass;
    }

    @Override
    public HplClass hplClass() {
        return this.hplClass;
    }

    public File fileOpen(String dir, String name, boolean write, boolean overwrite) {
        File file = new File();
        if (write) {
            file.create(dir, name, overwrite);
        } else {
            file.open(dir, name);
        }
        return file;
    }

    public void fileClose(File file) {
        file.close();
    }

    public String getLine(File file) {
        StringBuilder out;
        block3: {
            out = new StringBuilder();
            try {
                char c;
                while ((c = file.readChar()) != '\n') {
                    out.append(c);
                }
            }
            catch (IOException e) {
                if (e instanceof EOFException) break block3;
                out.setLength(0);
            }
        }
        return out.toString();
    }

    public void put(File file, String str, boolean newLine) {
        file.writeString(str);
        if (newLine) {
            file.writeString("\n");
        }
    }
}

