/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.auth.AuthSchemeBase;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.protocol.HttpContext;

public class HttpBasicAuthInterceptor
implements HttpRequestInterceptor {
    UsernamePasswordCredentials credentials;
    AuthSchemeBase authScheme;

    public HttpBasicAuthInterceptor(String username, String password) {
        if (username != null) {
            this.credentials = new UsernamePasswordCredentials(username, password);
        }
        this.authScheme = new BasicScheme();
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        Header basicAuthHeader = this.authScheme.authenticate((Credentials)this.credentials, httpRequest, httpContext);
        httpRequest.addHeader(basicAuthHeader);
    }
}

