/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.services.impl;

import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hive.llap.io.api.LlapIo;
import org.apache.hadoop.hive.llap.io.api.LlapProxy;
import org.apache.hive.http.HttpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapIoMemoryServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(LlapIoMemoryServlet.class);
    static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";

    public void init() throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            if (!HttpServer.isInstrumentationAccessAllowed((ServletContext)this.getServletContext(), (HttpServletRequest)request, (HttpServletResponse)response)) {
                return;
            }
            try (PrintWriter writer = null;){
                response.setContentType("text/plain; charset=utf8");
                response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, "GET");
                response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
                response.setHeader("Cache-Control", "no-transform,public,max-age=60,s-maxage=60");
                writer = response.getWriter();
                LlapIo llapIo = LlapProxy.getIo();
                if (llapIo == null) {
                    writer.write("LLAP IO not found");
                } else {
                    writer.write(llapIo.getMemoryInfo());
                }
            }
        }
        catch (Exception e) {
            LOG.error("Caught exception while processing llap status request", (Throwable)e);
            response.setStatus(500);
        }
    }
}

