/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.services.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.netty.util.NetUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hive.llap.LlapDaemonInfo;
import org.apache.hadoop.util.Shell;
import org.apache.hive.http.HttpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemConfigurationServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SystemConfigurationServlet.class);
    private static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String ALLOWED_METHODS = "GET";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String CONTENT_TYPE_JSON_UTF8 = "application/json; charset=utf8";
    protected transient JsonFactory jsonFactory;
    private static final String SYSCTL_KV_SEPARATOR = Shell.MAC ? ":" : "=";
    private AtomicReference<String> sysctlOutRef;
    private String FAILED = "failed";

    public void init() throws ServletException {
        this.jsonFactory = new JsonFactory();
        this.sysctlOutRef = new AtomicReference<Object>(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JsonGenerator jg = null;
        PrintWriter writer = null;
        if (!HttpServer.isInstrumentationAccessAllowed((ServletContext)this.getServletContext(), (HttpServletRequest)request, (HttpServletResponse)response)) {
            response.setStatus(401);
            return;
        }
        this.setResponseHeader(response);
        boolean refresh = Boolean.parseBoolean(request.getParameter("refresh"));
        try {
            writer = response.getWriter();
            jg = this.jsonFactory.createJsonGenerator((Writer)writer);
            jg.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
            jg.useDefaultPrettyPrinter();
            jg.writeStartObject();
            jg.writeObjectField("pid", (Object)LlapDaemonInfo.INSTANCE.getPID());
            jg.writeObjectField("os.name", (Object)System.getProperty("os.name"));
            if (Shell.WINDOWS) {
                jg.writeObjectField("net.core.somaxconn", (Object)NetUtil.SOMAXCONN);
            } else {
                String sysctlCmd = "sysctl -a";
                try {
                    if (this.sysctlOutRef.get() == null || refresh) {
                        LOG.info("Reading kernel configs via sysctl..");
                        String sysctlOutput = Shell.execCommand((String[])sysctlCmd.split("\\s+"));
                        this.sysctlOutRef.set(sysctlOutput);
                    }
                }
                catch (IOException e) {
                    LOG.warn("Unable to execute '{}' command", (Object)sysctlCmd, (Object)e);
                    this.sysctlOutRef.set(this.FAILED);
                    jg.writeObjectField("sysctl", (Object)this.FAILED);
                    jg.writeObjectField("sysctl-failure-reason", (Object)e.getMessage());
                }
                if (this.sysctlOutRef.get() != null && !this.sysctlOutRef.get().equals(this.FAILED)) {
                    String[] lines;
                    for (String line : lines = this.sysctlOutRef.get().split("\\r?\\n")) {
                        String value;
                        int sepIdx = line.indexOf(SYSCTL_KV_SEPARATOR);
                        String key = sepIdx == -1 ? line.trim() : line.substring(0, sepIdx).trim();
                        String string = value = sepIdx == -1 ? null : line.substring(sepIdx + 1).trim().replaceAll("\t", "  ");
                        if (key.isEmpty()) continue;
                        jg.writeObjectField(key, (Object)value);
                    }
                }
                if (!Shell.MAC) {
                    String thpFileName = "/sys/kernel/mm/transparent_hugepage/enabled";
                    String thpFileStr = PrivilegedFileReader.read(thpFileName);
                    if (thpFileStr == null) {
                        LOG.warn("Unable to read contents of {}", (Object)thpFileName);
                        thpFileName = "/sys/kernel/mm/redhat_transparent_hugepage/enabled";
                        thpFileStr = PrivilegedFileReader.read(thpFileName);
                    }
                    if (thpFileStr != null) {
                        int strIdx = thpFileStr.indexOf(91);
                        int endIdx = thpFileStr.indexOf(93);
                        jg.writeObjectField(thpFileName, (Object)thpFileStr.substring(strIdx + 1, endIdx));
                    } else {
                        LOG.warn("Unable to read contents of {}", (Object)thpFileName);
                    }
                    String thpDefragFileName = "/sys/kernel/mm/transparent_hugepage/defrag";
                    String thpDefragFileStr = PrivilegedFileReader.read(thpDefragFileName);
                    if (thpDefragFileStr == null) {
                        LOG.warn("Unable to read contents of {}", (Object)thpDefragFileName);
                        thpDefragFileName = "/sys/kernel/mm/redhat_transparent_hugepage/defrag";
                        thpDefragFileStr = PrivilegedFileReader.read(thpDefragFileName);
                    }
                    if (thpDefragFileStr != null) {
                        int strIdx = thpDefragFileStr.indexOf(91);
                        int endIdx = thpDefragFileStr.indexOf(93);
                        jg.writeObjectField(thpDefragFileName, (Object)thpDefragFileStr.substring(strIdx + 1, endIdx));
                    } else {
                        LOG.warn("Unable to read contents of {}", (Object)thpDefragFileName);
                    }
                }
            }
            jg.writeEndObject();
            response.setStatus(200);
        }
        catch (Exception e) {
            LOG.error("Caught exception while processing llap /system web service request", (Throwable)e);
            response.setStatus(500);
        }
        finally {
            if (jg != null) {
                jg.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void setResponseHeader(HttpServletResponse response) {
        response.setContentType(CONTENT_TYPE_JSON_UTF8);
        response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, ALLOWED_METHODS);
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
    }

    private static class PrivilegedFileReader {
        private PrivilegedFileReader() {
        }

        public static String read(final String filename) {
            String result = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String fileString = null;
                    try {
                        fileString = new String(Files.readAllBytes(Paths.get(filename, new String[0])), StandardCharsets.UTF_8);
                    }
                    catch (Exception e) {
                        LOG.warn("Unable to read file: {}", (Object)filename, (Object)e);
                    }
                    return fileString;
                }
            });
            return result;
        }
    }
}

