/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.transport.TTransportException;

public class RetryingMetaStoreClient
implements InvocationHandler {
    private static final Log LOG = LogFactory.getLog((String)RetryingMetaStoreClient.class.getName());
    private final IMetaStoreClient base;
    private final HiveConf hiveConf;
    private final int retryLimit;
    private final int retryDelaySeconds;

    protected RetryingMetaStoreClient(HiveConf hiveConf, HiveMetaHookLoader hookLoader, Class<? extends IMetaStoreClient> msClientClass) throws MetaException {
        this.hiveConf = hiveConf;
        this.retryLimit = hiveConf.getIntVar(HiveConf.ConfVars.METASTORETHRIFTFAILURERETRIES);
        this.retryDelaySeconds = hiveConf.getIntVar(HiveConf.ConfVars.METASTORE_CLIENT_CONNECT_RETRY_DELAY);
        this.base = MetaStoreUtils.newInstance(msClientClass, new Class[]{HiveConf.class, HiveMetaHookLoader.class}, new Object[]{hiveConf, hookLoader});
    }

    public static IMetaStoreClient getProxy(HiveConf hiveConf, HiveMetaHookLoader hookLoader, String mscClassName) throws MetaException {
        Class<?> baseClass = MetaStoreUtils.getClass(mscClassName);
        RetryingMetaStoreClient handler = new RetryingMetaStoreClient(hiveConf, hookLoader, baseClass);
        return (IMetaStoreClient)Proxy.newProxyInstance(RetryingMetaStoreClient.class.getClassLoader(), baseClass.getInterfaces(), (InvocationHandler)handler);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret = null;
        int retriesMade = 0;
        TException caughtException = null;
        while (true) {
            try {
                ret = method.invoke((Object)this.base, args);
            }
            catch (UndeclaredThrowableException e) {
                throw e.getCause();
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof TApplicationException || e.getCause() instanceof TProtocolException || e.getCause() instanceof TTransportException) {
                    caughtException = (TException)e.getCause();
                } else if (e.getCause() instanceof MetaException && e.getCause().getMessage().matches("JDO[a-zA-Z]*Exception")) {
                    caughtException = (MetaException)((Object)e.getCause());
                } else {
                    throw e.getCause();
                }
                if (retriesMade >= this.retryLimit) {
                    throw caughtException;
                }
                ++retriesMade;
                LOG.warn((Object)"MetaStoreClient lost connection. Attempting to reconnect.", (Throwable)caughtException);
                Thread.sleep(this.retryDelaySeconds * 1000);
                this.base.reconnect();
                continue;
            }
            break;
        }
        return ret;
    }
}

