/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.util.VersionInfo;
import org.apache.orc.impl.HadoopShimsCurrent;
import org.apache.orc.impl.HadoopShims_2_2;

public interface HadoopShims {
    public DirectDecompressor getDirectDecompressor(DirectCompressionType var1);

    public static class Factory {
        private static HadoopShims SHIMS = null;

        public static synchronized HadoopShims get() {
            if (SHIMS == null) {
                String[] versionParts = VersionInfo.getVersion().split("[.]");
                int major = Integer.parseInt(versionParts[0]);
                int minor = Integer.parseInt(versionParts[1]);
                SHIMS = major < 2 || major == 2 && minor < 3 ? new HadoopShims_2_2() : new HadoopShimsCurrent();
            }
            return SHIMS;
        }
    }

    public static interface DirectDecompressor {
        public void decompress(ByteBuffer var1, ByteBuffer var2) throws IOException;
    }

    public static enum DirectCompressionType {
        NONE,
        ZLIB_NOHEADER,
        ZLIB,
        SNAPPY;

    }
}

