/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.HiveDriverFilterHook;
import org.apache.hadoop.hive.ql.HiveDriverFilterHookContext;
import org.apache.hadoop.hive.ql.HiveDriverFilterHookContextImpl;
import org.apache.hadoop.hive.ql.HiveDriverFilterHookResult;
import org.apache.hadoop.hive.ql.hooks.Hook;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.session.HiveSession;

public abstract class MetadataOperation
extends Operation {
    protected static final String DEFAULT_HIVE_CATALOG = "";
    protected static TableSchema RESULT_SET_SCHEMA;
    private static final char SEARCH_STRING_ESCAPE = '\\';

    protected MetadataOperation(HiveSession parentSession, OperationType opType) {
        super(parentSession, opType, false);
        this.setHasResultSet(true);
    }

    @Override
    public void close() throws HiveSQLException {
        this.setState(OperationState.CLOSED);
    }

    protected String convertIdentifierPattern(String pattern, boolean datanucleusFormat) {
        if (pattern == null) {
            return this.convertPattern("%", true);
        }
        return this.convertPattern(pattern, datanucleusFormat);
    }

    protected String convertSchemaPattern(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return this.convertPattern("%", true);
        }
        return this.convertPattern(pattern, true);
    }

    private String convertPattern(String pattern, boolean datanucleusFormat) {
        String wStr = datanucleusFormat ? "*" : ".*";
        return pattern.replaceAll("([^\\\\])%", "$1" + wStr).replaceAll("\\\\%", "%").replaceAll("^%", wStr).replaceAll("([^\\\\])_", "$1.").replaceAll("\\\\_", "_").replaceAll("^_", ".");
    }

    private <T extends Hook> List<T> getHooks(HiveConf.ConfVars hookConfVar, Class<T> clazz) throws Exception {
        String[] hookClasses;
        HiveConf conf = this.getParentSession().getHiveConf();
        ArrayList<Hook> hooks = new ArrayList<Hook>();
        String csHooks = conf.getVar(hookConfVar);
        if (csHooks == null) {
            return hooks;
        }
        if ((csHooks = csHooks.trim()).equals(DEFAULT_HIVE_CATALOG)) {
            return hooks;
        }
        for (String hookClass : hookClasses = csHooks.split(",")) {
            try {
                Hook hook = (Hook)Class.forName(hookClass.trim(), true, JavaUtils.getClassLoader()).newInstance();
                hooks.add(hook);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)(hookConfVar.varname + " Class not found:" + e.getMessage()));
                throw e;
            }
        }
        return hooks;
    }

    protected List<String> filterResultSet(List<String> inputResultSet, HiveOperation hiveOperation, String dbName) throws Exception {
        ArrayList<String> filteredResultSet = new ArrayList<String>();
        HiveConf conf = this.getParentSession().getHiveConf();
        String userName = this.getParentSession().getUserName();
        List<HiveDriverFilterHook> filterHooks = null;
        try {
            filterHooks = this.getHooks(HiveConf.ConfVars.HIVE_EXEC_FILTER_HOOK, HiveDriverFilterHook.class);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to obtain filter hooks");
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
        }
        if (inputResultSet != null && !inputResultSet.isEmpty() && filterHooks != null && !filterHooks.isEmpty()) {
            HiveDriverFilterHookContextImpl hookCtx = new HiveDriverFilterHookContextImpl((Configuration)conf, hiveOperation, userName, inputResultSet, dbName);
            HiveDriverFilterHookResult hookResult = null;
            for (HiveDriverFilterHook hook : filterHooks) {
                hookResult = hook.postDriverFetch((HiveDriverFilterHookContext)hookCtx);
                hookCtx.setResult(hookResult.getResult());
            }
            filteredResultSet.addAll(hookResult.getResult());
            return filteredResultSet;
        }
        return inputResultSet;
    }
}

