/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.util.EnumSet;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationStatus;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.thrift.TProtocolVersion;

public abstract class Operation {
    protected final HiveSession parentSession;
    private OperationState state = OperationState.INITIALIZED;
    private final OperationHandle opHandle;
    private HiveConf configuration;
    public static final Log LOG = LogFactory.getLog((String)Operation.class.getName());
    public static final long DEFAULT_FETCH_MAX_ROWS = 100L;
    protected boolean hasResultSet;
    protected volatile HiveSQLException operationException;
    protected final boolean runAsync;
    protected volatile Future<?> backgroundHandle;
    protected static final EnumSet<FetchOrientation> DEFAULT_FETCH_ORIENTATION_SET = EnumSet.of(FetchOrientation.FETCH_NEXT, FetchOrientation.FETCH_FIRST);

    protected Operation(HiveSession parentSession, OperationType opType, boolean runInBackground) {
        this.parentSession = parentSession;
        this.runAsync = runInBackground;
        this.opHandle = new OperationHandle(opType, parentSession.getProtocolVersion());
    }

    public Future<?> getBackgroundHandle() {
        return this.backgroundHandle;
    }

    protected void setBackgroundHandle(Future<?> backgroundHandle) {
        this.backgroundHandle = backgroundHandle;
    }

    public boolean shouldRunAsync() {
        return this.runAsync;
    }

    public void setConfiguration(HiveConf configuration) {
        this.configuration = new HiveConf(configuration);
    }

    public HiveConf getConfiguration() {
        return new HiveConf(this.configuration);
    }

    public HiveSession getParentSession() {
        return this.parentSession;
    }

    public OperationHandle getHandle() {
        return this.opHandle;
    }

    public TProtocolVersion getProtocolVersion() {
        return this.opHandle.getProtocolVersion();
    }

    public OperationType getType() {
        return this.opHandle.getOperationType();
    }

    public OperationStatus getStatus() {
        return new OperationStatus(this.state, this.operationException);
    }

    public boolean hasResultSet() {
        return this.hasResultSet;
    }

    protected void setHasResultSet(boolean hasResultSet) {
        this.hasResultSet = hasResultSet;
        this.opHandle.setHasResultSet(hasResultSet);
    }

    protected final OperationState setState(OperationState newState) throws HiveSQLException {
        this.state.validateTransition(newState);
        this.state = newState;
        return this.state;
    }

    protected void setOperationException(HiveSQLException operationException) {
        this.operationException = operationException;
    }

    protected final void assertState(OperationState state) throws HiveSQLException {
        if (this.state != state) {
            throw new HiveSQLException("Expected state " + (Object)((Object)state) + ", but found " + (Object)((Object)this.state));
        }
    }

    public boolean isRunning() {
        return OperationState.RUNNING.equals((Object)this.state);
    }

    public boolean isFinished() {
        return OperationState.FINISHED.equals((Object)this.state);
    }

    public boolean isCanceled() {
        return OperationState.CANCELED.equals((Object)this.state);
    }

    public boolean isFailed() {
        return OperationState.ERROR.equals((Object)this.state);
    }

    public abstract void run() throws HiveSQLException;

    public void cancel() throws HiveSQLException {
        this.setState(OperationState.CANCELED);
        throw new UnsupportedOperationException("SQLOperation.cancel()");
    }

    public abstract void close() throws HiveSQLException;

    public abstract TableSchema getResultSetSchema() throws HiveSQLException;

    public abstract RowSet getNextRowSet(FetchOrientation var1, long var2) throws HiveSQLException;

    public RowSet getNextRowSet() throws HiveSQLException {
        return this.getNextRowSet(FetchOrientation.FETCH_NEXT, 100L);
    }

    protected void validateDefaultFetchOrientation(FetchOrientation orientation) throws HiveSQLException {
        this.validateFetchOrientation(orientation, DEFAULT_FETCH_ORIENTATION_SET);
    }

    protected void validateFetchOrientation(FetchOrientation orientation, EnumSet<FetchOrientation> supportedOrientations) throws HiveSQLException {
        if (!supportedOrientations.contains((Object)orientation)) {
            throw new HiveSQLException("The fetch type " + orientation.toString() + " is not supported for this resultset", "HY106");
        }
    }
}

