/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.thrift.ThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.cli.thrift.ThriftHttpCLIService;
import org.apache.hive.service.server.ServerOptionsProcessor;

public class HiveServer2
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(HiveServer2.class);
    private CLIService cliService;
    private ThriftCLIService thriftCLIService;

    public HiveServer2() {
        super("HiveServer2");
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        String transportMode;
        this.cliService = new CLIService();
        this.addService(this.cliService);
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS)) {
            try {
                Path scratchDir = new Path(HiveConf.getVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.SCRATCHDIR));
                FileSystem fs = FileSystem.get((Configuration)hiveConf);
                if (!fs.exists(scratchDir)) {
                    fs.mkdirs(scratchDir);
                }
                fs.setPermission(scratchDir, new FsPermission(511));
            }
            catch (IOException e) {
                LOG.warn((Object)String.format("Failed to create/change scratchdir permissions to 777: %s", e.getMessage()), (Throwable)e);
            }
        }
        if ((transportMode = System.getenv("HIVE_SERVER2_TRANSPORT_MODE")) == null) {
            transportMode = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE);
        }
        this.thriftCLIService = transportMode != null && transportMode.equalsIgnoreCase("http") ? new ThriftHttpCLIService(this.cliService) : new ThriftBinaryCLIService(this.cliService);
        this.addService(this.thriftCLIService);
        super.init(hiveConf);
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    @Override
    public synchronized void stop() {
        super.stop();
        HiveConf hiveConf = this.getHiveConf();
        if (hiveConf != null && hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_INITIALIZE_DEFAULT_SESSIONS)) {
            try {
                TezSessionPoolManager.getInstance().stop();
            }
            catch (Exception e) {
                LOG.error((Object)"Tez session pool manager stop had an error during stop of hive server");
                e.printStackTrace();
            }
        }
    }

    private static void startHiveServer2() throws Throwable {
        long attempts = 0L;
        long maxAttempts = 1L;
        while (true) {
            HiveConf hiveConf = new HiveConf();
            maxAttempts = hiveConf.getLongVar(HiveConf.ConfVars.HIVE_SERVER2_MAX_START_ATTEMPTS);
            HiveServer2 server = null;
            try {
                server = new HiveServer2();
                server.init(hiveConf);
                server.start();
                if (!hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_INITIALIZE_DEFAULT_SESSIONS)) break;
                TezSessionPoolManager sessionPool = TezSessionPoolManager.getInstance();
                sessionPool.setupPool(hiveConf);
                sessionPool.startPool();
            }
            catch (Throwable throwable) {
                if (++attempts >= maxAttempts) {
                    throw new Error("Max start attempts " + maxAttempts + " exhausted", throwable);
                }
                LOG.warn((Object)("Error starting HiveServer2 on attempt " + attempts + ", will retry in 60 seconds"), throwable);
                try {
                    if (server != null) {
                        server.stop();
                        server = null;
                    }
                }
                catch (Exception e) {
                    LOG.info((Object)"Exception caught when calling stop of HiveServer2 before retrying start", (Throwable)e);
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        try {
            ServerOptionsProcessor oproc = new ServerOptionsProcessor("hiveserver2");
            if (!oproc.process(args)) {
                System.err.println("Error starting HiveServer2 with given arguments");
                System.exit(-1);
            }
            String initLog4jMessage = LogUtils.initHiveLog4j();
            LOG.debug((Object)initLog4jMessage);
            HiveStringUtils.startupShutdownMessage(HiveServer2.class, (String[])args, (Log)LOG);
            LOG.debug((Object)oproc.getDebugMessage().toString());
            HiveServer2.startHiveServer2();
        }
        catch (LogUtils.LogInitializationException e) {
            LOG.error((Object)("Error initializing log: " + e.getMessage()), (Throwable)e);
            System.exit(-1);
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting HiveServer2", t);
            System.exit(-1);
        }
    }
}

