// Autogenerated Jamon implementation
// /Users/ngangam/commit/hive/service/src/jamon/org/apache/hive/tmpl/QueryProfileTmpl.jamon

package org.apache.hive.tmpl;

// 24, 1
import java.util.*;
// 25, 1
import org.apache.hadoop.hive.ql.QueryDisplay;
// 26, 1
import org.apache.hadoop.hive.ql.QueryInfo;
// 27, 1
import org.apache.hadoop.hive.conf.HiveConf;

public class QueryProfileTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hive.tmpl.QueryProfileTmpl.Intf

{
  private final QueryInfo queryInfo;
  private final HiveConf hiveConf;
  protected static org.apache.hive.tmpl.QueryProfileTmpl.ImplData __jamon_setOptionalArguments(org.apache.hive.tmpl.QueryProfileTmpl.ImplData p_implData)
  {
    return p_implData;
  }
  public QueryProfileTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hive.tmpl.QueryProfileTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    queryInfo = p_implData.getQueryInfo();
    hiveConf = p_implData.getHiveConf();
  }
  
  public void renderNoFlush(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 29, 1
    jamonWriter.write("<!--[if IE]>\n<!DOCTYPE html>\n<![endif]-->\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>HiveServer2</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hive.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n  <div class=\"navbar  navbar-fixed-top navbar-default\">\n      <div class=\"container\">\n          <div class=\"navbar-header\">\n              <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                  <span class=\"icon-bar\"></span>\n                  <span class=\"icon-bar\"></span>\n                  <span class=\"icon-bar\"></span>\n              </button>\n              <a class=\"navbar-brand\" href=\"/hiveserver2.jsp\"><img src=\"/static/hive_logo.jpeg\" alt=\"Hive Logo\"/></a>\n          </div>\n          <div class=\"collapse navbar-collapse\">\n              <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/\">Home</a></li>\n                <li><a href=\"/logs/\">Local logs</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                <li><a href=\"/conf\">Hive Configuration</a></li>\n                <li><a href=\"/stacks\">Stack Trace</a></li>\n            </ul>\n          </div><!--/.nav-collapse -->\n        </div>\n      </div>\n    </div>\n\n\n    ");
    // 70, 5
    if (queryInfo == null )
    {
      // 70, 30
      jamonWriter.write("\n         <div class=\"jumbotron\">\n           <p>Query not found.  It may have been deleted, increase <i>hive.server2.webui.max.historic.queries</i>\n              to retain more historic query information.</p>\n         </div>\n    ");
    }
    // 75, 5
    else
    {
      // 75, 12
      jamonWriter.write("\n\n\n    <div class=\"container\">\n      <div class=\"row inner_header\">\n        <div class=\"page-header\">\n          <h1>Query Information: ");
      // 81, 34
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getQueryDisplay() == null ? "Unknown" : queryInfo.getQueryDisplay().getQueryString()), jamonWriter);
      // 81, 134
      jamonWriter.write("</h1>\n        </div>\n      </div>\n      <div class=\"row\">\n\n\n      <div class=\"tabbable\">\n          <ul class=\"nav nav-pills\">\n              <li class=\"active\"><a href=\"#tab_baseProfile\" data-toggle=\"tab\">Base Profile</a></li>\n              <li class=\"\"><a href=\"#tab_stages\" data-toggle=\"tab\">Stages</a></li>\n              <li class=\"\"><a href=\"#tab_queryPlan\" data-toggle=\"tab\">Query Plan</a></li>\n              <li class=\"\"><a href=\"#tab_perfLogging\" data-toggle=\"tab\">Performance Logging</a></li>\n          </ul>\n          <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n              <div class=\"tab-pane active\" id=\"tab_baseProfile\">\n                  ");
      // 96, 19
      {
        // 96, 19
        __jamon_innerUnit__baseProfile(jamonWriter, queryInfo );
      }
      // 96, 59
      jamonWriter.write("\n              </div>\n              <div class=\"tab-pane\" id=\"tab_stages\">\n                  ");
      // 99, 19
      {
        // 99, 19
        __jamon_innerUnit__stages(jamonWriter, queryInfo );
      }
      // 99, 54
      jamonWriter.write("\n              </div>\n              <div class=\"tab-pane\" id=\"tab_queryPlan\">\n                  ");
      // 102, 19
      {
        // 102, 19
        __jamon_innerUnit__queryPlan(jamonWriter, queryInfo );
      }
      // 102, 57
      jamonWriter.write("\n              </div>\n              <div class=\"tab-pane\" id=\"tab_perfLogging\">\n                  ");
      // 105, 19
      {
        // 105, 19
        __jamon_innerUnit__perfLogging(jamonWriter, queryInfo );
      }
      // 105, 59
      jamonWriter.write("\n              </div>\n          </div>\n      </div>\n\n   ");
    }
    // 110, 10
    jamonWriter.write("\n\n</div>\n</div>\n<script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n</body>\n</html>\n\n</div>\n</div>\n<script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n</body>\n</html>\n");
  }
  
  
  // 120, 1
  private void __jamon_innerUnit__baseProfile(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final QueryInfo queryInfo)
    throws java.io.IOException
  {
    // 124, 5
    jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <td>User Name</td>\n            <td>");
    // 127, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getUserName()), jamonWriter);
    // 127, 46
    jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Query String</td>\n            <td>");
    // 131, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getQueryDisplay() == null ? "Unknown" : queryInfo.getQueryDisplay().getQueryString()), jamonWriter);
    // 131, 117
    jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Id</td>\n            <td>");
    // 135, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getQueryDisplay() == null ? "Unknown" : queryInfo.getQueryDisplay().getQueryId()), jamonWriter);
    // 135, 113
    jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Execution Engine</td>\n            <td>");
    // 139, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getExecutionEngine()), jamonWriter);
    // 139, 53
    jamonWriter.write("\n        </tr>\n        <tr>\n            <td>State</td>\n            <td>");
    // 143, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getState()), jamonWriter);
    // 143, 43
    jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Opened Timestamp</td>\n            <td>");
    // 147, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(queryInfo.getBeginTime())), jamonWriter);
    // 147, 57
    jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Opened (s)</td>\n            <td>");
    // 151, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getElapsedTime()/1000), jamonWriter);
    // 151, 54
    jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Closed Timestamp</td>\n            <td>");
    // 155, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getEndTime() == null ? "Open" : new Date(queryInfo.getEndTime())), jamonWriter);
    // 155, 97
    jamonWriter.write("</td>\n        </tr>\n        ");
    // 157, 9
    if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getErrorMessage() != null )
    {
      // 157, 109
      jamonWriter.write("\n            <tr>\n                <td>Error</td>\n                <td>");
      // 160, 21
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getQueryDisplay().getErrorMessage()), jamonWriter);
      // 160, 72
      jamonWriter.write("</td>\n            </tr>\n        ");
    }
    // 162, 15
    jamonWriter.write("\n        <tr>\n            <td>Latency (s)</td>\n            <td>");
    // 165, 17
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getRuntime() == null ? "Not finished" : queryInfo.getRuntime()/1000), jamonWriter);
    // 165, 100
    jamonWriter.write("</td>\n        </tr>\n    </table>\n");
  }
  
  
  // 170, 1
  private void __jamon_innerUnit__stages(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final QueryInfo queryInfo)
    throws java.io.IOException
  {
    // 174, 4
    jamonWriter.write("<table class=\"table table-striped\">\n       <tr>\n           <th>Stage Id</th>\n           <th>Status</th>\n           <th>Begin Time</th>\n           <th>End Time</th>\n           <th>Elapsed Time (s)</th>\n           <th>Requires Lock</th>\n        </tr>\n\n       ");
    // 184, 8
    if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getTaskDisplays() != null )
    {
      // 184, 108
      jamonWriter.write("\n           ");
      // 185, 12
      for (QueryDisplay.TaskDisplay taskDisplay : queryInfo.getQueryDisplay().getTaskDisplays() )
      {
        // 185, 105
        jamonWriter.write("\n               <tr>\n                   <td>");
        // 187, 24
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getTaskId() + ":" + taskDisplay.getTaskType()), jamonWriter);
        // 187, 87
        jamonWriter.write("</td>\n                   <td>");
        // 188, 24
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getStatus()), jamonWriter);
        // 188, 53
        jamonWriter.write("</td>\n                   <td>");
        // 189, 24
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getBeginTime() == null ? "" : new Date(taskDisplay.getBeginTime())), jamonWriter);
        // 189, 108
        jamonWriter.write("</td>\n                   <td>");
        // 190, 24
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getEndTime() == null ? "" : new Date(taskDisplay.getEndTime())), jamonWriter);
        // 190, 104
        jamonWriter.write("</td>\n                   <td>");
        // 191, 24
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.getElapsedTime() == null ? "" : taskDisplay.getElapsedTime()/1000), jamonWriter);
        // 191, 107
        jamonWriter.write(" (s) </td>\n                   <td>");
        // 192, 24
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(taskDisplay.isRequireLock()), jamonWriter);
        // 192, 57
        jamonWriter.write("</td>\n               </tr>\n           ");
      }
      // 194, 19
      jamonWriter.write("\n       ");
    }
    // 195, 14
    jamonWriter.write("\n   </table>\n");
  }
  
  
  // 200, 1
  private void __jamon_innerUnit__queryPlan(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final QueryInfo queryInfo)
    throws java.io.IOException
  {
    // 204, 5
    jamonWriter.write("<div class=\"panel panel-default\">\n      <div class=\"panel-heading\">Explain plan</div>\n      <div class=\"panel-body\">\n        ");
    // 207, 9
    if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_LOG_EXPLAIN_OUTPUT) )
    {
      // 207, 79
      jamonWriter.write("\n          <pre>\n          ");
      // 209, 11
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(queryInfo.getQueryDisplay() == null ? "Unknown" : queryInfo.getQueryDisplay().getExplainPlan()), jamonWriter);
      // 209, 111
      jamonWriter.write("\n          </pre>\n        ");
    }
    // 211, 9
    else
    {
      // 211, 16
      jamonWriter.write("\n          <pre>\n          Set configuration hive.log.explain.output to true to view future query plans\n          </pre>\n        ");
    }
    // 215, 15
    jamonWriter.write("\n      </div>\n    </div>\n");
  }
  
  
  // 221, 1
  private void __jamon_innerUnit__perfLogging(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter, final QueryInfo queryInfo)
    throws java.io.IOException
  {
    // 225, 5
    jamonWriter.write("<section>\n      <h3>Compile-time metadata operations</h3>\n        <table class=\"table table-striped\">\n          <tr>\n             <th>Call Name</th>\n             <th>Time (ms)</th>\n          </tr>\n\n          ");
    // 233, 11
    if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getHmsTimings(QueryDisplay.Phase.COMPILATION) != null )
    {
      // 233, 139
      jamonWriter.write("\n             ");
      // 234, 14
      for (Map.Entry<String, Long> time : queryInfo.getQueryDisplay().getHmsTimings(QueryDisplay.Phase.COMPILATION).entrySet() )
      {
        // 234, 138
        jamonWriter.write("\n                 <tr>\n                     <td>");
        // 236, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getKey()), jamonWriter);
        // 236, 45
        jamonWriter.write("</td>\n                     <td>");
        // 237, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getValue()), jamonWriter);
        // 237, 47
        jamonWriter.write("</td>\n                 </tr>\n             ");
      }
      // 239, 21
      jamonWriter.write("\n         ");
    }
    // 240, 16
    jamonWriter.write("\n        </table>\n      </section>\n\n    <section>\n      <h3>Execution-time metadata operations</h3>\n        <table class=\"table table-striped\">\n          <tr>\n             <th>Call Name</th>\n             <th>Time (ms)</th>\n          </tr>\n\n          ");
    // 252, 11
    if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getHmsTimings(QueryDisplay.Phase.EXECUTION) != null )
    {
      // 252, 137
      jamonWriter.write("\n             ");
      // 253, 14
      for (Map.Entry<String, Long> time : queryInfo.getQueryDisplay().getHmsTimings(QueryDisplay.Phase.EXECUTION).entrySet() )
      {
        // 253, 136
        jamonWriter.write("\n                 <tr>\n                     <td>");
        // 255, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getKey()), jamonWriter);
        // 255, 45
        jamonWriter.write("</td>\n                     <td>");
        // 256, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getValue()), jamonWriter);
        // 256, 47
        jamonWriter.write("</td>\n                 </tr>\n             ");
      }
      // 258, 21
      jamonWriter.write("\n         ");
    }
    // 259, 16
    jamonWriter.write("\n        </table>\n      </section>\n\n    <section>\n      <h3>Compile-Time Perf-Logger</h3>\n        <table class=\"table table-striped\">\n          <tr>\n             <th>Compile-time Call Name</th>\n             <th>Time (ms)</th>\n          </tr>\n\n          ");
    // 271, 11
    if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getPerfLogTimes(QueryDisplay.Phase.COMPILATION) != null )
    {
      // 271, 141
      jamonWriter.write("\n             ");
      // 272, 14
      for (Map.Entry<String, Long> time : queryInfo.getQueryDisplay().getPerfLogTimes(QueryDisplay.Phase.COMPILATION).entrySet()  )
      {
        // 272, 141
        jamonWriter.write("\n                 <tr>\n                     <td>");
        // 274, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getKey()), jamonWriter);
        // 274, 45
        jamonWriter.write("</td>\n                     <td>");
        // 275, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getValue()), jamonWriter);
        // 275, 47
        jamonWriter.write("</td>\n                 </tr>\n             ");
      }
      // 277, 21
      jamonWriter.write("\n         ");
    }
    // 278, 16
    jamonWriter.write("\n        </table>\n      </section>\n\n    <section>\n      <h3>Execution-Time Perf-Logger</h3>\n        <table class=\"table table-striped\">\n          <tr>\n             <th>Execution-time Call Name</th>\n             <th>Time (ms)</th>\n          </tr>\n\n          ");
    // 290, 11
    if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getPerfLogTimes(QueryDisplay.Phase.EXECUTION) != null )
    {
      // 290, 139
      jamonWriter.write("\n             ");
      // 291, 14
      for (Map.Entry<String, Long> time : queryInfo.getQueryDisplay().getPerfLogTimes(QueryDisplay.Phase.EXECUTION).entrySet()  )
      {
        // 291, 139
        jamonWriter.write("\n                 <tr>\n                     <td>");
        // 293, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getKey()), jamonWriter);
        // 293, 45
        jamonWriter.write("</td>\n                     <td>");
        // 294, 26
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(time.getValue()), jamonWriter);
        // 294, 47
        jamonWriter.write("</td>\n                 </tr>\n             ");
      }
      // 296, 21
      jamonWriter.write("\n         ");
    }
    // 297, 16
    jamonWriter.write("\n        </table>\n      </section>\n");
  }
  
  
}
