/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.partition.spec;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionListComposingSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;

public class PartitionListComposingSpecProxy
extends PartitionSpecProxy {
    private PartitionSpec partitionSpec;

    protected PartitionListComposingSpecProxy(PartitionSpec partitionSpec) throws MetaException {
        assert (partitionSpec.isSetPartitionList()) : "Partition-list should have been set.";
        PartitionListComposingSpec partitionList = partitionSpec.getPartitionList();
        if (partitionList == null || partitionList.getPartitions() == null) {
            throw new MetaException("The partition list cannot be null.");
        }
        for (Partition partition : partitionList.getPartitions()) {
            if (partition == null) {
                throw new MetaException("Partition cannot be null.");
            }
            if (partition.getValues() == null || partition.getValues().isEmpty()) {
                throw new MetaException("The partition value list cannot be null or empty.");
            }
            if (!partition.getValues().contains(null)) continue;
            throw new MetaException("Partition value cannot be null.");
        }
        this.partitionSpec = partitionSpec;
    }

    @Override
    public String getCatName() {
        return this.partitionSpec.getCatName();
    }

    @Override
    public String getDbName() {
        return this.partitionSpec.getDbName();
    }

    @Override
    public String getTableName() {
        return this.partitionSpec.getTableName();
    }

    @Override
    public PartitionSpecProxy.PartitionIterator getPartitionIterator() {
        return new Iterator(this);
    }

    @Override
    public List<PartitionSpec> toPartitionSpec() {
        return Arrays.asList(this.partitionSpec);
    }

    @Override
    public int size() {
        return this.partitionSpec.getPartitionList().getPartitionsSize();
    }

    @Override
    public void setCatName(String catName) {
        this.partitionSpec.setCatName(catName);
        for (Partition partition : this.partitionSpec.getPartitionList().getPartitions()) {
            partition.setCatName(catName);
        }
    }

    @Override
    public void setDbName(String dbName) {
        this.partitionSpec.setDbName(dbName);
        for (Partition partition : this.partitionSpec.getPartitionList().getPartitions()) {
            partition.setDbName(dbName);
        }
    }

    @Override
    public void setTableName(String tableName) {
        this.partitionSpec.setTableName(tableName);
        for (Partition partition : this.partitionSpec.getPartitionList().getPartitions()) {
            partition.setTableName(tableName);
        }
    }

    @Override
    public void setRootLocation(String newRootPath) throws MetaException {
        String oldRootPath = this.partitionSpec.getRootPath();
        if (oldRootPath == null) {
            throw new MetaException("No common root-path. Can't replace root-path!");
        }
        if (newRootPath == null) {
            throw new MetaException("Root path cannot be null.");
        }
        for (Partition partition : this.partitionSpec.getPartitionList().getPartitions()) {
            String location = partition.getSd().getLocation();
            if (location.startsWith(oldRootPath)) {
                partition.getSd().setLocation(location.replace(oldRootPath, newRootPath));
                continue;
            }
            throw new MetaException("Common root-path not found. Can't replace root-path!");
        }
    }

    public static class Iterator
    implements PartitionSpecProxy.PartitionIterator {
        PartitionListComposingSpecProxy partitionSpecProxy;
        List<Partition> partitionList;
        int index;

        public Iterator(PartitionListComposingSpecProxy partitionSpecProxy) {
            this.partitionSpecProxy = partitionSpecProxy;
            this.partitionList = partitionSpecProxy.partitionSpec.getPartitionList().getPartitions();
            this.index = 0;
        }

        @Override
        public Partition getCurrent() {
            return this.partitionList.get(this.index);
        }

        @Override
        public String getCatName() {
            return this.partitionSpecProxy.getCatName();
        }

        @Override
        public String getDbName() {
            return this.partitionSpecProxy.getDbName();
        }

        @Override
        public String getTableName() {
            return this.partitionSpecProxy.getTableName();
        }

        @Override
        public Map<String, String> getParameters() {
            return this.partitionList.get(this.index).getParameters();
        }

        @Override
        public void setParameters(Map<String, String> parameters) {
            this.partitionList.get(this.index).setParameters(parameters);
        }

        @Override
        public String getLocation() {
            return this.partitionList.get(this.index).getSd().getLocation();
        }

        @Override
        public void putToParameters(String key, String value) {
            this.partitionList.get(this.index).putToParameters(key, value);
        }

        @Override
        public void setCreateTime(long time) {
            this.partitionList.get(this.index).setCreateTime((int)time);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.partitionList.size();
        }

        @Override
        public Partition next() {
            return this.partitionList.get(this.index++);
        }

        @Override
        public void remove() {
            this.partitionList.remove(this.index);
        }
    }
}

