/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nullable;

public abstract class PropertyType<T> {
    private static final Map<String, PropertyType<?>> TYPES = new HashMap();
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final String name;
    public static final PropertyType<String> STRING = new PropertyType<String>("string"){

        @Override
        public String cast(Object value) {
            return value == null ? null : value.toString();
        }

        @Override
        public String parse(String str) {
            return str;
        }
    };
    public static final PropertyType<Boolean> BOOLEAN = new PropertyType<Boolean>("boolean"){

        @Override
        @Nullable
        public Boolean cast(Object value) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value == null) {
                return null;
            }
            return this.parse(value.toString());
        }

        @Override
        @Nullable
        public Boolean parse(String str) {
            if ("true".equalsIgnoreCase(str)) {
                return true;
            }
            if ("false".equalsIgnoreCase(str)) {
                return false;
            }
            return null;
        }

        @Override
        @Nullable
        public String format(Object value) {
            if (value instanceof Boolean) {
                return (Boolean)value != false ? "true" : "false";
            }
            return null;
        }

        @Override
        public void write(DataOutput out, Boolean value) throws IOException {
            out.writeBoolean(value);
        }

        @Override
        public Boolean read(DataInput in) throws IOException {
            return in.readBoolean();
        }
    };
    public static final PropertyType<Integer> INTEGER = new PropertyType<Integer>("integer"){

        @Override
        public Integer cast(Object value) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value == null) {
                return null;
            }
            return this.parse(value.toString());
        }

        @Override
        public Integer parse(String str) {
            if (str == null) {
                return null;
            }
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException xformat) {
                return null;
            }
        }

        @Override
        public String format(Object value) {
            if (value instanceof Integer) {
                return String.valueOf(value);
            }
            return null;
        }

        @Override
        public void write(DataOutput out, Integer value) throws IOException {
            out.writeInt(value);
        }

        @Override
        public Integer read(DataInput in) throws IOException {
            return in.readInt();
        }
    };
    public static final PropertyType<Long> LONG = new PropertyType<Long>("long"){

        @Override
        public Long cast(Object value) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value == null) {
                return null;
            }
            return this.parse(value.toString());
        }

        @Override
        public Long parse(String str) {
            if (str == null) {
                return null;
            }
            try {
                return Long.parseLong(str);
            }
            catch (NumberFormatException xformat) {
                return null;
            }
        }

        @Override
        public String format(Object value) {
            if (value instanceof Long) {
                return String.valueOf(value);
            }
            return null;
        }

        @Override
        public void write(DataOutput out, Long value) throws IOException {
            out.writeLong(value);
        }

        @Override
        public Long read(DataInput in) throws IOException {
            return in.readLong();
        }
    };
    public static final PropertyType<Date> DATETIME = new PropertyType<Date>("date"){

        @Override
        public Date cast(Object value) {
            if (value instanceof Number) {
                return new Date(((Number)value).longValue());
            }
            if (value instanceof Date) {
                return (Date)value;
            }
            if (value == null) {
                return null;
            }
            return this.parse(value.toString());
        }

        @Override
        public Date parse(String str) {
            if (str == null) {
                return null;
            }
            try {
                return PropertyType.getDateFormat().parse(str);
            }
            catch (ParseException xparse) {
                return null;
            }
        }

        @Override
        public String format(Object value) {
            if (value instanceof Date) {
                return PropertyType.getDateFormat().format((Date)value);
            }
            return null;
        }

        @Override
        public void write(DataOutput out, Date value) throws IOException {
            out.writeLong(value.getTime());
        }

        @Override
        public Date read(DataInput in) throws IOException {
            return new Date(in.readLong());
        }
    };
    public static final PropertyType<Double> DOUBLE = new PropertyType<Double>("double"){

        @Override
        public Double cast(Object value) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            if (value == null) {
                return null;
            }
            return this.parse(value.toString());
        }

        @Override
        public Double parse(String str) {
            if (str == null) {
                return null;
            }
            try {
                return Double.parseDouble(str);
            }
            catch (NumberFormatException xformat) {
                return null;
            }
        }

        @Override
        public String format(Object value) {
            if (value instanceof Double) {
                return String.valueOf(value);
            }
            return null;
        }

        @Override
        public void write(DataOutput out, Double value) throws IOException {
            out.writeDouble(value);
        }

        @Override
        public Double read(DataInput in) throws IOException {
            return in.readDouble();
        }
    };
    public static final PropertyType<Object> JSON = new PropertyType<Object>("json"){

        @Override
        public Object cast(Object value) {
            if (value instanceof JsonElement) {
                return value;
            }
            if (value == null) {
                return null;
            }
            return this.parse(value.toString());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object parse(String str) {
            if (str == null) {
                return null;
            }
            try (StringReader reader = new StringReader(str);){
                Object object = new Gson().fromJson((Reader)reader, Object.class);
                return object;
            }
            catch (JsonIOException | JsonSyntaxException | IOException e) {
                return null;
            }
        }

        @Override
        public String format(Object value) {
            if (value == null) {
                return null;
            }
            return new Gson().toJson(value);
        }
    };

    private static SimpleDateFormat getDateFormat() {
        SimpleDateFormat sdtf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SS'Z'");
        sdtf.setTimeZone(UTC);
        return sdtf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyType<?> get(String name) {
        Map<String, PropertyType<?>> map = TYPES;
        synchronized (map) {
            return TYPES.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean register(PropertyType<?> type) {
        String name = type.getName();
        Map<String, PropertyType<?>> map = TYPES;
        synchronized (map) {
            PropertyType<?> ptype = TYPES.putIfAbsent(name, type);
            if (ptype != null) {
                if (ptype == type) {
                    return false;
                }
                throw new IllegalArgumentException("type " + name + " is already registered");
            }
        }
        return true;
    }

    protected PropertyType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.getName();
    }

    public abstract T cast(Object var1);

    public abstract T parse(String var1);

    public String format(Object value) {
        return value == null ? null : value.toString();
    }

    public void write(DataOutput out, T value) throws IOException {
        out.writeUTF(this.format(value));
    }

    public T read(DataInput in) throws IOException {
        return this.parse(in.readUTF());
    }

    static {
        PropertyType.register(BOOLEAN);
        PropertyType.register(INTEGER);
        PropertyType.register(LONG);
        PropertyType.register(DOUBLE);
        PropertyType.register(STRING);
        PropertyType.register(DATETIME);
        PropertyType.register(JSON);
    }
}

