/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.repl.ReplConst;
import org.apache.hadoop.hive.metastore.ColumnType;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionsSpecByExprResult;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.WMPoolSchedulingPolicy;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.security.SaslRpcServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreUtils {
    private static final DateTimeFormatter DATE_FORMATTER = MetaStoreUtils.createDateTimeFormatter("uuuu-MM-dd");
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = MetaStoreUtils.createDateTimeFormatter("uuuu-MM-dd HH:mm:ss");
    public static final String TYPE_FROM_DESERIALIZER = "<derived from deserializer>";
    private static final Logger LOG = LoggerFactory.getLogger(MetaStoreUtils.class);
    public static final char CATALOG_DB_THRIFT_NAME_MARKER = '@';
    public static final String CATALOG_DB_SEPARATOR = "#";
    public static final String DB_EMPTY_MARKER = "!";
    public static final String EXTERNAL_TABLE_PURGE = "external.table.purge";
    private static final char[] SPECIAL_CHARACTERS_IN_TABLE_NAMES = new char[]{' ', '\"', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '[', ']', '_', '|', '{', '}', '$', '^', '!', '~', '#', '@', '`'};
    public static final String NO_VAL = " --- ";
    public static final String USER_NAME_HTTP_HEADER = "x-actor-username";
    private static String ARCHIVING_LEVEL = "archiving_level";
    private static final String[] nullCatalogAndDatabase = new String[]{null, null};
    public static final int CAT_NAME = 0;
    public static final int DB_NAME = 1;

    private static DateTimeFormatter createDateTimeFormatter(String format) {
        return DateTimeFormatter.ofPattern(format).withZone(TimeZone.getTimeZone("UTC").toZoneId()).withResolverStyle(ResolverStyle.STRICT);
    }

    public static String convertDateToString(Date date) {
        return DATE_FORMATTER.format(date.toLocalDate());
    }

    public static Date convertStringToDate(String date) {
        LocalDate val = LocalDate.parse(date, DATE_FORMATTER);
        return Date.valueOf(val);
    }

    public static String normalizeDate(String date) {
        return MetaStoreUtils.convertDateToString(MetaStoreUtils.convertStringToDate(date));
    }

    public static String convertTimestampToString(Timestamp timestamp) {
        return TIMESTAMP_FORMATTER.format(timestamp.toLocalDateTime());
    }

    public static Timestamp convertStringToTimestamp(String timestamp) {
        LocalDateTime val = LocalDateTime.from(TIMESTAMP_FORMATTER.parse(timestamp));
        return Timestamp.valueOf(val);
    }

    public static void throwMetaException(Exception e) throws MetaException {
        throw new MetaException("Got exception: " + e.getClass().getName() + " " + e.getMessage());
    }

    public static String encodeTableName(String name) {
        StringBuilder sb = new StringBuilder();
        for (char ch : name.toCharArray()) {
            if (Character.isLetterOrDigit(ch) || ch == '_') {
                sb.append(ch);
                continue;
            }
            sb.append('-').append((int)ch).append('-');
        }
        return sb.toString();
    }

    public static MetaException newMetaException(Exception e) {
        return MetaStoreUtils.newMetaException(e != null ? e.getMessage() : null, e);
    }

    public static MetaException newMetaException(String errorMessage, Exception e) {
        MetaException metaException = new MetaException(errorMessage);
        if (e != null) {
            metaException.initCause(e);
        }
        return metaException;
    }

    public static List<String> getColumnNamesForTable(Table table) {
        ArrayList<String> colNames = new ArrayList<String>();
        Iterator<FieldSchema> colsIterator = table.getSd().getColsIterator();
        while (colsIterator.hasNext()) {
            colNames.add(colsIterator.next().getName());
        }
        return colNames;
    }

    public static boolean validateTblStorage(StorageDescriptor sd) {
        return !StringUtils.isNotBlank((CharSequence)sd.getLocation()) || new Path(sd.getLocation()).getParent() != null;
    }

    public static boolean validateName(String name, Configuration conf) {
        StringBuilder allowedSpecialCharacters = new StringBuilder();
        if (conf != null && MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.SUPPORT_SPECICAL_CHARACTERS_IN_TABLE_NAMES)) {
            char[] cArray = SPECIAL_CHARACTERS_IN_TABLE_NAMES;
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character c = Character.valueOf(cArray[i]);
                allowedSpecialCharacters.append(c);
            }
        }
        Pattern tpat = Pattern.compile("[\\w" + Pattern.quote(allowedSpecialCharacters.toString()) + "]+");
        Matcher m = tpat.matcher(name);
        return m.matches();
    }

    public static boolean isExternalTable(Table table) {
        if (table == null) {
            return false;
        }
        Map<String, String> params = table.getParameters();
        if (params == null) {
            return false;
        }
        return MetaStoreUtils.isExternal(params);
    }

    public static boolean isIcebergTable(Map<String, String> params) {
        return "ICEBERG".equalsIgnoreCase(params.get("table_type"));
    }

    public static boolean isTranslatedToExternalTable(Table table) {
        Map<String, String> params = table.getParameters();
        return params != null && MetaStoreUtils.isPropertyTrue(params, "EXTERNAL") && MetaStoreUtils.isPropertyTrue(params, "TRANSLATED_TO_EXTERNAL") && table.getSd() != null && table.getSd().isSetLocation();
    }

    public static String getDbNameFromReplPolicy(String replPolicy) {
        assert (replPolicy != null);
        return replPolicy.split(Pattern.quote("."))[0];
    }

    public static boolean isDbReplIncompatible(Database db) {
        if (db == null) {
            return false;
        }
        Map<String, String> dbParameters = db.getParameters();
        return dbParameters != null && "true".equalsIgnoreCase(dbParameters.get("repl.incompatible"));
    }

    public static boolean isDbBeingPlannedFailedOver(Database db) {
        assert (db != null);
        Map<String, String> dbParameters = db.getParameters();
        if (dbParameters == null) {
            return false;
        }
        String dbFailoverEndPoint = dbParameters.get("repl.failover.endpoint");
        return FailoverEndpoint.SOURCE.toString().equalsIgnoreCase(dbFailoverEndPoint) || FailoverEndpoint.TARGET.toString().equalsIgnoreCase(dbFailoverEndPoint);
    }

    public static boolean isDbBeingPlannedFailedOverAtEndpoint(Database db, FailoverEndpoint endPoint) {
        if (db == null) {
            return false;
        }
        Map<String, String> dbParameters = db.getParameters();
        return dbParameters != null && endPoint.toString().equalsIgnoreCase(dbParameters.get("repl.failover.endpoint"));
    }

    public static boolean isTargetOfReplication(Database db) {
        assert (db != null);
        Map<String, String> dbParameters = db.getParameters();
        return dbParameters != null && !StringUtils.isEmpty((CharSequence)dbParameters.get("repl.target.for"));
    }

    public static boolean isBackgroundThreadsEnabledForRepl(Database db) {
        assert (db != null);
        Map<String, String> dbParameters = db.getParameters();
        return dbParameters != null && !StringUtils.isEmpty((CharSequence)dbParameters.get("repl.background.enable"));
    }

    public static boolean checkIfDbNeedsToBeSkipped(Database db) {
        assert (db != null);
        if (MetaStoreUtils.isBackgroundThreadsEnabledForRepl(db)) {
            return false;
        }
        if (MetaStoreUtils.isDbBeingPlannedFailedOver(db)) {
            LOG.info("Skipping all the tables which belong to database: {} as it is being failed over", (Object)db.getName());
            return true;
        }
        if (MetaStoreUtils.isTargetOfReplication(db)) {
            LOG.info("Skipping all the tables which belong to replicated database: {}", (Object)db.getName());
            return true;
        }
        return false;
    }

    public static List<String> getReplicationDbProps() {
        return Arrays.stream(ReplConst.class.getDeclaredFields()).filter(field -> Modifier.isStatic(field.getModifiers())).map(field -> {
            try {
                String prop = (String)field.get(String.class);
                return prop.replace("\"", "");
            }
            catch (IllegalAccessException e) {
                LOG.error("Failed to collect replication specific properties. Reason: ", (Throwable)e);
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    public static boolean isExternalTablePurge(Table table) {
        if (table == null) {
            return false;
        }
        Map<String, String> params = table.getParameters();
        if (params == null) {
            return false;
        }
        return MetaStoreUtils.isPropertyTrue(params, EXTERNAL_TABLE_PURGE);
    }

    public static boolean isExternal(Map<String, String> tableParams) {
        return MetaStoreUtils.isPropertyTrue(tableParams, "EXTERNAL");
    }

    public static boolean isPropertyTrue(Map<String, String> tableParams, String prop) {
        return "TRUE".equalsIgnoreCase(tableParams.get(prop));
    }

    public static boolean isSkipTrash(Map<String, String> tableParams) {
        if (tableParams == null) {
            return false;
        }
        return MetaStoreUtils.isPropertyTrue(tableParams, "skip.trash") || MetaStoreUtils.isPropertyTrue(tableParams, "auto.purge");
    }

    public static boolean isInsertOnlyTableParam(Map<String, String> params) {
        String transactionalProp = params.get("transactional_properties");
        return transactionalProp != null && "insert_only".equalsIgnoreCase(transactionalProp);
    }

    public static boolean isNonNativeTable(Table table) {
        if (table == null || table.getParameters() == null) {
            return false;
        }
        return MetaStoreUtils.isNonNativeTable(table.getParameters());
    }

    public static boolean isNonNativeTable(Map<String, String> tblProps) {
        return tblProps.get("storage_handler") != null;
    }

    public static List<String> getPvals(List<FieldSchema> partCols, Map<String, String> partSpec) {
        ArrayList<String> pvals = new ArrayList<String>(partCols.size());
        for (FieldSchema field : partCols) {
            String val = StringUtils.defaultString((String)partSpec.get(field.getName()));
            pvals.add(val);
        }
        return pvals;
    }

    public static String makePartNameMatcher(Table table, List<String> partVals, String defaultStr) throws MetaException {
        List<FieldSchema> partCols = table.getPartitionKeys();
        int numPartKeys = partCols.size();
        if (partVals.size() > numPartKeys) {
            throw new MetaException("Incorrect number of partition values. numPartKeys=" + numPartKeys + ", part_val=" + partVals);
        }
        partCols = partCols.subList(0, partVals.size());
        String partNameMatcher = Warehouse.makePartName(partCols, partVals, defaultStr);
        if (partVals.size() < numPartKeys) {
            partNameMatcher = partNameMatcher + defaultStr;
        }
        return partNameMatcher;
    }

    public static boolean compareFieldColumns(List<FieldSchema> schema1, List<FieldSchema> schema2) {
        if (schema1.size() != schema2.size()) {
            return false;
        }
        Iterator<FieldSchema> its1 = schema1.iterator();
        Iterator<FieldSchema> its2 = schema2.iterator();
        while (its1.hasNext()) {
            FieldSchema f1 = its1.next();
            FieldSchema f2 = its2.next();
            if (StringUtils.equals((CharSequence)f1.getName(), (CharSequence)f2.getName()) && StringUtils.equals((CharSequence)f1.getType(), (CharSequence)f2.getType())) continue;
            return false;
        }
        return true;
    }

    public static boolean isArchived(Partition part) {
        Map<String, String> params = part.getParameters();
        return params != null && "TRUE".equalsIgnoreCase(params.get("is_archived"));
    }

    public static Path getOriginalLocation(Partition part) {
        Map<String, String> params = part.getParameters();
        assert (MetaStoreUtils.isArchived(part));
        String originalLocation = params.get("original_location");
        assert (originalLocation != null);
        return new Path(originalLocation);
    }

    public static int getArchivingLevel(Partition part) throws MetaException {
        if (!MetaStoreUtils.isArchived(part)) {
            throw new MetaException("Getting level of unarchived partition");
        }
        String lv = part.getParameters().get(ARCHIVING_LEVEL);
        if (lv != null) {
            return Integer.parseInt(lv);
        }
        return part.getValues().size();
    }

    public static Map<String, String> getMetaStoreSaslProperties(Configuration conf, boolean useSSL) {
        String hadoopRpcProtectionVal = conf.get("hadoop.rpc.protection");
        String hadoopRpcProtectionAuth = SaslRpcServer.QualityOfProtection.AUTHENTICATION.toString();
        if (useSSL && hadoopRpcProtectionVal != null && !hadoopRpcProtectionVal.equals(hadoopRpcProtectionAuth)) {
            LOG.warn("Overriding value of hadoop.rpc.protection setting it from " + hadoopRpcProtectionVal + " to " + hadoopRpcProtectionAuth + " because SSL is enabled");
            conf.set("hadoop.rpc.protection", hadoopRpcProtectionAuth);
        }
        return HadoopThriftAuthBridge.getBridge().getHadoopSaslProperties(conf);
    }

    private static List<URL> getCurrentClassPaths(ClassLoader parentLoader) {
        if (parentLoader instanceof URLClassLoader) {
            return Lists.newArrayList((Object[])((URLClassLoader)parentLoader).getURLs());
        }
        return Collections.emptyList();
    }

    public static ClassLoader addToClassPath(final ClassLoader cloader, String[] newPaths) throws Exception {
        final List<URL> curPath = MetaStoreUtils.getCurrentClassPaths(cloader);
        for (String onestr : newPaths) {
            URL oneurl = MetaStoreUtils.urlFromPathString(onestr);
            if (oneurl == null || curPath.contains(oneurl)) continue;
            curPath.add(oneurl);
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new URLClassLoader(curPath.toArray(new URL[0]), cloader);
            }
        });
    }

    private static URL urlFromPathString(String onestr) {
        URL oneurl = null;
        try {
            oneurl = onestr.startsWith("file:/") ? new URL(onestr) : new File(onestr).toURL();
        }
        catch (Exception err) {
            LOG.error("Bad URL " + onestr + ", ignoring path");
        }
        return oneurl;
    }

    public static String getDDLFromFieldSchema(String structName, List<FieldSchema> fieldSchemas) {
        StringBuilder ddl = new StringBuilder();
        ddl.append("struct ");
        ddl.append(structName);
        ddl.append(" { ");
        boolean first = true;
        for (FieldSchema col : fieldSchemas) {
            if (first) {
                first = false;
            } else {
                ddl.append(", ");
            }
            ddl.append(ColumnType.typeToThriftType(col.getType()));
            ddl.append(' ');
            ddl.append(col.getName());
        }
        ddl.append("}");
        LOG.trace("DDL: {}", (Object)ddl);
        return ddl.toString();
    }

    public static Properties getTableMetadata(Table table) {
        return MetaStoreUtils.getSchema(table.getSd(), table.getSd(), table.getParameters(), table.getDbName(), table.getTableName(), table.getPartitionKeys());
    }

    public static Properties getPartitionMetadata(Partition partition, Table table) {
        return MetaStoreUtils.getSchema(partition.getSd(), partition.getSd(), partition.getParameters(), table.getDbName(), table.getTableName(), table.getPartitionKeys());
    }

    public static Properties getSchema(Partition part, Table table) {
        return MetaStoreUtils.getSchema(part.getSd(), table.getSd(), table.getParameters(), table.getDbName(), table.getTableName(), table.getPartitionKeys());
    }

    public static Properties getPartSchemaFromTableSchema(StorageDescriptor sd, Map<String, String> parameters, Properties tblSchema) {
        Properties schema = (Properties)tblSchema.clone();
        String inputFormat = sd.getInputFormat();
        if (inputFormat == null || inputFormat.length() == 0) {
            String tblInput = schema.getProperty("file.inputformat");
            inputFormat = tblInput == null ? SequenceFileInputFormat.class.getName() : tblInput;
        }
        schema.setProperty("file.inputformat", inputFormat);
        String outputFormat = sd.getOutputFormat();
        if (outputFormat == null || outputFormat.length() == 0) {
            String tblOutput = schema.getProperty("file.outputformat");
            outputFormat = tblOutput == null ? SequenceFileOutputFormat.class.getName() : tblOutput;
        }
        schema.setProperty("file.outputformat", outputFormat);
        if (sd.getLocation() != null) {
            schema.setProperty("location", sd.getLocation());
        }
        schema.setProperty("bucket_count", Integer.toString(sd.getNumBuckets()));
        if (sd.getBucketCols() != null && sd.getBucketCols().size() > 0) {
            schema.setProperty("bucket_field_name", Joiner.on((String)",").join(sd.getBucketCols()));
        }
        if (sd.getSerdeInfo() != null) {
            String cols = "columns";
            String colTypes = "columns.types";
            String parts = "partition_columns";
            for (Map.Entry<String, String> param : sd.getSerdeInfo().getParameters().entrySet()) {
                String key = param.getKey();
                if (schema.get(key) != null && (key.equals(cols) || key.equals(colTypes) || key.equals(parts) || key.startsWith("druid.") || key.startsWith("hive.sql."))) continue;
                schema.put(key, param.getValue() != null ? param.getValue() : "");
            }
            if (sd.getSerdeInfo().getSerializationLib() != null) {
                schema.setProperty("serialization.lib", sd.getSerdeInfo().getSerializationLib());
            }
        }
        if (parameters != null) {
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                schema.setProperty(e.getKey(), e.getValue());
            }
        }
        return schema;
    }

    private static Properties addCols(Properties schema, List<FieldSchema> cols) {
        StringBuilder colNameBuf = new StringBuilder();
        StringBuilder colTypeBuf = new StringBuilder();
        StringBuilder colComment = new StringBuilder();
        boolean first = true;
        String columnNameDelimiter = MetaStoreUtils.getColumnNameDelimiter(cols);
        for (FieldSchema col : cols) {
            if (!first) {
                colNameBuf.append(columnNameDelimiter);
                colTypeBuf.append(":");
                colComment.append('\u0000');
            }
            colNameBuf.append(col.getName());
            colTypeBuf.append(col.getType());
            colComment.append(null != col.getComment() ? col.getComment() : "");
            first = false;
        }
        schema.setProperty("columns", colNameBuf.toString());
        schema.setProperty("column.name.delimiter", columnNameDelimiter);
        String colTypes = colTypeBuf.toString();
        schema.setProperty("columns.types", colTypes);
        schema.setProperty("columns.comments", colComment.toString());
        return schema;
    }

    public static Properties getSchemaWithoutCols(StorageDescriptor sd, Map<String, String> parameters, String databaseName, String tableName, List<FieldSchema> partitionKeys) {
        int bucket_cnt;
        Properties schema = new Properties();
        String inputFormat = sd.getInputFormat();
        if (inputFormat == null || inputFormat.length() == 0) {
            inputFormat = SequenceFileInputFormat.class.getName();
        }
        schema.setProperty("file.inputformat", inputFormat);
        String outputFormat = sd.getOutputFormat();
        if (outputFormat == null || outputFormat.length() == 0) {
            outputFormat = SequenceFileOutputFormat.class.getName();
        }
        schema.setProperty("file.outputformat", outputFormat);
        schema.setProperty("name", databaseName + "." + tableName);
        if (sd.getLocation() != null) {
            schema.setProperty("location", sd.getLocation());
        }
        if ((bucket_cnt = sd.getNumBuckets()) > 0) {
            schema.setProperty("bucket_count", Integer.toString(bucket_cnt));
        }
        if (sd.getBucketCols() != null && sd.getBucketCols().size() > 0) {
            schema.setProperty("bucket_field_name", Joiner.on((String)",").join(sd.getBucketCols()));
        }
        if (sd.getSerdeInfo() != null) {
            for (Map.Entry<String, String> param : sd.getSerdeInfo().getParameters().entrySet()) {
                schema.put(param.getKey(), param.getValue() != null ? param.getValue() : "");
            }
            if (sd.getSerdeInfo().getSerializationLib() != null) {
                schema.setProperty("serialization.lib", sd.getSerdeInfo().getSerializationLib());
            }
        }
        if (partitionKeys != null) {
            String partString = "";
            String partStringSep = "";
            String partTypesString = "";
            String partTypesStringSep = "";
            for (FieldSchema partKey : partitionKeys) {
                partString = partString.concat(partStringSep);
                partString = partString.concat(partKey.getName());
                partTypesString = partTypesString.concat(partTypesStringSep);
                partTypesString = partTypesString.concat(partKey.getType());
                if (partStringSep.length() != 0) continue;
                partStringSep = "/";
                partTypesStringSep = ":";
            }
            if (partString.length() > 0) {
                schema.setProperty("partition_columns", partString);
                schema.setProperty("partition_columns.types", partTypesString);
            }
        }
        if (parameters != null) {
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                String key = e.getKey();
                if ("COLUMN_STATS_ACCURATE".equals(key) || "transient_lastDdlTime".equals(key) || "totalSize".equals(key) || "rawDataSize".equals(key) || "numFiles".equals(key) || "numRows".equals(key) || e.getValue() == null) continue;
                schema.setProperty(e.getKey(), e.getValue());
            }
        }
        return schema;
    }

    public static Properties getSchema(StorageDescriptor sd, StorageDescriptor tblsd, Map<String, String> parameters, String databaseName, String tableName, List<FieldSchema> partitionKeys) {
        return MetaStoreUtils.addCols(MetaStoreUtils.getSchemaWithoutCols(sd, parameters, databaseName, tableName, partitionKeys), tblsd.getCols());
    }

    public static String getColumnNameDelimiter(List<FieldSchema> fieldSchemas) {
        for (int i = 0; i < fieldSchemas.size(); ++i) {
            if (!fieldSchemas.get(i).getName().contains(",")) continue;
            return String.valueOf('\u0000');
        }
        return String.valueOf(',');
    }

    public static String getColumnNamesFromFieldSchema(List<FieldSchema> fieldSchemas) {
        String delimiter = MetaStoreUtils.getColumnNameDelimiter(fieldSchemas);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldSchemas.size(); ++i) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(fieldSchemas.get(i).getName());
        }
        return sb.toString();
    }

    public static String getColumnTypesFromFieldSchema(List<FieldSchema> fieldSchemas, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldSchemas.size(); ++i) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(fieldSchemas.get(i).getType());
        }
        return sb.toString();
    }

    public static String getColumnTypesFromFieldSchema(List<FieldSchema> fieldSchemas) {
        return MetaStoreUtils.getColumnTypesFromFieldSchema(fieldSchemas, ",");
    }

    public static String getColumnCommentsFromFieldSchema(List<FieldSchema> fieldSchemas) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldSchemas.size(); ++i) {
            if (i > 0) {
                sb.append('\u0000');
            }
            sb.append(fieldSchemas.get(i).getComment());
        }
        return sb.toString();
    }

    public static boolean isMaterializedViewTable(Table table) {
        if (table == null) {
            return false;
        }
        return TableType.MATERIALIZED_VIEW.toString().equals(table.getTableType());
    }

    public static List<String> getColumnNames(List<FieldSchema> schema) {
        ArrayList<String> cols = new ArrayList<String>(schema.size());
        for (FieldSchema fs : schema) {
            cols.add(fs.getName());
        }
        return cols;
    }

    public static boolean isValidSchedulingPolicy(String str) {
        try {
            MetaStoreUtils.parseSchedulingPolicy(str);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static WMPoolSchedulingPolicy parseSchedulingPolicy(String schedulingPolicy) {
        if (schedulingPolicy == null) {
            return WMPoolSchedulingPolicy.FAIR;
        }
        if ("DEFAULT".equals(schedulingPolicy = schedulingPolicy.trim().toUpperCase())) {
            return WMPoolSchedulingPolicy.FAIR;
        }
        return Enum.valueOf(WMPoolSchedulingPolicy.class, schedulingPolicy);
    }

    private static boolean hasCatalogName(String dbName) {
        return dbName != null && dbName.length() > 0 && dbName.charAt(0) == '@';
    }

    public static String prependCatalogToDbName(@Nullable String catalogName, @Nullable String dbName, Configuration conf) {
        if (catalogName == null) {
            catalogName = MetaStoreUtils.getDefaultCatalog(conf);
        }
        StringBuilder buf = new StringBuilder().append('@').append(catalogName).append(CATALOG_DB_SEPARATOR);
        if (dbName != null) {
            if (dbName.isEmpty()) {
                buf.append(DB_EMPTY_MARKER);
            } else {
                buf.append(dbName);
            }
        }
        return buf.toString();
    }

    public static String prependNotNullCatToDbName(String catalogName, String dbName) {
        assert (catalogName != null);
        return MetaStoreUtils.prependCatalogToDbName(catalogName, dbName, null);
    }

    public static String prependCatalogToDbName(String dbName, Configuration conf) {
        return MetaStoreUtils.prependCatalogToDbName(null, dbName, conf);
    }

    public static String[] parseDbName(String dbName, Configuration conf) throws MetaException {
        if (dbName == null) {
            return Arrays.copyOf(nullCatalogAndDatabase, nullCatalogAndDatabase.length);
        }
        if (MetaStoreUtils.hasCatalogName(dbName)) {
            if (dbName.endsWith(CATALOG_DB_SEPARATOR)) {
                return new String[]{dbName.substring(1, dbName.length() - 1), null};
            }
            if (dbName.endsWith(DB_EMPTY_MARKER)) {
                return new String[]{dbName.substring(1, dbName.length() - DB_EMPTY_MARKER.length() - 1), ""};
            }
            String[] names = dbName.substring(1).split(CATALOG_DB_SEPARATOR, 2);
            if (names.length != 2) {
                throw new MetaException(dbName + " is prepended with the catalog marker but does not appear to have a catalog name in it");
            }
            return names;
        }
        return new String[]{MetaStoreUtils.getDefaultCatalog(conf), dbName};
    }

    public static String getDefaultCatalog(Configuration conf) {
        if (conf == null) {
            LOG.warn("Configuration is null, so going with default catalog.");
            return "hive";
        }
        String catName = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.CATALOG_DEFAULT);
        if (catName == null || "".equals(catName)) {
            catName = "hive";
        }
        return catName;
    }

    public static boolean isView(Table table) {
        if (table == null) {
            return false;
        }
        return TableType.VIRTUAL_VIEW.toString().equals(table.getTableType());
    }

    public static <T> void filterMapKeys(Map<String, T> map, Predicate<String> predicate) {
        if (map == null) {
            return;
        }
        map.entrySet().removeIf(entry -> predicate.test((String)entry.getKey()));
    }

    public static <T> void filterMapkeys(Map<String, T> map, List<Predicate<String>> predicates) {
        if (map == null) {
            return;
        }
        MetaStoreUtils.filterMapKeys(map, predicates.stream().reduce(Predicate::or).orElse(x -> false));
    }

    public static List<Predicate<String>> compilePatternsToPredicates(List<String> patterns) {
        return patterns.stream().map(pattern -> Pattern.compile(pattern).asPredicate()).collect(Collectors.toList());
    }

    public static List<Object[]> makeOrderSpecs(String order) {
        if (StringUtils.isBlank((CharSequence)order) || order.split(":").length != 2) {
            return new ArrayList<Object[]>();
        }
        String[] parts = order.split(":");
        String[] poses = parts[0].split(",");
        char[] chars = parts[1].toCharArray();
        ArrayList<Object[]> orderSpecs = new ArrayList<Object[]>(chars.length);
        if (poses.length != chars.length) {
            throw new IllegalArgumentException("The length of partition keys and sort order do not mismatch, order: " + order);
        }
        for (int i = 0; i < poses.length; ++i) {
            Object[] spec = new Object[]{Integer.parseInt(poses[i]), '+' == chars[i] ? "ASC" : "DESC"};
            orderSpecs.add(spec);
        }
        return orderSpecs;
    }

    public static void addPartitonSpecsToList(PartitionsSpecByExprResult r, List<PartitionSpec> result) {
        result.addAll(r.getPartitionsSpec());
    }

    public static boolean hasUnknownPartitions(PartitionsSpecByExprResult r) {
        return !r.isSetHasUnknownPartitions() || r.isHasUnknownPartitions();
    }

    public static TableName getTableNameFor(Table table) {
        return TableName.fromString((String)table.getTableName().toLowerCase(), (String)table.getCatName().toLowerCase(), (String)table.getDbName().toLowerCase(), null);
    }

    public static boolean isNoAutoCompactSet(Map<String, String> dbParameters, Map<String, String> tblParameters) {
        String dbNoAutoCompact = MetaStoreUtils.getNoAutoCompact(dbParameters);
        if (dbNoAutoCompact == null) {
            LOG.debug("Using table configuration 'no_auto_compaction' for compaction");
            String noAutoCompact = MetaStoreUtils.getNoAutoCompact(tblParameters);
            return Boolean.parseBoolean(noAutoCompact);
        }
        LOG.debug("Using database configuration 'no_auto_compaction' for compaction");
        return Boolean.parseBoolean(dbNoAutoCompact);
    }

    public static String getNoAutoCompact(Map<String, String> parameters) {
        String noAutoCompact = parameters.get("no_auto_compaction");
        if (noAutoCompact == null) {
            return parameters.get("no_auto_compaction".toUpperCase());
        }
        return noAutoCompact;
    }

    public static String getHostFromId(String id) {
        if (id == null) {
            return NO_VAL;
        }
        int lastDash = id.lastIndexOf(45);
        return id.substring(0, lastDash > -1 ? lastDash : id.length());
    }

    public static String getThreadIdFromId(String id) {
        if (id == null) {
            return NO_VAL;
        }
        return id.substring(id.lastIndexOf(45) + 1);
    }

    public static boolean isNoCleanUpSet(Map<String, String> parameters) {
        String noCleanUp = parameters.get("no_cleanup");
        if (noCleanUp == null) {
            noCleanUp = parameters.get("no_cleanup".toUpperCase());
        }
        return noCleanUp != null && noCleanUp.equalsIgnoreCase("true");
    }

    public static GetPartitionsByNamesRequest convertToGetPartitionsByNamesRequest(String dbName, String tblName, List<String> partNames) {
        GetPartitionsByNamesRequest result = new GetPartitionsByNamesRequest(dbName, tblName);
        result.setNames(partNames);
        result.setGet_col_stats(false);
        return result;
    }

    public static GetPartitionsByNamesRequest convertToGetPartitionsByNamesRequest(String dbName, String tblName, List<String> partNames, boolean getColStats, String engine, String validWriteIdList, Long tableId) {
        GetPartitionsByNamesRequest result = new GetPartitionsByNamesRequest(dbName, tblName);
        result.setNames(partNames);
        result.setGet_col_stats(getColStats);
        result.setEngine(engine);
        result.setValidWriteIdList(validWriteIdList);
        if (tableId != null) {
            result.setId(tableId);
        }
        return result;
    }

    public static <T> T createThriftPartitionsReq(Class<T> clazz, Configuration conf, T ... deepCopy) {
        T req;
        if (deepCopy != null && deepCopy.length == 1) {
            assert (clazz.isAssignableFrom(deepCopy[0].getClass()));
            req = JavaUtils.newInstance(clazz, new Class[]{clazz}, deepCopy);
        } else {
            req = JavaUtils.newInstance(clazz);
        }
        JavaUtils.setField(req, "setSkipColumnSchemaForPartition", new Class[]{Boolean.TYPE}, MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.METASTORE_CLIENT_FIELD_SCHEMA_FOR_PARTITIONS));
        JavaUtils.setField(req, "setIncludeParamKeyPattern", new Class[]{String.class}, MetastoreConf.getAsString(conf, MetastoreConf.ConfVars.METASTORE_PARTITIONS_PARAMETERS_INCLUDE_PATTERN));
        JavaUtils.setField(req, "setExcludeParamKeyPattern", new Class[]{String.class}, MetastoreConf.getAsString(conf, MetastoreConf.ConfVars.METASTORE_PARTITIONS_PARAMETERS_EXCLUDE_PATTERN));
        return req;
    }

    public static String getHttpPath(String httpPath) {
        if (httpPath == null || httpPath.equals("")) {
            httpPath = "/*";
        } else {
            if (!httpPath.startsWith("/")) {
                httpPath = "/" + httpPath;
            }
            if (httpPath.endsWith("/")) {
                httpPath = httpPath + "*";
            }
            if (!httpPath.endsWith("/*")) {
                httpPath = httpPath + "/*";
            }
        }
        return httpPath;
    }

    public static enum FailoverEndpoint {
        SOURCE,
        TARGET;

    }
}

