/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DefaultMetaStoreFilterHookImpl;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreFilterHook;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MetastoreUnitTest.class})
public class TestFilterHooks {
    private static final Logger LOG = LoggerFactory.getLogger(TestFilterHooks.class);
    private static final String DBNAME1 = "testdb1";
    private static final String DBNAME2 = "testdb2";
    private static final String TAB1 = "tab1";
    private static final String TAB2 = "tab2";
    private static Configuration conf;
    private static HiveMetaStoreClient msc;

    @BeforeClass
    public static void setUp() throws Exception {
        DummyMetaStoreFilterHookImpl.blockResults = false;
        conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES, (long)3L);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        MetastoreConf.setClass((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.FILTER_HOOK, DummyMetaStoreFilterHookImpl.class, MetaStoreFilterHook.class);
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), conf);
        msc = new HiveMetaStoreClient(conf);
        msc.dropDatabase(DBNAME1, true, true, true);
        msc.dropDatabase(DBNAME2, true, true, true);
        Database db1 = new DatabaseBuilder().setName(DBNAME1).setCatalogName("hive").create((IMetaStoreClient)msc, conf);
        Database db2 = new DatabaseBuilder().setName(DBNAME2).setCatalogName("hive").create((IMetaStoreClient)msc, conf);
        ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(DBNAME1).setTableName(TAB1).addCol("id", "int")).addCol("name", "string")).create((IMetaStoreClient)msc, conf);
        Table tab2 = ((TableBuilder)new TableBuilder().setDbName(DBNAME1).setTableName(TAB2).addCol("id", "int")).addPartCol("name", "string").create((IMetaStoreClient)msc, conf);
        new PartitionBuilder().inTable(tab2).addValue("value1").addToTable((IMetaStoreClient)msc, conf);
        new PartitionBuilder().inTable(tab2).addValue("value2").addToTable((IMetaStoreClient)msc, conf);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        msc.close();
    }

    @Test
    public void testDefaultFilter() throws Exception {
        Assert.assertNotNull((Object)msc.getTable(DBNAME1, TAB1));
        Assert.assertEquals((long)2L, (long)msc.getTables(DBNAME1, "*").size());
        Assert.assertEquals((long)2L, (long)msc.getAllTables(DBNAME1).size());
        Assert.assertEquals((long)1L, (long)msc.getTables(DBNAME1, TAB2).size());
        Assert.assertEquals((long)0L, (long)msc.getAllTables(DBNAME2).size());
        Assert.assertNotNull((Object)msc.getDatabase(DBNAME1));
        Assert.assertEquals((long)3L, (long)msc.getDatabases("*").size());
        Assert.assertEquals((long)3L, (long)msc.getAllDatabases().size());
        Assert.assertEquals((long)1L, (long)msc.getDatabases(DBNAME1).size());
        Assert.assertNotNull((Object)msc.getPartition(DBNAME1, TAB2, "name=value1"));
        Assert.assertEquals((long)1L, (long)msc.getPartitionsByNames(DBNAME1, TAB2, (List)Lists.newArrayList((Object[])new String[]{"name=value1"})).size());
    }

    @Test
    public void testDummyFilterForTables() throws Exception {
        DummyMetaStoreFilterHookImpl.blockResults = true;
        try {
            msc.getTable(DBNAME1, TAB1);
            Assert.fail((String)"getTable() should fail with blocking mode");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)msc.getTables(DBNAME1, "*").size());
        Assert.assertEquals((long)0L, (long)msc.getAllTables(DBNAME1).size());
        Assert.assertEquals((long)0L, (long)msc.getTables(DBNAME1, TAB2).size());
    }

    @Test
    public void testDummyFilterForDb() throws Exception {
        DummyMetaStoreFilterHookImpl.blockResults = true;
        try {
            Assert.assertNotNull((Object)msc.getDatabase(DBNAME1));
            Assert.fail((String)"getDatabase() should fail with blocking mode");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)msc.getDatabases("*").size());
        Assert.assertEquals((long)0L, (long)msc.getAllDatabases().size());
        Assert.assertEquals((long)0L, (long)msc.getDatabases(DBNAME1).size());
    }

    @Test
    public void testDummyFilterForPartition() throws Exception {
        DummyMetaStoreFilterHookImpl.blockResults = true;
        try {
            Assert.assertNotNull((Object)msc.getPartition(DBNAME1, TAB2, "name=value1"));
            Assert.fail((String)"getPartition() should fail with blocking mode");
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)msc.getPartitionsByNames(DBNAME1, TAB2, (List)Lists.newArrayList((Object[])new String[]{"name=value1"})).size());
    }

    public static class DummyMetaStoreFilterHookImpl
    extends DefaultMetaStoreFilterHookImpl {
        private static boolean blockResults = false;

        public DummyMetaStoreFilterHookImpl(Configuration conf) {
            super(conf);
        }

        public List<String> filterDatabases(List<String> dbList) throws MetaException {
            if (blockResults) {
                return new ArrayList<String>();
            }
            return super.filterDatabases(dbList);
        }

        public Database filterDatabase(Database dataBase) throws NoSuchObjectException {
            if (blockResults) {
                throw new NoSuchObjectException("Blocked access");
            }
            return super.filterDatabase(dataBase);
        }

        public List<String> filterTableNames(String catName, String dbName, List<String> tableList) throws MetaException {
            if (blockResults) {
                return new ArrayList<String>();
            }
            return super.filterTableNames(catName, dbName, tableList);
        }

        public Table filterTable(Table table) throws NoSuchObjectException {
            if (blockResults) {
                throw new NoSuchObjectException("Blocked access");
            }
            return super.filterTable(table);
        }

        public List<Table> filterTables(List<Table> tableList) throws MetaException {
            if (blockResults) {
                return new ArrayList<Table>();
            }
            return super.filterTables(tableList);
        }

        public List<Partition> filterPartitions(List<Partition> partitionList) throws MetaException {
            if (blockResults) {
                return new ArrayList<Partition>();
            }
            return super.filterPartitions(partitionList);
        }

        public List<PartitionSpec> filterPartitionSpecs(List<PartitionSpec> partitionSpecList) throws MetaException {
            if (blockResults) {
                return new ArrayList<PartitionSpec>();
            }
            return super.filterPartitionSpecs(partitionSpecList);
        }

        public Partition filterPartition(Partition partition) throws NoSuchObjectException {
            if (blockResults) {
                throw new NoSuchObjectException("Blocked access");
            }
            return super.filterPartition(partition);
        }

        public List<String> filterPartitionNames(String catName, String dbName, String tblName, List<String> partitionNames) throws MetaException {
            if (blockResults) {
                return new ArrayList<String>();
            }
            return super.filterPartitionNames(catName, dbName, tblName, partitionNames);
        }
    }
}

