/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.MockPartitionExpressionForMetastore;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.util.StringUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreCheckinTest.class})
public class TestHiveMetaStoreTimeout {
    protected static HiveMetaStoreClient client;
    protected static Configuration conf;
    protected static Warehouse warehouse;

    @BeforeClass
    public static void setUp() throws Exception {
        HiveMetaStore.TEST_TIMEOUT_ENABLED = true;
        conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setClass((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS, MockPartitionExpressionForMetastore.class, PartitionExpressionProxy.class);
        MetastoreConf.setTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CLIENT_SOCKET_TIMEOUT, (long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        warehouse = new Warehouse(conf);
        client = new HiveMetaStoreClient(conf);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        HiveMetaStore.TEST_TIMEOUT_ENABLED = false;
        try {
            client.close();
        }
        catch (Throwable e) {
            System.err.println("Unable to close metastore");
            System.err.println(StringUtils.stringifyException((Throwable)e));
            throw e;
        }
    }

    @Test
    public void testNoTimeout() throws Exception {
        HiveMetaStore.TEST_TIMEOUT_VALUE = 250L;
        String dbName = "db";
        client.dropDatabase(dbName, true, true);
        new DatabaseBuilder().setName(dbName).create((IMetaStoreClient)client, conf);
        client.dropDatabase(dbName, true, true);
    }

    @Test
    public void testTimeout() throws Exception {
        HiveMetaStore.TEST_TIMEOUT_VALUE = 2000L;
        String dbName = "db";
        client.dropDatabase(dbName, true, true);
        Database db = new DatabaseBuilder().setName(dbName).build(conf);
        try {
            client.createDatabase(db);
            Assert.fail((String)"should throw timeout exception.");
        }
        catch (MetaException e) {
            Assert.assertTrue((String)"unexpected MetaException", (boolean)e.getMessage().contains("Timeout when executing method: create_database"));
        }
        HiveMetaStore.TEST_TIMEOUT_VALUE = 1L;
    }

    @Test
    public void testResetTimeout() throws Exception {
        HiveMetaStore.TEST_TIMEOUT_VALUE = 250L;
        String dbName = "db";
        client.dropDatabase(dbName, true, true);
        Database db = new DatabaseBuilder().setName(dbName).build(conf);
        try {
            client.createDatabase(db);
        }
        catch (MetaException e) {
            Assert.fail((String)("should not throw timeout exception: " + e.getMessage()));
        }
        client.dropDatabase(dbName, true, true);
        HiveMetaStore.TEST_TIMEOUT_VALUE = 2000L;
        client.setMetaConf(MetastoreConf.ConfVars.CLIENT_SOCKET_TIMEOUT.getVarname(), "1s");
        try {
            client.createDatabase(db);
            Assert.fail((String)"should throw timeout exception.");
        }
        catch (MetaException e) {
            Assert.assertTrue((String)"unexpected MetaException", (boolean)e.getMessage().contains("Timeout when executing method: create_database"));
        }
        client.dropDatabase(dbName, true, true);
        client.setMetaConf(MetastoreConf.ConfVars.CLIENT_SOCKET_TIMEOUT.getVarname(), "10s");
    }
}

