/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.client.MetaStoreFactoryForTests;
import org.apache.hadoop.hive.metastore.client.TestDatabases;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public abstract class MetaStoreClientTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestDatabases.class);
    private static Set<AbstractMetaStoreService> metaStoreServices = null;

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> getMetaStoreToTest() throws Exception {
        List<Object[]> result = MetaStoreFactoryForTests.getMetaStores();
        metaStoreServices = result.stream().map(test -> (AbstractMetaStoreService)test[1]).collect(Collectors.toSet());
        return result;
    }

    @BeforeClass
    public static void startMetaStores() {
        MetaStoreClientTest.startMetaStores(new HashMap<MetastoreConf.ConfVars, String>(), new HashMap<String, String>());
    }

    public static void startMetaStores(Map<MetastoreConf.ConfVars, String> msConf, Map<String, String> extraConf) {
        for (AbstractMetaStoreService metaStoreService : metaStoreServices) {
            try {
                metaStoreService.start(msConf, extraConf);
            }
            catch (Exception e) {
                LOG.error("Error starting MetaStoreService", (Throwable)e);
            }
        }
    }

    @AfterClass
    public static void stopMetaStores() {
        for (AbstractMetaStoreService metaStoreService : metaStoreServices) {
            try {
                metaStoreService.stop();
            }
            catch (Exception e) {
                LOG.error("Error stopping MetaStoreService", (Throwable)e);
            }
        }
    }
}

