/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.util.List;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsRequest;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.SQLUniqueConstraintBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestUniqueConstraint
extends MetaStoreClientTest {
    private static final String OTHER_DATABASE = "test_uc_other_database";
    private static final String OTHER_CATALOG = "test_uc_other_catalog";
    private static final String DATABASE_IN_OTHER_CATALOG = "test_uc_database_in_other_catalog";
    private final AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    private Table[] testTables = new Table[3];
    private Database inOtherCatalog;

    public TestUniqueConstraint(String name, AbstractMetaStoreService metaStore) throws Exception {
        this.metaStore = metaStore;
        this.metaStore.start();
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        this.client.dropDatabase(OTHER_DATABASE, true, true, true);
        for (String tableName : this.client.getAllTables("default")) {
            this.client.dropTable("default", tableName, true, true, true);
        }
        this.client.dropDatabase(OTHER_CATALOG, DATABASE_IN_OTHER_CATALOG, true, true, true);
        try {
            this.client.dropCatalog(OTHER_CATALOG);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        this.metaStore.cleanWarehouseDirs();
        new DatabaseBuilder().setName(OTHER_DATABASE).create(this.client, this.metaStore.getConf());
        Catalog cat = new CatalogBuilder().setName(OTHER_CATALOG).setLocation(MetaStoreTestUtils.getTestWarehouseDir(OTHER_CATALOG)).build();
        this.client.createCatalog(cat);
        this.inOtherCatalog = new DatabaseBuilder().setName(DATABASE_IN_OTHER_CATALOG).setCatalogName(OTHER_CATALOG).create(this.client, this.metaStore.getConf());
        this.testTables[0] = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName("test_table_1").addCol("col1", "int")).addCol("col2", "varchar(32)")).create(this.client, this.metaStore.getConf());
        this.testTables[1] = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(OTHER_DATABASE).setTableName("test_table_2").addCol("col1", "int")).addCol("col2", "varchar(32)")).create(this.client, this.metaStore.getConf());
        this.testTables[2] = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(this.inOtherCatalog).setTableName("test_table_3").addCol("col1", "int")).addCol("col2", "varchar(32)")).create(this.client, this.metaStore.getConf());
        for (int i = 0; i < this.testTables.length; ++i) {
            this.testTables[i] = this.client.getTable(this.testTables[i].getCatName(), this.testTables[i].getDbName(), this.testTables[i].getTableName());
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        finally {
            this.client = null;
        }
    }

    @Test
    public void createGetDrop() throws TException {
        Table table = this.testTables[0];
        UniqueConstraintsRequest rqst = new UniqueConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        List fetched = this.client.getUniqueConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
        List uc = ((SQLUniqueConstraintBuilder)((SQLUniqueConstraintBuilder)new SQLUniqueConstraintBuilder().onTable(table)).addColumn("col1")).build(this.metaStore.getConf());
        this.client.addUniqueConstraint(uc);
        rqst = new UniqueConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        fetched = this.client.getUniqueConstraints(rqst);
        Assert.assertEquals((long)1L, (long)fetched.size());
        Assert.assertEquals((Object)table.getDbName(), (Object)((SQLUniqueConstraint)fetched.get(0)).getTable_db());
        Assert.assertEquals((Object)table.getTableName(), (Object)((SQLUniqueConstraint)fetched.get(0)).getTable_name());
        Assert.assertEquals((Object)"col1", (Object)((SQLUniqueConstraint)fetched.get(0)).getColumn_name());
        Assert.assertEquals((long)1L, (long)((SQLUniqueConstraint)fetched.get(0)).getKey_seq());
        Assert.assertEquals((Object)(table.getTableName() + "_unique_constraint"), (Object)((SQLUniqueConstraint)fetched.get(0)).getUk_name());
        String table0PkName = ((SQLUniqueConstraint)fetched.get(0)).getUk_name();
        Assert.assertTrue((boolean)((SQLUniqueConstraint)fetched.get(0)).isEnable_cstr());
        Assert.assertFalse((boolean)((SQLUniqueConstraint)fetched.get(0)).isValidate_cstr());
        Assert.assertFalse((boolean)((SQLUniqueConstraint)fetched.get(0)).isRely_cstr());
        Assert.assertEquals((Object)table.getCatName(), (Object)((SQLUniqueConstraint)fetched.get(0)).getCatName());
        this.client.dropConstraint(table.getCatName(), table.getDbName(), table.getTableName(), table0PkName);
        rqst = new UniqueConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        fetched = this.client.getUniqueConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
        this.client.addUniqueConstraint(uc);
    }

    @Test
    public void inOtherCatalog() throws TException {
        String constraintName = "ocuc";
        List uc = ((SQLUniqueConstraintBuilder)((SQLUniqueConstraintBuilder)((SQLUniqueConstraintBuilder)new SQLUniqueConstraintBuilder().onTable(this.testTables[2])).addColumn("col1")).setConstraintName(constraintName)).build(this.metaStore.getConf());
        this.client.addUniqueConstraint(uc);
        UniqueConstraintsRequest rqst = new UniqueConstraintsRequest(this.testTables[2].getCatName(), this.testTables[2].getDbName(), this.testTables[2].getTableName());
        List fetched = this.client.getUniqueConstraints(rqst);
        Assert.assertEquals((long)1L, (long)fetched.size());
        Assert.assertEquals((Object)this.testTables[2].getDbName(), (Object)((SQLUniqueConstraint)fetched.get(0)).getTable_db());
        Assert.assertEquals((Object)this.testTables[2].getTableName(), (Object)((SQLUniqueConstraint)fetched.get(0)).getTable_name());
        Assert.assertEquals((Object)"col1", (Object)((SQLUniqueConstraint)fetched.get(0)).getColumn_name());
        Assert.assertEquals((long)1L, (long)((SQLUniqueConstraint)fetched.get(0)).getKey_seq());
        Assert.assertEquals((Object)constraintName, (Object)((SQLUniqueConstraint)fetched.get(0)).getUk_name());
        Assert.assertTrue((boolean)((SQLUniqueConstraint)fetched.get(0)).isEnable_cstr());
        Assert.assertFalse((boolean)((SQLUniqueConstraint)fetched.get(0)).isValidate_cstr());
        Assert.assertFalse((boolean)((SQLUniqueConstraint)fetched.get(0)).isRely_cstr());
        Assert.assertEquals((Object)this.testTables[2].getCatName(), (Object)((SQLUniqueConstraint)fetched.get(0)).getCatName());
        this.client.dropConstraint(this.testTables[2].getCatName(), this.testTables[2].getDbName(), this.testTables[2].getTableName(), constraintName);
        rqst = new UniqueConstraintsRequest(this.testTables[2].getCatName(), this.testTables[2].getDbName(), this.testTables[2].getTableName());
        fetched = this.client.getUniqueConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
    }

    @Test
    public void createTableWithConstraintsPk() throws TException {
        String constraintName = "ctwcuc";
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName("table_with_constraints").addCol("col1", "int")).addCol("col2", "varchar(32)")).build(this.metaStore.getConf());
        List uc = ((SQLUniqueConstraintBuilder)((SQLUniqueConstraintBuilder)((SQLUniqueConstraintBuilder)new SQLUniqueConstraintBuilder().onTable(table)).addColumn("col1")).setConstraintName(constraintName)).build(this.metaStore.getConf());
        this.client.createTableWithConstraints(table, null, null, uc, null, null, null);
        UniqueConstraintsRequest rqst = new UniqueConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        List fetched = this.client.getUniqueConstraints(rqst);
        Assert.assertEquals((long)1L, (long)fetched.size());
        Assert.assertEquals((Object)table.getDbName(), (Object)((SQLUniqueConstraint)fetched.get(0)).getTable_db());
        Assert.assertEquals((Object)table.getTableName(), (Object)((SQLUniqueConstraint)fetched.get(0)).getTable_name());
        Assert.assertEquals((Object)"col1", (Object)((SQLUniqueConstraint)fetched.get(0)).getColumn_name());
        Assert.assertEquals((long)1L, (long)((SQLUniqueConstraint)fetched.get(0)).getKey_seq());
        Assert.assertEquals((Object)constraintName, (Object)((SQLUniqueConstraint)fetched.get(0)).getUk_name());
        Assert.assertTrue((boolean)((SQLUniqueConstraint)fetched.get(0)).isEnable_cstr());
        Assert.assertFalse((boolean)((SQLUniqueConstraint)fetched.get(0)).isValidate_cstr());
        Assert.assertFalse((boolean)((SQLUniqueConstraint)fetched.get(0)).isRely_cstr());
        Assert.assertEquals((Object)table.getCatName(), (Object)((SQLUniqueConstraint)fetched.get(0)).getCatName());
        this.client.dropConstraint(table.getCatName(), table.getDbName(), table.getTableName(), constraintName);
        rqst = new UniqueConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        fetched = this.client.getUniqueConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
    }

    @Test
    public void createTableWithConstraintsPkInOtherCatalog() throws TException {
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName("table_in_other_catalog_with_constraints").inDb(this.inOtherCatalog).addCol("col1", "int")).addCol("col2", "varchar(32)")).build(this.metaStore.getConf());
        List uc = ((SQLUniqueConstraintBuilder)((SQLUniqueConstraintBuilder)new SQLUniqueConstraintBuilder().onTable(table)).addColumn("col1")).build(this.metaStore.getConf());
        this.client.createTableWithConstraints(table, null, null, uc, null, null, null);
        UniqueConstraintsRequest rqst = new UniqueConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        List fetched = this.client.getUniqueConstraints(rqst);
        Assert.assertEquals((long)1L, (long)fetched.size());
        Assert.assertEquals((Object)table.getDbName(), (Object)((SQLUniqueConstraint)fetched.get(0)).getTable_db());
        Assert.assertEquals((Object)table.getTableName(), (Object)((SQLUniqueConstraint)fetched.get(0)).getTable_name());
        Assert.assertEquals((Object)"col1", (Object)((SQLUniqueConstraint)fetched.get(0)).getColumn_name());
        Assert.assertEquals((long)1L, (long)((SQLUniqueConstraint)fetched.get(0)).getKey_seq());
        Assert.assertEquals((Object)(table.getTableName() + "_unique_constraint"), (Object)((SQLUniqueConstraint)fetched.get(0)).getUk_name());
        String tablePkName = ((SQLUniqueConstraint)fetched.get(0)).getUk_name();
        Assert.assertTrue((boolean)((SQLUniqueConstraint)fetched.get(0)).isEnable_cstr());
        Assert.assertFalse((boolean)((SQLUniqueConstraint)fetched.get(0)).isValidate_cstr());
        Assert.assertFalse((boolean)((SQLUniqueConstraint)fetched.get(0)).isRely_cstr());
        Assert.assertEquals((Object)table.getCatName(), (Object)((SQLUniqueConstraint)fetched.get(0)).getCatName());
        this.client.dropConstraint(table.getCatName(), table.getDbName(), table.getTableName(), tablePkName);
        rqst = new UniqueConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        fetched = this.client.getUniqueConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
    }

    @Test
    public void doubleAddUniqueConstraint() throws TException {
        Table table = this.testTables[0];
        UniqueConstraintsRequest rqst = new UniqueConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        List fetched = this.client.getUniqueConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
        List uc = ((SQLUniqueConstraintBuilder)((SQLUniqueConstraintBuilder)new SQLUniqueConstraintBuilder().onTable(table)).addColumn("col1")).build(this.metaStore.getConf());
        this.client.addUniqueConstraint(uc);
        try {
            uc = ((SQLUniqueConstraintBuilder)((SQLUniqueConstraintBuilder)new SQLUniqueConstraintBuilder().onTable(table)).addColumn("col2")).build(this.metaStore.getConf());
            this.client.addUniqueConstraint(uc);
            Assert.fail();
        }
        catch (InvalidObjectException | TApplicationException throwable) {
            // empty catch block
        }
    }

    @Test
    public void addNoSuchTable() throws TException {
        try {
            List uc = ((SQLUniqueConstraintBuilder)((SQLUniqueConstraintBuilder)new SQLUniqueConstraintBuilder().setTableName("nosuch")).addColumn("col2")).build(this.metaStore.getConf());
            this.client.addUniqueConstraint(uc);
            Assert.fail();
        }
        catch (InvalidObjectException | TApplicationException throwable) {
            // empty catch block
        }
    }

    @Test
    public void getNoSuchTable() throws TException {
        UniqueConstraintsRequest rqst = new UniqueConstraintsRequest("hive", "default", "nosuch");
        List uc = this.client.getUniqueConstraints(rqst);
        Assert.assertTrue((boolean)uc.isEmpty());
    }

    @Test
    public void getNoSuchDb() throws TException {
        UniqueConstraintsRequest rqst = new UniqueConstraintsRequest("hive", "nosuch", this.testTables[0].getTableName());
        List uc = this.client.getUniqueConstraints(rqst);
        Assert.assertTrue((boolean)uc.isEmpty());
    }

    @Test
    public void getNoSuchCatalog() throws TException {
        UniqueConstraintsRequest rqst = new UniqueConstraintsRequest("nosuch", this.testTables[0].getDbName(), this.testTables[0].getTableName());
        List uc = this.client.getUniqueConstraints(rqst);
        Assert.assertTrue((boolean)uc.isEmpty());
    }
}

