/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.viewer;

import com.google.protobuf.Message;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.ServletUtil;
import org.apache.htrace.protobuf.generated.SpanProtos;
import org.apache.htrace.viewer.HBaseSpanViewer;

public class HBaseSpanViewerSpansServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(HBaseSpanViewerSpansServlet.class);
    public static final String PREFIX = "/getspans";
    private static final ThreadLocal<HBaseSpanViewer> tlviewer = new ThreadLocal<HBaseSpanViewer>(){

        @Override
        protected HBaseSpanViewer initialValue() {
            return null;
        }
    };

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = HBaseSpanViewerSpansServlet.validatePath(ServletUtil.getDecodedPath((HttpServletRequest)request, (String)PREFIX));
        if (path == null) {
            response.setContentType("text/plain");
            response.getWriter().print("Invalid input");
            return;
        }
        HBaseSpanViewer viewer = tlviewer.get();
        if (viewer == null) {
            Configuration conf = (Configuration)this.getServletContext().getAttribute("htrace.conf");
            viewer = new HBaseSpanViewer(conf);
            tlviewer.set(viewer);
        }
        Long traceid = Long.parseLong(path.substring(1));
        response.setContentType("application/javascript");
        PrintWriter out = response.getWriter();
        out.print("[");
        boolean first = true;
        for (SpanProtos.Span span : viewer.getSpans(traceid)) {
            if (first) {
                first = false;
            } else {
                out.print(",");
            }
            out.print(HBaseSpanViewer.toJsonString((Message)span));
        }
        out.print("]");
    }

    public void init() throws ServletException {
    }

    public void destroy() {
        HBaseSpanViewer viewer = tlviewer.get();
        if (viewer != null) {
            viewer.close();
        }
    }

    public static String validatePath(String p) {
        return p == null || p.length() == 0 ? null : new Path(p).toUri().getPath();
    }
}

