/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestEntityBuilder {
    @Test
    public void testBuildEmptyEntity() throws Exception {
        Assertions.assertThrows(IllegalStateException.class, () -> EntityBuilder.create().build());
    }

    @Test
    public void testBuildTextEntity() throws Exception {
        HttpEntity entity = EntityBuilder.create().setText("stuff").build();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertNotNull((Object)entity.getContent());
        Assertions.assertNotNull((Object)entity.getContentType());
        Assertions.assertEquals((Object)"text/plain; charset=ISO-8859-1", (Object)entity.getContentType());
    }

    @Test
    public void testBuildBinaryEntity() throws Exception {
        HttpEntity entity = EntityBuilder.create().setBinary(new byte[]{0, 1, 2}).build();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertNotNull((Object)entity.getContent());
        Assertions.assertNotNull((Object)entity.getContentType());
        Assertions.assertEquals((Object)"application/octet-stream", (Object)entity.getContentType());
    }

    @Test
    public void testBuildStreamEntity() throws Exception {
        InputStream in = (InputStream)Mockito.mock(InputStream.class);
        HttpEntity entity = EntityBuilder.create().setStream(in).build();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertNotNull((Object)entity.getContent());
        Assertions.assertNotNull((Object)entity.getContentType());
        Assertions.assertEquals((long)-1L, (long)entity.getContentLength());
        Assertions.assertEquals((Object)"application/octet-stream", (Object)entity.getContentType());
    }

    @Test
    public void testBuildSerializableEntity() throws Exception {
        HttpEntity entity = EntityBuilder.create().setSerializable((Serializable)Boolean.TRUE).build();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertNotNull((Object)entity.getContent());
        Assertions.assertNotNull((Object)entity.getContentType());
        Assertions.assertEquals((Object)"application/octet-stream", (Object)entity.getContentType());
    }

    @Test
    public void testBuildFileEntity() throws Exception {
        File file = new File("stuff");
        HttpEntity entity = EntityBuilder.create().setFile(file).build();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertNotNull((Object)entity.getContentType());
        Assertions.assertEquals((Object)"application/octet-stream", (Object)entity.getContentType());
    }

    @Test
    public void testExplicitContentProperties() throws Exception {
        HttpEntity entity = EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setContentEncoding("identity").setBinary(new byte[]{0, 1, 2}).setText("{\"stuff\"}").build();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertNotNull((Object)entity.getContentType());
        Assertions.assertEquals((Object)"application/json; charset=UTF-8", (Object)entity.getContentType());
        Assertions.assertNotNull((Object)entity.getContentEncoding());
        Assertions.assertEquals((Object)"identity", (Object)entity.getContentEncoding());
        Assertions.assertEquals((Object)"{\"stuff\"}", (Object)EntityUtils.toString((HttpEntity)entity));
    }

    @Test
    public void testBuildChunked() throws Exception {
        HttpEntity entity = EntityBuilder.create().setText("stuff").chunked().build();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertTrue((boolean)entity.isChunked());
    }

    @Test
    public void testBuildGZipped() throws Exception {
        HttpEntity entity = EntityBuilder.create().setText("stuff").gzipCompressed().build();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertNotNull((Object)entity.getContentType());
        Assertions.assertEquals((Object)"text/plain; charset=ISO-8859-1", (Object)entity.getContentType());
        Assertions.assertNotNull((Object)entity.getContentEncoding());
        Assertions.assertEquals((Object)"gzip", (Object)entity.getContentEncoding());
    }
}

